def chgext(dir, from, to)
	raise "dir not specified" unless dir
	raise "from not specified" unless from
	raise "to not specified" unless to
	dir = '.' if dir.empty?
	Dir::glob("#{dir}/**/*.#{from}"){|sfile|
		tfile = sfile.sub(/\.#{Regexp::escape(from)}$/, ".#{to}")
		puts "rename #{sfile} #{tfile}"
		File::rename(sfile, tfile)
	}
end

if __FILE__ == $0 then
	begin
		dir, from, to = ARGV
		chgext(*ARGV)
	rescue
		puts <<EOS
Usage: #{$0} 'dir' 'from-ext' 'to-ext'
The extensions of files under the current directory are changed from 'from-ext' to 'to-ext'.
EOS
	end
end
