#from pyfasttext import FastText
import time, MySQLdb, configparser, os, subprocess, codecs

from write_project_ini import write_pro_ini
from main_config import main_Config

def re_class(project):
#    config=configparser.ConfigParser()
#    config.read('main.ini')
#    mysql_id=config['settings']["id"]
#    mysql_pass=config['settings']["pass"]
#    using_os=config['settings']["os"]
    mysql_id, mysql_pass, projects, root_path, using_os = main_Config()

    cfg=configparser.ConfigParser()
    file_path = project + ".ini"
    cfg.read(file_path)
    sampling=cfg['project']["sample"]


    reset(project, mysql_id, mysql_pass)
    time.sleep(0.1)

    contents= import_from_mysql(project, mysql_id, mysql_pass, sampling)
    time.sleep(0.1)
    label_dic = category_label(project, mysql_id, mysql_pass, using_os)
    time.sleep(0.1)
    disc = discrimination(project, contents, label_dic)
    time.sleep(0.1)
    insert_db(project, mysql_id, mysql_pass, disc)
    time.sleep(0.1)

    time.sleep(0.1)
    write_pro_ini(project).main(
    discrimination="1"
    )

    time.sleep(0.1)
    encode_temp_path = os.getcwd() + "/encode_temp.txt"
    print(encode_temp_path)
    if os.path.isfile(encode_temp_path) == True:
        os.remove(encode_temp_path)
    else:
        print("A")

def insert_db(project, mysql_id, mysql_pass, disc):
    conn=MySQLdb.connect(db=project, user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
    cursor=conn.cursor()

    sql="update text_table set disc_code = %s where sentence_id = %s"
    cursor.executemany(sql,disc)
    time.sleep(0.1)

    conn.commit()
    cursor.close()
    conn.close()

    time.sleep(0.1)



def discrimination(project, content, label_dic):
    #path = os.getcwd() + "/fasttext/" + project + ".bin"
    #model = FastText(path)

    return_result = []
    #test_result=[]#########################
    for n in content:
        sentence_id = n[0]
        category = n[1]
        label = n[2]
        predicted_label = n[3]


        #result = model.predict_proba_single(text_for_disc)  #引数に「k=2」を加えると、類似度第2位まで計算できる
        #predicted_label = (result[0])[0].replace(",","")
        if predicted_label == label:
            a = (1, sentence_id)    #1はdisc_codeでラベルが一致したということ
            return_result.append(a)
            #predicted_category= label_dic[predicted_label]#########################
            #b=(1,sentence_id,label, predicted_label,category,predicted_category)#########################
        else:                       #ここから先はdisc_codeの２か３
            predicted_category = label_dic[predicted_label]
            if predicted_category == category:
                a = (2, sentence_id)    #2はdisc_codeでカテゴリーが一致したということ
                return_result.append(a)
                #b=(2,sentence_id,label, predicted_label,category,predicted_category)#########################
                #test_result.append(b)#########################
            else:
                a = (3, sentence_id)    #3はdisc_codeでカテゴリーも不一致したということ
                return_result.append(a)
                #b=(3,sentence_id,label, predicted_label,category,predicted_category)#########################
                #test_result.append(b)#########################

    #print(return_result)
    return return_result

def category_label(project, mysql_id, mysql_pass, using_os):

    try:
        conn=MySQLdb.connect(db=project, user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
        cursor=conn.cursor()

        sql = "select label_name, category_name, count(*) from text_table group by category_name, label_name"
        cursor.execute(sql)

        contents=list(cursor.fetchall())
        time.sleep(0.1)

        conn.commit()
        cursor.close()
        conn.close()

        time.sleep(0.1)

        if using_os == "posix":
            label_dic={}
            for n in contents:
                label=n[0]
                category=n[1]
                label_dic[label]=category
            return label_dic
#########################################################################
        elif using_os == "nt":
            label_dic={}
            for n in contents:
                category=n[1]
                label=n[0] + "\r"
                label_dic[label]=category

            return label_dic
#########################################################################



    except Exception as e:
        print(e)

def import_from_mysql(project, mysql_id, mysql_pass, sampling):
    sentence_id, category, label = make_label(project, mysql_id, mysql_pass, sampling)
    time.sleep(0.1)
    texts = make_text(project, mysql_id, mysql_pass, sampling)

    #print(texts)

    res=[]
    for (m,n,o,p) in zip(sentence_id, category, label, texts):
        ida = m
        categorya = n
        labela=o
        texta=p
        a=(ida, categorya, labela, texta)
        res.append(a)

    return res

def make_text(project, mysql_id, mysql_pass, sampling):

    g = codecs.open("encode_temp.txt","w", "utf-8")
    g.write("")
    g.close

    if int(sampling) == 0 or int(sampling) == 10:
        sql="select morpheme from text_table"
    elif int(sampling) == 1 or int(sampling) == 11:
        sql="select morpheme from text_table where sampling = 1"
    #elif int(sampling) == 10 or int(sampling) ==11:
    #    sql="select morpheme from text_table where train_test_data = 1"

    try:
        conn=MySQLdb.connect(db=project, user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
        cursor=conn.cursor()

        cursor.execute(sql)

        contents=list(cursor.fetchall())
        time.sleep(0.1)

        conn.commit()
        cursor.close()
        conn.close()

        time.sleep(0.1)

        g = codecs.open("encode_temp.txt","a", "utf-8")
        for n in contents:
            #print(n[0])
            #n=n.replace("'",'').replace('"','').replace("'","")
            g.write(n[0])
            g.write("\n")
        g.close()

        path = os.getcwd()
        cmd= path + "/fastText/fasttext predict " + path + "/fastText/" + project + ".bin " + path + "/encode_temp.txt"

        proc = subprocess.Popen(cmd, shell = True, stdin = subprocess.PIPE, stdout = subprocess.PIPE, stderr = subprocess.PIPE)
        stdout_data, stderr_data = proc.communicate() #処理実行を待つ(†1)
        #print(stdout_data)  #標準出力の確認
        #print(stderr_data)  #標準エラーの確認
        proc.wait()

        stdout_data = stdout_data.decode("utf-8")
        stdout_data = stdout_data.split("\n")

        test_data=[]
        for n in stdout_data:
            if n == "":
                pass
            else:
                n=n.replace("__label__","").replace(",","")
                test_data.append(n)

        #print(test_data)

        return test_data


    except Exception as e:
        print(e)

def make_label(project, mysql_id, mysql_pass, sampling):
    if int(sampling) == 0 or int(sampling) == 10:
        sql="select sentence_id, category_name, label_name from text_table"
    elif int(sampling) == 1 or int(sampling) == 11:
        sql="select sentence_id, category_name, label_name from text_table where sampling = 1"
    #elif int(sampling) == 10 or int(sampling) ==11:
    #    sql="select sentence_id, category_name, label_name from text_table where train_test_data = 1"

    try:
        conn=MySQLdb.connect(db=project, user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
        cursor=conn.cursor()

        cursor.execute(sql)

        contents=list(cursor.fetchall())
        time.sleep(0.1)

        conn.commit()
        cursor.close()
        conn.close()

        time.sleep(0.1)

        sentence_id=[]
        category=[]
        label=[]

        for n in contents:
            sentence_id.append(n[0])
            category.append(n[1])
            label.append(n[2])

        return sentence_id, category, label

    except Exception as e:
        print(e)

def reset(project, mysql_id, mysql_pass):
    try:
        conn=MySQLdb.connect(db=project, user=mysql_id, passwd=mysql_pass, charset="utf8mb4")
        cursor=conn.cursor()

        sql="update text_table set disc_code = 0"
        cursor.execute(sql)

        time.sleep(0.1)
        conn.commit()
        cursor.close()
        conn.close()

    except Exception as e:
        print(e)


if __name__=="__main__":
    project="ttt"
    re_class(project)
