package jp.sourceforge.masasa.architecture.framework.validation.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import jp.sourceforge.masasa.architecture.framework.validation.enumeration.CheckRulesEnum;
import jp.sourceforge.masasa.architecture.framework.validation.enumeration.FieldTestEnum;
import jp.sourceforge.masasa.architecture.framework.validation.validator.IValidator;

/**
 * 条件付必須チェックルール用アノテーション.
 * 
 * @author masasa.
 * @see CheckRulesEnum#RequiredIfCheck
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
@ValidateResolver(CheckRulesEnum.RequiredIfCheck)
public @interface CheckRequiredIf {
    /**
     * チェック対象の値がnullの場合にチェックするか否か.
     * <ul>
     * <li><code>true</code>:チェックする.</li>
     * <li><code>false</code>:チェックしない.バリデータ(
     * {@link IValidator#validate(java.lang.annotation.Annotation, String, Object)} )はエラーなし(<code>true</code>)を返却する.</li>
     * </ul>
     */
    boolean verifyWhenNull() default false;

    /**
     * フィールド間の結合条件.
     */
    String fieldJoin() default "AND";

    /**
     * 依存するフィールド名.
     */
    String[] field();

    /**
     * 依存するフィールドの値を検証する際の条件式.
     * 
     * @see FieldTestEnum#FIELD_TEST_EQUAL
     * @see FieldTestEnum#FIELD_TEST_NOTNULL
     * @see FieldTestEnum#FIELD_TEST_NULL
     */
    FieldTestEnum[] fieldTest();

    /**
     * FieldTestEnum#FIELD_TEST_EQUAL時の検証値.
     */
    String[] fieldValue() default "";
    // boolean[] fieldIndexed() default false;
}
