package jp.sourceforge.masasa.architecture.framework.csv.read;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.List;

import jp.sourceforge.masasa.architecture.framework.Constants;
import jp.sourceforge.masasa.architecture.framework.StringUtil;
import jp.sourceforge.masasa.architecture.framework.db.MstGItemBean;
import jp.sourceforge.masasa.architecture.framework.db.write.MstGItemWriter;
import jp.sourceforge.masasa.architecture.framework.validation.AbstractValidator;
import jp.sourceforge.masasa.architecture.framework.validation.Validator;
import au.com.bytecode.opencsv.CSVReader;

public class SampleCSVReader {

	/**
	 * @param args
	 * @throws IOException
	 * @throws SQLException
	 */
	public static void main(String[] args) throws IOException, SQLException {
		// ストリームのインスタンスを生成する
		InputStream inputStream = new FileInputStream(Constants.FILE_NAME);
		// ストリームのリーダーインスタンスを生成する
		InputStreamReader streamReader = new InputStreamReader(inputStream, Constants.DEFAULT_CHARSET);
		// CSVリーダーインスタンスを生成する
		CSVReader reader = new CSVReader(streamReader, CSVReader.DEFAULT_SEPARATOR, CSVReader.DEFAULT_QUOTE_CHARACTER);
		// CSVを全行読み込み、リストに格納する
		List<String[]> list = reader.readAll();
		// ヘッダ行を除去する
		list.remove(0);
		List<MstGItemBean> insertData = StringUtil.getList(MstGItemBean.class, list);
		// 入力チェックのインスタンスを生成する
		AbstractValidator<MstGItemBean> validator = new Validator<MstGItemBean>();
		// 入力チェックを実施する
		validator.validate(insertData);
		if (validator.isValid()) {
			// 入力チェックの結果、エラーがない場合DBにデータを登録する
			MstGItemWriter writer = new MstGItemWriter();
			try {
				// トランザクション開始
				writer.startTransaction();
				// データ挿入
				writer.insert(insertData);
				// コミット
				writer.commitTransaction();
			} finally {
				// トランザクションを終了
				// コミットがコールされていない場合、自動的にロールバックを行い
				// トランザクションを終了させる。コミットがコールされている場合は
				// そのままトランザクションを終了させる。
				writer.endTransaction();
			}
		}
	}

}
