package jp.sourceforge.masasa.architecture.framework.validation.validator;

import java.lang.annotation.Annotation;

import jp.sourceforge.masasa.architecture.framework.validation.annotation.CheckCreditCard;

import org.apache.commons.validator.CreditCardValidator;

/**
 * Checks if the field is a valid credit card number.
 *
 * @author masasa.
 * @see org.apache.struts.validator.FieldChecks#validateCreditCard(Object, org.apache.commons.validator.ValidatorAction,
 *      org.apache.commons.validator.Field, org.apache.struts.action.ActionMessages,
 *      org.apache.commons.validator.Validator, javax.servlet.http.HttpServletRequest)
 */
@SuppressWarnings("javadoc")
public class ValidateCreditCard implements IValidator {

    /**
     * Checks if the field is a valid credit card number.
     *
     * @param anno
     *            バリデーションに対応するアノテーション.
     * @param targetValue
     *            検証値.
     * @param lineObject
     *            Beanが所属するオブジェクト.
     * @return バリデーション結果.
     *         <ul>
     *         <li><code>true</code>:エラーなし.</li>
     *         <li><code>false</code>:エラーあり.</li>
     *         </ul>
     * @see jp.sourceforge.masasa.architecture.framework.validation.validator.IValidator #validate(java
     *      .lang.annotation.Annotation, java.lang.String, java.lang.Object)
     */
    @Override
    public boolean validate(final Annotation anno, final String targetValue, final Object lineObject) {
        CheckCreditCard resolver = (CheckCreditCard) anno;
        if (!resolver.verifyWhenNull() && targetValue == null) return true;
        if (resolver.options().length == 1 && resolver.options()[0] == -1) return new CreditCardValidator()
                .isValid(targetValue);
        int option = 0;
        for (int i : resolver.options()) {
            option += i;
        }
        return new CreditCardValidator(option).isValid(targetValue);
    }

}
