package jp.sourceforge.masasa.architecture.framework.validation;

import jp.sourceforge.masasa.architecture.framework.validation.util.StringUtil;

import org.apache.commons.validator.ValidatorException;

/**
 * 入力チェックを実行するクラス.
 *
 * @author masasa.
 * @param <T>
 *            チェック対象のBean.
 */
public class Validator<T> extends AbstractValidator<T> {

    /*
     * (非 Javadoc)
     * @see jp.sourceforge.masasa.architecture.framework.validation.AbstractValidator #loggingStart()
     */
    @Override
    protected void loggingStart() {
        if (!LOGGER.isInfoEnabled()) return;
        StringBuilder buf = new StringBuilder();
        buf.append("[INFO] "); //$NON-NLS-1$
        buf.append("validation check was started. "); //$NON-NLS-1$
        if (this.targetBean != null) buf.append("target is ").append(this.targetBean.getClass().getName()); //$NON-NLS-1$
        LOGGER.info(buf);
    }

    /*
     * (非 Javadoc)
     * @see jp.sourceforge.masasa.architecture.framework.validation.AbstractValidator #loggingEnd()
     */
    @Override
    protected void loggingEnd() {
        if (!LOGGER.isInfoEnabled()) return;
        StringBuilder buf = new StringBuilder();
        buf.append("[INFO] "); //$NON-NLS-1$
        buf.append("validation check was finished."); //$NON-NLS-1$
        LOGGER.info(buf);
    }

    /*
     * (非 Javadoc)
     * @see jp.sourceforge.masasa.architecture.framework.validation.AbstractValidator #loggingResult()
     */
    @Override
    protected void loggingResult() {
        if (!LOGGER.isInfoEnabled()) return;
        StringBuilder buf;
        if (this.errors.isEmpty()) {
            // エラーがない場合
            buf = new StringBuilder();
            buf.append("[INFO] "); //$NON-NLS-1$
            buf.append("there was not the error."); //$NON-NLS-1$
            LOGGER.info(buf);
            return;
        }
        for (ValidateResult result : this.errors.getResults()) {
            // エラーがある場合
            buf = new StringBuilder();
            buf.append("[INFO] "); //$NON-NLS-1$
            buf.append("    Line") //$NON-NLS-1$
                    .append(StringUtil.paddingZero(result.getLine() + 1, String.valueOf(this.totalLine).length()));
            buf.append(" : "); //$NON-NLS-1$
            buf.append("fieldName=[") //$NON-NLS-1$
                    .append(result.getFieldName()).append("], "); //$NON-NLS-1$
            buf.append("checkRule=[") //$NON-NLS-1$
                    .append(result.getCheckRule()).append("], "); //$NON-NLS-1$
            buf.append("target=[") //$NON-NLS-1$
                    .append(result.getTargetValue()).append("], "); //$NON-NLS-1$
            buf.append("result=[") //$NON-NLS-1$
                    .append(result.isValid()).append("]"); //$NON-NLS-1$
            LOGGER.info(buf);
        }
    }

    /*
     * (非 Javadoc)
     * @see jp.sourceforge.masasa.architecture.framework.validation.AbstractValidator
     * #loggingTerminate(org.apache.commons.validator.ValidatorException)
     */
    @Override
    protected void loggingTerminate(ValidatorException e) {
        if (!LOGGER.isInfoEnabled()) return;
        StringBuilder buf = new StringBuilder();
        buf.append("[INFO] "); //$NON-NLS-1$
        buf.append("was forced to stop validation checks. "); //$NON-NLS-1$
        buf.append("because ... "); //$NON-NLS-1$
        buf.append(e.getMessage());
        LOGGER.info(buf);
    }

}
