/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawCommonAccessor;

class LongRawAccessor
extends RawCommonAccessor {
    OracleInputStream stream;
    int columnPosition = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:42:12_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    LongRawAccessor(OracleStatement oracleStatement, int n2, int n3, short s2, int n4) throws SQLException {
        this.init(oracleStatement, 24, 24, s2, false);
        this.columnPosition = n2;
        this.initForDataAccess(n4, n3, null);
    }

    LongRawAccessor(OracleStatement oracleStatement, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s2) throws SQLException {
        this.init(oracleStatement, 24, 24, s2, false);
        this.columnPosition = n2;
        this.initForDescribe(24, n3, bl, n4, n5, n6, n7, n8, s2, null);
        int n9 = oracleStatement.maxFieldSize;
        if (n9 > 0 && (n3 == 0 || n9 < n3)) {
            n3 = n9;
        }
        this.initForDataAccess(0, n3, null);
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.isStream = true;
        this.isColumnNumberAware = true;
        this.internalTypeMaxLength = Integer.MAX_VALUE;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = 0;
        this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
    }

    @Override
    OracleInputStream initForNewRow() throws SQLException {
        this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
        return this.stream;
    }

    @Override
    void updateColumnNumber(int n2) {
        this.columnPosition = ++n2;
        if (this.stream != null) {
            this.stream.columnIndex = n2;
        }
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1 && this.stream != null) {
            if (this.stream.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byte[] byArray2 = new byte[1024];
            try {
                int n3;
                while ((n3 = this.stream.read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n3);
                }
            }
            catch (IOException iOException) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1 && this.stream != null) {
            if (this.stream.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            inputStream = physicalConnection.conversion.ConvertStream(this.stream, 2);
        }
        return inputStream;
    }

    @Override
    InputStream getUnicodeStream(int n2) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1 && this.stream != null) {
            if (this.stream.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            inputStream = physicalConnection.conversion.ConvertStream(this.stream, 3);
        }
        return inputStream;
    }

    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        Reader reader = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1 && this.stream != null) {
            if (this.stream.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            reader = physicalConnection.conversion.ConvertCharacterStream(this.stream, 8);
        }
        return reader;
    }

    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        InputStream inputStream = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1 && this.stream != null) {
            if (this.stream.closed) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            PhysicalConnection physicalConnection = this.statement.connection;
            inputStream = physicalConnection.conversion.ConvertStream(this.stream, 6);
        }
        return inputStream;
    }

    @Override
    public String toString() {
        return "LongRawAccessor@" + Integer.toHexString(this.hashCode()) + "{columnPosition = " + this.columnPosition + "}";
    }
}

