/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.rest.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.osdn.util.json.jackson.JacksonDatetimeModule;
import net.osdn.util.rest.client.HttpException;
import net.osdn.util.rest.client.JsonObjectIterable;
import net.osdn.util.rest.client.JsonObjectIterator;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;

public class Server {
    private static ObjectMapper mapper;
    private static JsonFactory factory;
    private static final MediaType APPLICATION_JSON;
    private static String url;
    private static String username;
    private static String password;
    private static Proxy proxy;
    private static long connectTimeoutValue;
    private static TimeUnit connectTimeoutUnit;
    private static long readTimeoutValue;
    private static TimeUnit readTimeoutUnit;
    private static long writeTimeoutValue;
    private static TimeUnit writeTimeoutUnit;
    private static int maxIdleConnections;
    private static long keepAliveDurationValue;
    private static TimeUnit keepAliveDurationUnit;
    private static ConnectionPool connectionPool;
    private static ThreadLocal<Instance> instances;

    public static Instance newInstance() {
        return new Instance();
    }

    public static synchronized void setUrl(String url, String username, String password) {
        Server.url = url;
        Server.username = username;
        Server.password = password;
    }

    public static synchronized void setUrl(String url, String username, String password, Proxy proxy) {
        Server.url = url;
        Server.username = username;
        Server.password = password;
        Server.proxy = proxy;
    }

    public static synchronized void setUrl(String url) {
        Server.url = url;
    }

    public static synchronized void setUsername(String username) {
        Server.username = username;
    }

    public static synchronized void setPassword(String password) {
        Server.password = password;
    }

    public static synchronized void setConnectTimeout(long timeout, TimeUnit unit) {
        connectTimeoutValue = timeout;
        connectTimeoutUnit = unit;
    }

    public static synchronized void setReadTimeout(long timeout, TimeUnit unit) {
        readTimeoutValue = timeout;
        readTimeoutUnit = unit;
    }

    public static synchronized void setWriteTimeout(long timeout, TimeUnit unit) {
        writeTimeoutValue = timeout;
        writeTimeoutUnit = unit;
    }

    public static synchronized void setConnectionPool(int maxIdleConnections, long keepAliveDuration, TimeUnit unit) {
        Server.maxIdleConnections = maxIdleConnections;
        keepAliveDurationValue = keepAliveDuration;
        keepAliveDurationUnit = unit;
    }

    public static Instance path(String segment) {
        return instances.get().reset().path(segment);
    }

    public static Instance path(String ... segments) {
        return instances.get().reset().path(segments);
    }

    public static Instance param(String name, String value) {
        return instances.get().reset().param(name, value);
    }

    public static Instance param(String name, Number value) {
        return instances.get().reset().param(name, value);
    }

    public static Instance param(String name, Date value) {
        return instances.get().reset().param(name, value);
    }

    public static Instance param(String name, LocalDateTime value) {
        return instances.get().reset().param(name, value);
    }

    public static Instance param(String name, LocalDate value) {
        return instances.get().reset().param(name, value);
    }

    public static Instance param(String name, LocalTime value) {
        return instances.get().reset().param(name, value);
    }

    public static Instance param(String name, OffsetDateTime value) {
        return instances.get().reset().param(name, value);
    }

    public static Instance param(String name, Object value) {
        return instances.get().reset().param(name, value);
    }

    public static Instance param(String name, OffsetTime value) {
        return instances.get().reset().param(name, value);
    }

    public static Instance param(String name, YearMonth value) {
        return instances.get().reset().param(name, value);
    }

    public static Instance body(Object body) throws JsonProcessingException {
        return instances.get().reset().body(body);
    }

    public static Instance body(RequestBody body) {
        return instances.get().reset().body(body);
    }

    public static Instance multipart() {
        return instances.get().reset().multipart();
    }

    public static Instance form(String name, Object value) throws JsonProcessingException {
        return instances.get().reset().form(name, value);
    }

    protected static String getString(Response response) throws JsonParseException, IOException {
        InputStream in = response.body().byteStream();
        JsonParser parser = factory.createParser(in);
        return Server.getString(parser);
    }

    protected static String getString(JsonParser parser) throws JsonParseException, IOException {
        JsonToken token;
        String value = null;
        block8: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case VALUE_NUMBER_INT: {
                    value = parser.getValueAsString();
                    break block8;
                }
                case VALUE_NUMBER_FLOAT: {
                    value = parser.getValueAsString();
                    break block8;
                }
                case VALUE_STRING: {
                    value = parser.getValueAsString();
                    break block8;
                }
                case VALUE_TRUE: {
                    value = parser.getValueAsString();
                    break block8;
                }
                case VALUE_FALSE: {
                    value = parser.getValueAsString();
                    break block8;
                }
                case VALUE_NULL: {
                    value = null;
                    break block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        return value;
    }

    protected static Boolean getBoolean(Response response) throws JsonParseException, IOException {
        InputStream in = response.body().byteStream();
        JsonParser parser = factory.createParser(in);
        return Server.getBoolean(parser);
    }

    protected static Boolean getBoolean(JsonParser parser) throws JsonParseException, IOException {
        JsonToken token;
        Boolean value = null;
        block8: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case VALUE_NUMBER_INT: {
                    value = parser.getValueAsInt() != 0;
                    break block8;
                }
                case VALUE_NUMBER_FLOAT: {
                    value = parser.getValueAsInt() != 0;
                    break block8;
                }
                case VALUE_STRING: {
                    String s = parser.getValueAsString();
                    if (s == null) break block8;
                    if ((s = s.toLowerCase().trim()).equals("true")) {
                        value = Boolean.TRUE;
                        break block8;
                    }
                    if (!s.equals("false")) break block8;
                    value = Boolean.FALSE;
                    break block8;
                }
                case VALUE_TRUE: {
                    value = Boolean.TRUE;
                    break block8;
                }
                case VALUE_FALSE: {
                    value = Boolean.FALSE;
                    break block8;
                }
                case VALUE_NULL: {
                    value = null;
                    break block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        return value;
    }

    protected static Integer getInteger(Response response) throws JsonParseException, IOException {
        InputStream in = response.body().byteStream();
        JsonParser parser = factory.createParser(in);
        return Server.getInteger(parser);
    }

    protected static Integer getInteger(JsonParser parser) throws JsonParseException, IOException {
        JsonToken token;
        Integer value = null;
        block8: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case VALUE_NUMBER_INT: {
                    value = parser.getValueAsInt();
                    break block8;
                }
                case VALUE_NUMBER_FLOAT: {
                    value = parser.getValueAsInt();
                    break block8;
                }
                case VALUE_STRING: {
                    value = parser.getValueAsInt();
                    break block8;
                }
                case VALUE_TRUE: {
                    value = 1;
                    break block8;
                }
                case VALUE_FALSE: {
                    value = 0;
                    break block8;
                }
                case VALUE_NULL: {
                    value = null;
                    break block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        return value;
    }

    protected static Long getLong(Response response) throws JsonParseException, IOException {
        InputStream in = response.body().byteStream();
        JsonParser parser = factory.createParser(in);
        return Server.getLong(parser);
    }

    protected static Long getLong(JsonParser parser) throws JsonParseException, IOException {
        JsonToken token;
        Long value = null;
        block8: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case VALUE_NUMBER_INT: {
                    value = parser.getValueAsLong();
                    break block8;
                }
                case VALUE_NUMBER_FLOAT: {
                    value = parser.getValueAsLong();
                    break block8;
                }
                case VALUE_STRING: {
                    value = parser.getValueAsLong();
                    break block8;
                }
                case VALUE_TRUE: {
                    value = 1L;
                    break block8;
                }
                case VALUE_FALSE: {
                    value = 0L;
                    break block8;
                }
                case VALUE_NULL: {
                    value = null;
                    break block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        return value;
    }

    protected static Float getFloat(Response response) throws JsonParseException, IOException {
        InputStream in = response.body().byteStream();
        JsonParser parser = factory.createParser(in);
        return Server.getFloat(parser);
    }

    protected static Float getFloat(JsonParser parser) throws JsonParseException, IOException {
        JsonToken token;
        Float value = null;
        block8: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case VALUE_NUMBER_INT: {
                    value = Float.valueOf(parser.getValueAsInt());
                    break block8;
                }
                case VALUE_NUMBER_FLOAT: {
                    value = Float.valueOf((float)parser.getValueAsDouble());
                    break block8;
                }
                case VALUE_STRING: {
                    value = Float.valueOf((float)parser.getValueAsDouble());
                    break block8;
                }
                case VALUE_TRUE: {
                    value = Float.valueOf(1.0f);
                    break block8;
                }
                case VALUE_FALSE: {
                    value = Float.valueOf(0.0f);
                    break block8;
                }
                case VALUE_NULL: {
                    value = null;
                    break block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        return value;
    }

    protected static Double getDouble(Response response) throws JsonParseException, IOException {
        InputStream in = response.body().byteStream();
        JsonParser parser = factory.createParser(in);
        return Server.getDouble(parser);
    }

    protected static Double getDouble(JsonParser parser) throws JsonParseException, IOException {
        JsonToken token;
        Double value = null;
        block8: while ((token = parser.nextToken()) != null) {
            switch (token) {
                case VALUE_NUMBER_INT: {
                    value = parser.getValueAsInt();
                    break block8;
                }
                case VALUE_NUMBER_FLOAT: {
                    value = parser.getValueAsDouble();
                    break block8;
                }
                case VALUE_STRING: {
                    value = parser.getValueAsDouble();
                    break block8;
                }
                case VALUE_TRUE: {
                    value = 1.0;
                    break block8;
                }
                case VALUE_FALSE: {
                    value = 0.0;
                    break block8;
                }
                case VALUE_NULL: {
                    value = null;
                    break block8;
                }
                default: {
                    continue block8;
                }
            }
        }
        return value;
    }

    protected static int getRowCount(Response response) {
        try {
            String s = response.header("X-RowCount");
            if (s != null && !s.isEmpty()) {
                return Integer.parseInt(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    protected static int getColumnCount(Response response) {
        try {
            String s = response.header("X-ColumnCount");
            if (s != null && !s.isEmpty()) {
                return Integer.parseInt(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private static String toJSON(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        APPLICATION_JSON = MediaType.parse((String)"application/json; charset=utf-8");
        connectTimeoutValue = 10L;
        connectTimeoutUnit = TimeUnit.SECONDS;
        readTimeoutValue = 10L;
        readTimeoutUnit = TimeUnit.SECONDS;
        writeTimeoutValue = 10L;
        writeTimeoutUnit = TimeUnit.SECONDS;
        maxIdleConnections = 5;
        keepAliveDurationValue = 5L;
        keepAliveDurationUnit = TimeUnit.MINUTES;
        instances = new ThreadLocal<Instance>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Instance initialValue() {
                Instance instance = new Instance();
                Class<Server> clazz = Server.class;
                synchronized (Server.class) {
                    instance.setUrl(url);
                    instance.setUsername(username);
                    instance.setPassword(password);
                    instance.setProxy(proxy);
                    instance.setConnectTimeout(connectTimeoutValue, connectTimeoutUnit);
                    instance.setReadTimeout(readTimeoutValue, readTimeoutUnit);
                    instance.setWriteTimeout(writeTimeoutValue, writeTimeoutUnit);
                    if (connectionPool == null) {
                        connectionPool = new ConnectionPool(maxIdleConnections, keepAliveDurationValue, keepAliveDurationUnit);
                    }
                    instance.setConnectionPool(connectionPool);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return instance;
                }
            }
        };
        mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JacksonDatetimeModule datetimeModule = new JacksonDatetimeModule();
        mapper.registerModule((Module)datetimeModule);
        factory = mapper.getFactory();
    }

    public static class BasicAuthenticator
    implements Authenticator {
        private String username;
        private String password;

        public BasicAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public Request authenticate(Route route, Response response) throws IOException {
            String credential = Credentials.basic((String)this.username, (String)this.password);
            return response.request().newBuilder().header("Authorization", credential).build();
        }
    }

    public static class Instance {
        private String url;
        private String username;
        private String password;
        private Proxy proxy;
        private long connectTimeoutValue;
        private TimeUnit connectTimeoutUnit;
        private long readTimeoutValue;
        private TimeUnit readTimeoutUnit;
        private long writeTimeoutValue;
        private TimeUnit writeTimeoutUnit;
        private ConnectionPool connectionPool;
        private OkHttpClient client;
        private HttpUrl httpUrl;
        private String authorization;
        private List<String> pathSegments = new ArrayList<String>();
        private Map<String, String> queryParameters = new LinkedHashMap<String, String>();
        private RequestBody requestBody;
        private boolean useMultipart;
        private Map<String, Object> formData;

        protected Instance() {
        }

        public void setUrl(String url) {
            this.url = url;
            this.client = null;
            this.httpUrl = null;
            this.authorization = null;
        }

        public void setUsername(String username) {
            this.username = username;
            this.client = null;
            this.httpUrl = null;
            this.authorization = null;
        }

        public void setPassword(String password) {
            this.password = password;
            this.client = null;
            this.httpUrl = null;
            this.authorization = null;
        }

        public void setProxy(Proxy proxy) {
            this.proxy = proxy;
            this.client = null;
            this.httpUrl = null;
            this.authorization = null;
        }

        public void setConnectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeoutValue = timeout;
            this.connectTimeoutUnit = unit;
            this.client = null;
            this.httpUrl = null;
            this.authorization = null;
        }

        public void setReadTimeout(long timeout, TimeUnit unit) {
            this.readTimeoutValue = timeout;
            this.readTimeoutUnit = unit;
            this.client = null;
            this.httpUrl = null;
            this.authorization = null;
        }

        public void setWriteTimeout(long timeout, TimeUnit unit) {
            this.writeTimeoutValue = timeout;
            this.writeTimeoutUnit = unit;
            this.client = null;
            this.httpUrl = null;
            this.authorization = null;
        }

        public void setConnectionPool(int maxIdleConnections, long keepAliveDuration, TimeUnit unit) {
            this.setConnectionPool(new ConnectionPool(maxIdleConnections, keepAliveDuration, unit));
        }

        public void setConnectionPool(ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
            this.client = null;
            this.httpUrl = null;
            this.authorization = null;
        }

        protected OkHttpClient getClient() {
            if (this.client == null) {
                if (this.connectionPool == null) {
                    this.connectionPool = new ConnectionPool(maxIdleConnections, keepAliveDurationValue, keepAliveDurationUnit);
                }
                this.client = new OkHttpClient().newBuilder().connectTimeout(this.connectTimeoutValue, this.connectTimeoutUnit).readTimeout(this.readTimeoutValue, this.readTimeoutUnit).writeTimeout(this.writeTimeoutValue, this.writeTimeoutUnit).connectionPool(this.connectionPool).proxy(this.proxy).build();
            }
            return this.client;
        }

        protected HttpUrl getHttpUrl() {
            if (this.httpUrl == null) {
                this.httpUrl = HttpUrl.parse((String)this.url);
            }
            return this.httpUrl;
        }

        public Instance reset() {
            this.pathSegments.clear();
            this.queryParameters.clear();
            this.requestBody = null;
            this.useMultipart = false;
            this.formData = null;
            return this;
        }

        public Instance path(String segment) {
            if (segment.indexOf(47) < 0) {
                this.pathSegments.add(segment);
            } else {
                for (String s : segment.split("/")) {
                    if (s == null || s.length() <= 0) continue;
                    this.pathSegments.add(s);
                }
            }
            return this;
        }

        public Instance path(String ... segments) {
            for (String segment : segments) {
                this.pathSegments.add(segment);
            }
            return this;
        }

        public Instance param(String name, Object value) {
            if (value == null) {
                this.queryParameters.put(name, "null");
            } else {
                this.queryParameters.put(name, Server.toJSON(value));
            }
            return this;
        }

        public Instance body(Object body) throws JsonProcessingException {
            String json = mapper.writeValueAsString(body);
            RequestBody requestBody = RequestBody.create((MediaType)APPLICATION_JSON, (String)json);
            this.body(requestBody);
            return this;
        }

        public Instance body(RequestBody body) {
            this.formData = null;
            this.requestBody = body;
            return this;
        }

        public Instance multipart() {
            this.useMultipart = true;
            return this;
        }

        public Instance form(String name, Object value) throws JsonProcessingException {
            this.requestBody = null;
            if (this.formData == null) {
                this.formData = new LinkedHashMap<String, Object>();
            }
            String json = mapper.writeValueAsString(value);
            this.formData.put(name, json);
            return this;
        }

        protected Request createRequest() throws JsonProcessingException {
            return this.createRequest(null);
        }

        protected Request createRequest(Map<String, String> headers) throws JsonProcessingException {
            HttpUrl.Builder urlBuilder = this.getHttpUrl().newBuilder();
            for (String string : this.pathSegments) {
                urlBuilder.addPathSegment(string);
            }
            for (Map.Entry entry : this.queryParameters.entrySet()) {
                urlBuilder.addQueryParameter((String)entry.getKey(), (String)entry.getValue());
            }
            HttpUrl url = urlBuilder.build();
            Request.Builder builder = new Request.Builder().url(url);
            if (this.username != null || this.password != null) {
                if (this.authorization == null) {
                    this.authorization = Credentials.basic((String)this.username, (String)this.password);
                }
                builder.header("Authorization", this.authorization);
            }
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    builder.addHeader(header.getKey(), header.getValue());
                }
            }
            if (this.formData != null) {
                if (this.useMultipart) {
                    MultipartBody.Builder builder2 = new MultipartBody.Builder().setType(MultipartBody.FORM);
                    for (Map.Entry<String, Object> e : this.formData.entrySet()) {
                        String name = e.getKey();
                        String json = mapper.writeValueAsString(e.getValue());
                        builder2.addFormDataPart(name, json);
                    }
                    this.requestBody = builder2.build();
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, Object> e : this.formData.entrySet()) {
                        try {
                            String name = URLEncoder.encode(e.getKey(), "UTF-8");
                            String json = mapper.writeValueAsString(e.getValue());
                            String value = URLEncoder.encode(json, "UTF-8");
                            sb.append("&");
                            sb.append(name);
                            sb.append("=");
                            sb.append(value);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    }
                    if (sb.length() > 0) {
                        sb.deleteCharAt(0);
                    }
                    this.requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (String)sb.toString());
                }
            }
            if (this.requestBody != null) {
                return builder.post(this.requestBody).build();
            }
            return builder.get().build();
        }

        public String get() throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                String value;
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                String string = value = response.body().string();
                return string;
            }
        }

        public String getString() throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                String string = Server.getString(response);
                return string;
            }
        }

        public String getString(String defaultValue) throws IOException, HttpException {
            String value = this.getString();
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        public Boolean getBoolean() throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                Boolean bl = Server.getBoolean(response);
                return bl;
            }
        }

        public boolean getBoolean(boolean defaultValue) throws IOException, HttpException {
            Boolean value = this.getBoolean();
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        public Integer getInt() throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                Integer n = Server.getInteger(response);
                return n;
            }
        }

        public int getInt(int defaultValue) throws IOException, HttpException {
            Integer value = this.getInt();
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        public Long getLong() throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                Long l = Server.getLong(response);
                return l;
            }
        }

        public long getLong(long defaultValue) throws IOException, HttpException {
            Long value = this.getLong();
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        public Float getFloat() throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                Float f = Server.getFloat(response);
                return f;
            }
        }

        public float getFloat(float defaultValue) throws IOException, HttpException {
            Float value = this.getFloat();
            if (value == null) {
                return defaultValue;
            }
            return value.floatValue();
        }

        public Double getDouble() throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                Double d = Server.getDouble(response);
                return d;
            }
        }

        public double getDouble(double defaultValue) throws IOException, HttpException {
            Double value = this.getDouble();
            if (value == null) {
                return defaultValue;
            }
            return value;
        }

        public <T> T get(Class<T> returnType) throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                T value = null;
                InputStream in = response.body().byteStream();
                JsonParser parser = factory.createParser(in);
                JsonObjectIterator<T> iterator = new JsonObjectIterator<T>(returnType, mapper, parser);
                if (iterator.hasNext()) {
                    value = iterator.next();
                }
                T t = value;
                return t;
            }
        }

        public <T> List<T> getList(Class<T> returnClass) throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                InputStream in = response.body().byteStream();
                JsonParser parser = factory.createParser(in);
                JsonObjectIterator<T> iterator = new JsonObjectIterator<T>(returnClass, mapper, parser);
                ArrayList<T> list = new ArrayList<T>();
                while (iterator.hasNext()) {
                    T item = iterator.next();
                    list.add(item);
                }
                ArrayList<T> arrayList = list;
                return arrayList;
            }
        }

        public <T> JsonObjectIterable<T> getIterable(Class<T> returnClass) throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                JsonObjectIterable<T> iterable;
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                InputStream in = response.body().byteStream();
                JsonParser parser = factory.createParser(in);
                JsonObjectIterator<T> iterator = new JsonObjectIterator<T>(returnClass, mapper, parser, Server.getRowCount(response));
                JsonObjectIterable<T> jsonObjectIterable = iterable = new JsonObjectIterable<T>(iterator);
                return jsonObjectIterable;
            }
        }

        public <T> JsonObjectIterator<T> getIterator(Class<T> returnClass) throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                JsonObjectIterator<T> iterator;
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                InputStream in = response.body().byteStream();
                JsonParser parser = factory.createParser(in);
                JsonObjectIterator<T> jsonObjectIterator = iterator = new JsonObjectIterator<T>(returnClass, mapper, parser, Server.getRowCount(response));
                return jsonObjectIterator;
            }
        }

        public Map<String, String> getMap() throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                Map value = null;
                InputStream in = response.body().byteStream();
                JsonParser parser = factory.createParser(in);
                JsonObjectIterator<LinkedHashMap> iterator = new JsonObjectIterator<LinkedHashMap>(LinkedHashMap.class, mapper, parser);
                if (iterator.hasNext()) {
                    value = iterator.next();
                }
                Map map = value;
                return map;
            }
        }

        public List<Map<String, String>> getMapList() throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                InputStream in = response.body().byteStream();
                JsonParser parser = factory.createParser(in);
                JsonObjectIterator<LinkedHashMap> iterator = new JsonObjectIterator<LinkedHashMap>(LinkedHashMap.class, mapper, parser);
                ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
                while (iterator.hasNext()) {
                    Map item = iterator.next();
                    list.add(item);
                }
                ArrayList<Map<String, String>> arrayList = list;
                return arrayList;
            }
        }

        public JsonObjectIterable<Map<String, String>> getMapIterable() throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                JsonObjectIterable<Map<String, String>> iterable;
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                InputStream in = response.body().byteStream();
                JsonParser parser = factory.createParser(in);
                JsonObjectIterator<LinkedHashMap> iterator = new JsonObjectIterator<LinkedHashMap>(LinkedHashMap.class, mapper, parser, Server.getRowCount(response));
                JsonObjectIterable<Map<String, String>> jsonObjectIterable = iterable = new JsonObjectIterable<Map<String, String>>(iterator);
                return jsonObjectIterable;
            }
        }

        public JsonObjectIterator<Map<String, String>> getMapIterator() throws IOException, HttpException {
            Request request = this.createRequest();
            try (Response response = this.getClient().newCall(request).execute();){
                JsonObjectIterator<Map<String, String>> iterator;
                if (!response.isSuccessful()) {
                    throw HttpException.byStatus(response.code(), response.message(), response.body().string());
                }
                InputStream in = response.body().byteStream();
                JsonParser parser = factory.createParser(in);
                JsonObjectIterator<Map<String, String>> jsonObjectIterator = iterator = new JsonObjectIterator<Map<String, String>>(LinkedHashMap.class, mapper, parser, Server.getRowCount(response));
                return jsonObjectIterator;
            }
        }
    }
}

