package net.osdn.util.rest.client;

public class HttpException extends Exception {
	private static final long serialVersionUID = 1L;
	
	private int statusCode;
	private String message;
	private String body;
	
	public HttpException(int statusCode, String message, String body) {
		this.statusCode = statusCode;
		this.message = message;
	}
	
	public int getStatusCode() {
		return this.statusCode;
	}
	
	@Override
	public String getMessage() {
		return this.message;
	}
	
	public String getBody() {
		return this.body;
	}
	
	public static HttpException byStatus(int code, String message, String body) {
		switch(code) {
		case 300: return new _300_MULTIPLE_CHOICES(message, body);
		case 301: return new _301_MOVED_PERMANENTLY(message, body);
		case 302: return new _302_MOVED_TEMPORARILY(message, body);
		case 303: return new _303_SEE_OTHER(message, body);
		case 304: return new _304_NOT_MODIFIED(message, body);
		case 305: return new _305_USE_PROXY(message, body);
		case 400: return new _400_BAD_REQUEST(message, body);
		case 401: return new _401_UNAUTHORIZED(message, body);
		case 402: return new _402_PAYMENT_REQUIRED(message, body);
		case 403: return new _403_FORBIDDEN(message, body);
		case 404: return new _404_NOT_FOUND(message, body);
		case 405: return new _405_METHOD_NOT_ALLOWED(message, body);
		case 406: return new _406_NOT_ACCEPTABLE(message, body);
		case 407: return new _407_PROXY_AUTHENTICATION_REQUIRED(message, body);
		case 408: return new _408_REQUEST_TIMEOUT(message, body);
		case 409: return new _409_CONFLICT(message, body);
		case 410: return new _410_GONE(message, body);
		case 411: return new _411_LENGTH_REQUIRED(message, body);
		case 412: return new _412_PRECONDITION_FAILED(message, body);
		case 413: return new _413_REQUEST_ENTITY_TOO_LARGE(message, body);
		case 414: return new _414_REQUEST_URI_TOO_LONG(message, body);
		case 415: return new _415_UNSUPPORTED_MEDIA_TYPE(message, body);
		case 416: return new _416_REQUEST_RANGE_NOT_SATISFIABLE(message, body);
		case 417: return new _417_EXPECTATION_FAILED(message, body);
		case 500: return new _500_INTERNAL_SERVER_ERROR(message, body);
		case 501: return new _501_NOT_IMPLEMENTED(message, body);
		case 502: return new _502_BAD_GATEWAY(message, body);
		case 503: return new _503_SERVICE_UNAVAILABLE(message, body);
		case 504: return new _504_GATEWAY_TIMEOUT(message, body);
		case 505: return new _505_HTTP_VERSION_NOT_SUPPORTED(message, body);
		default: return new HttpException(code, message, body);
		}
	}
	
	public static class _300_MULTIPLE_CHOICES extends HttpException {
		private static final long serialVersionUID = 1L;
		public _300_MULTIPLE_CHOICES(String message, String body) {
			super(300, message, body);
		}
	}
	
	public static class _301_MOVED_PERMANENTLY extends HttpException {
		private static final long serialVersionUID = 1L;
		public _301_MOVED_PERMANENTLY(String message, String body) {
			super(301, message, body);
		}
	}
	
	public static class _302_MOVED_TEMPORARILY extends HttpException {
		private static final long serialVersionUID = 1L;
		public _302_MOVED_TEMPORARILY(String message, String body) {
			super(302, message, body);
		}
	}
	
	public static class _303_SEE_OTHER extends HttpException {
		private static final long serialVersionUID = 1L;
		public _303_SEE_OTHER(String message, String body) {
			super(303, message, body);
		}
	}
	
	public static class _304_NOT_MODIFIED extends HttpException {
		private static final long serialVersionUID = 1L;
		public _304_NOT_MODIFIED(String message, String body) {
			super(304, message, body);
		}
	}
	
	public static class _305_USE_PROXY extends HttpException {
		private static final long serialVersionUID = 1L;
		public _305_USE_PROXY(String message, String body) {
			super(305, message, body);
		}
	}
	
	public static class _400_BAD_REQUEST extends HttpException {
		private static final long serialVersionUID = 1L;
		public _400_BAD_REQUEST(String message, String body) {
			super(400, message, body);
		}
	}

	public static class _401_UNAUTHORIZED extends HttpException {
		private static final long serialVersionUID = 1L;
		public _401_UNAUTHORIZED(String message, String body) {
			super(401, message, body);
		}
	}
	
	public static class _402_PAYMENT_REQUIRED extends HttpException {
		private static final long serialVersionUID = 1L;
		public _402_PAYMENT_REQUIRED(String message, String body) {
			super(402, message, body);
		}
	}
	
	public static class _403_FORBIDDEN extends HttpException {
		private static final long serialVersionUID = 1L;
		public _403_FORBIDDEN(String message, String body) {
			super(403, message, body);
		}
	}
	
	public static class _404_NOT_FOUND extends HttpException {
		private static final long serialVersionUID = 1L;
		public _404_NOT_FOUND(String message, String body) {
			super(404, message, body);
		}
	}

	public static class _405_METHOD_NOT_ALLOWED extends HttpException {
		private static final long serialVersionUID = 1L;
		public _405_METHOD_NOT_ALLOWED(String message, String body) {
			super(405, message, body);
		}
	}
	
	public static class _406_NOT_ACCEPTABLE extends HttpException {
		private static final long serialVersionUID = 1L;
		public _406_NOT_ACCEPTABLE(String message, String body) {
			super(406, message, body);
		}
	}
	
	public static class _407_PROXY_AUTHENTICATION_REQUIRED extends HttpException {
		private static final long serialVersionUID = 1L;
		public _407_PROXY_AUTHENTICATION_REQUIRED(String message, String body) {
			super(404, message, body);
		}
	}

	public static class _408_REQUEST_TIMEOUT extends HttpException {
		private static final long serialVersionUID = 1L;
		public _408_REQUEST_TIMEOUT(String message, String body) {
			super(408, message, body);
		}
	}

	public static class _409_CONFLICT extends HttpException {
		private static final long serialVersionUID = 1L;
		public _409_CONFLICT(String message, String body) {
			super(409, message, body);
		}
	}
	
	public static class _410_GONE extends HttpException {
		private static final long serialVersionUID = 1L;
		public _410_GONE(String message, String body) {
			super(410, message, body);
		}
	}
	
	public static class _411_LENGTH_REQUIRED extends HttpException {
		private static final long serialVersionUID = 1L;
		public _411_LENGTH_REQUIRED(String message, String body) {
			super(411, message, body);
		}
	}

	public static class _412_PRECONDITION_FAILED extends HttpException {
		private static final long serialVersionUID = 1L;
		public _412_PRECONDITION_FAILED(String message, String body) {
			super(412, message, body);
		}
	}

	public static class _413_REQUEST_ENTITY_TOO_LARGE extends HttpException {
		private static final long serialVersionUID = 1L;
		public _413_REQUEST_ENTITY_TOO_LARGE(String message, String body) {
			super(413, message, body);
		}
	}

	public static class _414_REQUEST_URI_TOO_LONG extends HttpException {
		private static final long serialVersionUID = 1L;
		public _414_REQUEST_URI_TOO_LONG(String message, String body) {
			super(414, message, body);
		}
	}

	public static class _415_UNSUPPORTED_MEDIA_TYPE extends HttpException {
		private static final long serialVersionUID = 1L;
		public _415_UNSUPPORTED_MEDIA_TYPE(String message, String body) {
			super(415, message, body);
		}
	}
	
	public static class _416_REQUEST_RANGE_NOT_SATISFIABLE extends HttpException {
		private static final long serialVersionUID = 1L;
		public _416_REQUEST_RANGE_NOT_SATISFIABLE(String message, String body) {
			super(416, message, body);
		}
	}
	
	public static class _417_EXPECTATION_FAILED extends HttpException {
		private static final long serialVersionUID = 1L;
		public _417_EXPECTATION_FAILED(String message, String body) {
			super(417, message, body);
		}
	}
	
	public static class _500_INTERNAL_SERVER_ERROR extends HttpException {
		private static final long serialVersionUID = 1L;
		public _500_INTERNAL_SERVER_ERROR(String message, String body) {
			super(500, message, body);
		}
	}
	
	public static class _501_NOT_IMPLEMENTED extends HttpException {
		private static final long serialVersionUID = 1L;
		public _501_NOT_IMPLEMENTED(String message, String body) {
			super(501, message, body);
		}
	}
	
	public static class _502_BAD_GATEWAY extends HttpException {
		private static final long serialVersionUID = 1L;
		public _502_BAD_GATEWAY(String message, String body) {
			super(502, message, body);
		}
	}
	
	public static class _503_SERVICE_UNAVAILABLE extends HttpException {
		private static final long serialVersionUID = 1L;
		public _503_SERVICE_UNAVAILABLE(String message, String body) {
			super(503, message, body);
		}
	}
	
	public static class _504_GATEWAY_TIMEOUT extends HttpException {
		private static final long serialVersionUID = 1L;
		public _504_GATEWAY_TIMEOUT(String message, String body) {
			super(504, message, body);
		}
	}

	public static class _505_HTTP_VERSION_NOT_SUPPORTED extends HttpException {
		private static final long serialVersionUID = 1L;
		public _505_HTTP_VERSION_NOT_SUPPORTED(String message, String body) {
			super(505, message, body);
		}
	}
}
