package net.osdn.util.jersey;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

@Provider
public class ApplicationProblemExceptionMapper implements ExceptionMapper<ApplicationProblem> {

	private ObjectMapper mapper = new JacksonConfig().getContext(null);
	
	@Override
	public Response toResponse(ApplicationProblem problem) {
		String entity;
		try {
			entity = mapper.writeValueAsString(problem);
		} catch (JsonProcessingException e) {
			entity = "{\r\n"
			       + "  \"type\" : \"" + problem.getType() + "\",\r\n"
			       + "  \"title\" : \"" + problem.getTitle() + "\",\r\n"
			       + "  \"status\" : " + problem.getStatus() + ",\r\n"
			       + "  \"detail\" : \"" + problem.getDetail() + "\",\r\n"
			       + "  \"instance\" : \"" + problem.getInstance() + "\"\r\n"
			       + "}";
		}
		
		return Response
				.status(problem.getStatus())
				.header("Content-Type", "application/problem+json;charset=UTF-8")
				.entity(entity)
				.build();
	}
}
