/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.sql.h2;

import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.osdn.util.sql.NamedParameterStatement;
import net.osdn.util.sql.StatementBuilder;

public class H2StatementBuilder
extends StatementBuilder {
    @Override
    public boolean isAcceptable(DatabaseMetaData md) throws SQLException {
        String productName = md.getDatabaseProductName();
        return productName != null && productName.contains("H2");
    }

    @Override
    public NamedParameterStatement createMergeStatement(DatabaseMetaData md, Class<?> cls, String tableName) throws SQLException {
        StatementBuilder.Column column;
        int i;
        if (tableName == null) {
            tableName = this.getTableName(md, cls);
        }
        if (tableName == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> fieldNames = new HashSet<String>();
        Field[] fields = this.getFields(cls);
        for (int i2 = 0; i2 < fields.length; ++i2) {
            fieldNames.add(fields[i2].getName().toLowerCase());
        }
        List<StatementBuilder.Column> columns = this.getColumns(md, tableName, fieldNames);
        if (columns.size() == 0) {
            throw new IllegalStateException();
        }
        ArrayList<StatementBuilder.Column> whereClauseColumns = new ArrayList<StatementBuilder.Column>();
        ArrayList<StatementBuilder.Column> valuesClauseColumns = new ArrayList<StatementBuilder.Column>();
        for (StatementBuilder.Column column2 : columns) {
            if (column2.isRowIdentifier) {
                whereClauseColumns.add(column2);
            }
            if (column2.isAutoincrement) continue;
            valuesClauseColumns.add(column2);
        }
        if (whereClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (valuesClauseColumns.size() == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("MERGE INTO \"");
        sb.append(tableName);
        sb.append("\" (");
        for (i = 0; i < valuesClauseColumns.size(); ++i) {
            column = (StatementBuilder.Column)valuesClauseColumns.get(i);
            sb.append('\"');
            sb.append(column.name);
            sb.append('\"');
            if (i + 1 >= valuesClauseColumns.size()) continue;
            sb.append(", ");
        }
        sb.append(") KEY (");
        for (i = 0; i < whereClauseColumns.size(); ++i) {
            column = (StatementBuilder.Column)whereClauseColumns.get(i);
            sb.append('\"');
            sb.append(column.name);
            sb.append('\"');
            if (i + 1 >= whereClauseColumns.size()) continue;
            sb.append(", ");
        }
        sb.append(") VALUES (");
        for (i = 0; i < valuesClauseColumns.size(); ++i) {
            column = (StatementBuilder.Column)valuesClauseColumns.get(i);
            sb.append(':');
            sb.append(column.name);
            if (i + 1 >= valuesClauseColumns.size()) continue;
            sb.append(", ");
        }
        sb.append(')');
        return new NamedParameterStatement(sb.toString());
    }
}

