/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.osdn.util.sql.NamedParameter;
import net.osdn.util.sql.Sql;

public class NamedParameterStatement {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("'(?:''|[^'])*'|--.*?$|\\/\\*.*?\\*\\/|:(.+?)\\b|(\\?)", 40);
    private String original;
    private String sql;
    private Set<String> parameterNames = new LinkedHashSet<String>();
    private Map<String, int[]> indexesMap = new LinkedHashMap<String, int[]>();
    private Map<Integer, NamedParameter> parameters = new TreeMap<Integer, NamedParameter>();
    boolean hasRowVersionColumn;

    public NamedParameterStatement(String sql) {
        this.original = sql;
        ArrayList<String> names = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        Matcher m = PARAMETER_PATTERN.matcher(sql);
        while (m.find()) {
            if (m.group(1) != null) {
                names.add(m.group(1));
                m.appendReplacement(sb, "?");
                continue;
            }
            if (m.group(2) == null) continue;
            names.add(m.group(2));
            m.appendReplacement(sb, "?");
        }
        m.appendTail(sb);
        this.sql = sb.toString();
        HashMap<String, ArrayList<Integer>> map = new HashMap<String, ArrayList<Integer>>();
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            ArrayList<Integer> indexes = (ArrayList<Integer>)map.get(name.toLowerCase());
            if (indexes == null) {
                indexes = new ArrayList<Integer>();
                map.put(name.toLowerCase(), indexes);
            }
            indexes.add(i + 1);
            if (this.parameterNames.contains(name.toLowerCase())) continue;
            this.parameterNames.add(name);
        }
        for (String name : this.parameterNames) {
            List list = (List)map.get(name.toLowerCase());
            int[] indexes = new int[list.size()];
            for (int j = 0; j < indexes.length; ++j) {
                indexes[j] = (Integer)list.get(j);
            }
            this.indexesMap.put(name.toLowerCase(), indexes);
        }
    }

    public String getOriginalSql() {
        return this.original;
    }

    public String getSql() {
        return this.sql;
    }

    public Set<String> getParameterNames() {
        return this.parameterNames;
    }

    public int[] getIndexesBy(String parameterName) {
        int[] indexes = this.indexesMap.get(parameterName.toLowerCase());
        if (indexes == null) {
            throw new IllegalArgumentException();
        }
        return indexes;
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public NamedParameter[] getParameters() {
        return this.parameters.values().toArray(new NamedParameter[0]);
    }

    public void setArray(String parameterName, Array x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_ARRAY, index, parameterName, x));
        }
    }

    public void setAsciiStream(String parameterName, InputStream x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_ASCII_STREAM, index, parameterName, x));
        }
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_ASCII_STREAM, index, parameterName, x);
            param.setLength(length);
            this.parameters.put(index, param);
        }
    }

    public void setAsciiStream(String parameterName, InputStream x, long length) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_ASCII_STREAM, index, parameterName, x);
            param.setLength(length);
            this.parameters.put(index, param);
        }
    }

    public void setBigDecimal(String parameterName, BigDecimal x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_BIG_DECIMAL, index, parameterName, x));
        }
    }

    public void setBinaryStream(String parameterName, InputStream x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_BINARY_STREAM, index, parameterName, x));
        }
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_BINARY_STREAM, index, parameterName, x);
            param.setLength(length);
            this.parameters.put(index, param);
        }
    }

    public void setBinaryStream(String parameterName, InputStream x, long length) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_BINARY_STREAM, index, parameterName, x);
            param.setLength(length);
            this.parameters.put(index, param);
        }
    }

    public void setBlob(String parameterName, Blob x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_BLOB, index, parameterName, x));
        }
    }

    public void setBlob(String parameterName, InputStream x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_BLOB, index, parameterName, x));
        }
    }

    public void setBlob(String parameterName, InputStream x, long length) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_BLOB, index, parameterName, x);
            param.setLength(length);
            this.parameters.put(index, param);
        }
    }

    public void setBoolean(String parameterName, boolean x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_BOOLEAN, index, parameterName, x));
        }
    }

    public void setByte(String parameterName, byte x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_BYTE, index, parameterName, x));
        }
    }

    public void setBytes(String parameterName, byte[] x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_BYTES, index, parameterName, x));
        }
    }

    public void setCharacterStream(String parameterName, Reader x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_CHARACTER_STREAM, index, parameterName, x));
        }
    }

    public void setCharacterStream(String parameterName, Reader x, int length) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_CHARACTER_STREAM, index, parameterName, x);
            param.setLength(length);
            this.parameters.put(index, param);
        }
    }

    public void setCharacterStream(String parameterName, Reader x, long length) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_CHARACTER_STREAM, index, parameterName, x);
            param.setLength(length);
            this.parameters.put(index, param);
        }
    }

    public void setClob(String parameterName, Clob x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_CLOB, index, parameterName, x));
        }
    }

    public void setClob(String parameterName, Reader x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_CLOB, index, parameterName, x));
        }
    }

    public void setClob(String parameterName, Reader x, long length) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_CLOB, index, parameterName, x);
            param.setLength(length);
            this.parameters.put(index, param);
        }
    }

    public void setDate(String parameterName, Date x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_DATE, index, parameterName, x));
        }
    }

    public void setDate(String parameterName, Date x, Calendar calendar) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_DATE, index, parameterName, x);
            param.setCalendar(calendar);
            this.parameters.put(index, param);
        }
    }

    public void setDouble(String parameterName, double x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_DOUBLE, index, parameterName, x));
        }
    }

    public void setFloat(String parameterName, float x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_FLOAT, index, parameterName, Float.valueOf(x)));
        }
    }

    public void setInt(String parameterName, int x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_INT, index, parameterName, x));
        }
    }

    public void setLong(String parameterName, long x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_LONG, index, parameterName, x));
        }
    }

    public void setNCharacterStream(String parameterName, Reader x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_NCHARACTER_STREAM, index, parameterName, x));
        }
    }

    public void setNCharacterStream(String parameterName, Reader x, long length) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_NCHARACTER_STREAM, index, parameterName, x);
            param.setLength(length);
            this.parameters.put(index, param);
        }
    }

    public void setNClob(String parameterName, NClob x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_NCLOB, index, parameterName, x));
        }
    }

    public void setNClob(String parameterName, Reader x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_NCLOB, index, parameterName, x));
        }
    }

    public void setNClob(String parameterName, Reader x, long length) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_NCLOB, index, parameterName, x);
            param.setLength(length);
            this.parameters.put(index, param);
        }
    }

    public void setNString(String parameterName, String x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_NSTRING, index, parameterName, x));
        }
    }

    public void setNull(String parameterName, int sqlType) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_NULL, index, parameterName, null);
            param.setType(sqlType);
            this.parameters.put(index, param);
        }
    }

    public void setNull(String parameterName, int sqlType, String typeName) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_NULL, index, parameterName, null);
            param.setType(sqlType);
            param.setTypeName(typeName);
            this.parameters.put(index, param);
        }
    }

    public void setObject(String parameterName, Object x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_OBJECT, index, parameterName, x));
        }
    }

    public void setObject(String parameterName, Object x, int targetSqlType) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_OBJECT, index, parameterName, x);
            param.setType(targetSqlType);
            this.parameters.put(index, param);
        }
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scaleOrLength) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_OBJECT, index, parameterName, x);
            param.setType(targetSqlType);
            param.setLength(scaleOrLength);
            this.parameters.put(index, param);
        }
    }

    public void setRef(String parameterName, Ref x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_REF, index, parameterName, x));
        }
    }

    public void setRowId(String parameterName, RowId x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_ROWID, index, parameterName, x));
        }
    }

    public void setShort(String parameterName, short x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_SHORT, index, parameterName, x));
        }
    }

    public void setSQLXML(String parameterName, SQLXML x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_SQLXML, index, parameterName, x));
        }
    }

    public void setString(String parameterName, String x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_STRING, index, parameterName, x));
        }
    }

    public void setTime(String parameterName, Time x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_TIME, index, parameterName, x));
        }
    }

    public void setTime(String parameterName, Time x, Calendar calendar) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_TIME, index, parameterName, x);
            param.setCalendar(calendar);
            this.parameters.put(index, param);
        }
    }

    public void setTimestamp(String parameterName, Timestamp x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_TIMESTAMP, index, parameterName, x));
        }
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar calendar) {
        for (int index : this.getIndexesBy(parameterName)) {
            NamedParameter param = new NamedParameter(NamedParameter.Method.SET_TIMESTAMP, index, parameterName, x);
            param.setCalendar(calendar);
            this.parameters.put(index, param);
        }
    }

    public void setURL(String parameterName, URL x) {
        for (int index : this.getIndexesBy(parameterName)) {
            this.parameters.put(index, new NamedParameter(NamedParameter.Method.SET_URL, index, parameterName, x));
        }
    }

    public String toString() {
        return new Sql(this).dump();
    }
}

