/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.sql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.RowSet;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetFactory;
import javax.sql.rowset.RowSetProvider;
import net.osdn.util.concurrent.Monitor;
import net.osdn.util.sql.ConnectionPool;
import net.osdn.util.sql.IsolationLevel;
import net.osdn.util.sql.NamedParameterStatement;
import net.osdn.util.sql.OptimisticConcurrencyException;
import net.osdn.util.sql.SqlExecutionHandler;
import net.osdn.util.sql.Transaction;

public class DataSource {
    public static final int OPTION_MSSQL_SET_NOCOUNT_ON = 1;
    private static Pattern TABLE_NAME = Pattern.compile("(?:FROM|INTO|UPDATE)\\s+(.+?)(?:$|\\s)", 2);
    private static final Monitor monitor = new Monitor();
    private static Instance defaultInstance;

    public static synchronized void initialize() throws NamingException, SQLException {
        DataSource.initialize("jdbc/datasource");
    }

    public static void initialize(String jndiNameOrJdbcUrl) throws NamingException, SQLException {
        DataSource.initialize(jndiNameOrJdbcUrl, null, null);
    }

    public static void initialize(String jndiNameOrJdbcUrl, String username, String password) throws NamingException, SQLException {
        if (defaultInstance != null) {
            defaultInstance.close();
        }
        defaultInstance = new Instance(jndiNameOrJdbcUrl, username, password);
    }

    public static void initialize(String jdbcUrl, Properties info) throws SQLException {
        if (defaultInstance != null) {
            defaultInstance.close();
        }
        defaultInstance = new Instance(jdbcUrl, info);
    }

    public static void initialize(javax.sql.DataSource datasource) throws SQLException {
        DataSource.initialize(datasource, null, null);
    }

    public static void initialize(javax.sql.DataSource datasource, String username, String password) throws SQLException {
        if (defaultInstance != null) {
            defaultInstance.close();
        }
        defaultInstance = new Instance(datasource, username, password);
    }

    public static void initialize(ConnectionPoolDataSource datasource) throws SQLException {
        DataSource.initialize(datasource, null, null);
    }

    public static void initialize(ConnectionPoolDataSource datasource, String username, String password) throws SQLException {
        if (defaultInstance != null) {
            defaultInstance.close();
        }
        defaultInstance = new Instance(datasource, username, password);
    }

    static Monitor getMonitor() {
        return monitor;
    }

    public static void setSqlExecutionHandler(SqlExecutionHandler sqlExecutionHandler) {
        defaultInstance.setSqlExecutionHandler(sqlExecutionHandler);
    }

    public static SqlExecutionHandler getSqlExecutionHandler() {
        return defaultInstance.getSqlExecutionHandler();
    }

    public static Transaction beginTransaction() throws SQLException {
        return defaultInstance.beginTransaction();
    }

    public static Transaction beginTransaction(IsolationLevel level) throws SQLException {
        return defaultInstance.beginTransaction(level);
    }

    public static Connection getConnection() throws SQLException {
        return defaultInstance.getConnection(0);
    }

    public static Connection getConnection(int options) throws SQLException {
        return defaultInstance.getConnection(options);
    }

    public static CachedRowSet populate(ResultSet rs) throws SQLException {
        return defaultInstance.populate(rs);
    }

    public static ResultSet executeQuery(String sql) throws SQLException, IOException {
        return defaultInstance.executeQuery(sql);
    }

    public static ResultSet executeQuery(String sql, Object ... parameters) throws SQLException, IOException {
        return defaultInstance.executeQuery(sql, parameters);
    }

    public static ResultSet executeQuery(String sql, Collection<?> parameters) throws SQLException, IOException {
        return defaultInstance.executeQuery(sql, parameters);
    }

    public static ResultSet executeQuery(NamedParameterStatement statement) throws SQLException, IOException {
        return defaultInstance.executeQuery(statement);
    }

    public static int executeUpdate(String sql) throws SQLException, IOException {
        return defaultInstance.executeUpdate(sql);
    }

    public static int executeUpdate(String sql, Object ... parameters) throws SQLException, IOException {
        return defaultInstance.executeUpdate(sql, parameters);
    }

    public static int executeUpdate(String sql, Collection<?> parameters) throws SQLException, IOException {
        return defaultInstance.executeUpdate(sql, parameters);
    }

    public static int executeUpdate(NamedParameterStatement statement) throws SQLException, IOException {
        return defaultInstance.executeUpdate(statement);
    }

    public static int executeUpdate(Object notifier, String sql, Object ... parameters) throws SQLException, IOException {
        return defaultInstance.executeUpdate(notifier, sql, parameters);
    }

    public static int executeUpdate(Object notifier, String sql, Collection<?> parameters) throws SQLException, IOException {
        return defaultInstance.executeUpdate(notifier, sql, parameters);
    }

    public static int executeUpdate(Object notifier, NamedParameterStatement statement) throws SQLException, IOException {
        return defaultInstance.executeUpdate(notifier, statement);
    }

    public static ResultSet executeQueryWaitForRows(long timeout, String sql, Object ... parameters) throws SQLException, TimeoutException, InterruptedException, IOException {
        return defaultInstance.executeQueryWaitForRows(timeout, sql, parameters);
    }

    public static ResultSet executeQueryWaitForRows(long timeout, String sql, Collection<?> parameters) throws SQLException, TimeoutException, InterruptedException, IOException {
        return defaultInstance.executeQueryWaitForRows(timeout, sql, parameters);
    }

    public static ResultSet executeQueryWaitForRows(long timeout, NamedParameterStatement statement) throws SQLException, TimeoutException, InterruptedException, IOException {
        return defaultInstance.executeQueryWaitForRows(timeout, statement);
    }

    public static ResultSet executeQueryWaitForRows(Monitor.MultipleObjects waiters, String sql, Object ... parameters) throws SQLException, TimeoutException, InterruptedException, IOException {
        return defaultInstance.executeQueryWaitForRows(waiters, sql, parameters);
    }

    public static ResultSet executeQueryWaitForRows(Monitor.MultipleObjects waiters, String sql, Collection<?> parameters) throws SQLException, TimeoutException, InterruptedException, IOException {
        return defaultInstance.executeQueryWaitForRows(waiters, sql, parameters);
    }

    public static ResultSet executeQueryWaitForRows(Monitor.MultipleObjects waiters, NamedParameterStatement statement) throws SQLException, TimeoutException, InterruptedException, IOException {
        return defaultInstance.executeQueryWaitForRows(waiters, statement);
    }

    public static <T> T executeScalar(String sql) throws SQLException, IOException {
        return defaultInstance.executeScalar(sql);
    }

    public static <T> T executeScalar(String sql, Object ... parameters) throws SQLException, IOException {
        return defaultInstance.executeScalar(sql, parameters);
    }

    public static <T> T executeScalar(String sql, Collection<?> parameters) throws SQLException, IOException {
        return defaultInstance.executeScalar(sql, parameters);
    }

    public static <T> T executeScalar(NamedParameterStatement statement) throws SQLException, IOException {
        return defaultInstance.executeScalar(statement);
    }

    public static void close(ResultSet rs) throws SQLException {
        if (rs instanceof CachedRowSet) {
            return;
        }
        Statement st = null;
        if (rs != null) {
            st = rs.getStatement();
        }
        Connection cn = null;
        if (st != null) {
            cn = st.getConnection();
        }
        if (rs != null && !rs.isClosed()) {
            rs.close();
        }
        if (st != null && !st.isClosed()) {
            st.close();
        }
        if (cn != null && !cn.isClosed()) {
            cn.close();
        }
    }

    public static <T> T select(String columnName, Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        return defaultInstance.select(columnName, obj);
    }

    public static <T> T select(Object obj) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.select(obj);
    }

    public static <T> T select(Class<T> returnClass) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.select(returnClass);
    }

    public static <T> T select(Class<T> returnClass, Object obj) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.select(returnClass, obj);
    }

    public static <T> T select(Class<T> returnClass, String sql) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.select(returnClass, sql);
    }

    public static <T> T select(Class<T> returnClass, String sql, Object ... parameters) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.select(returnClass, sql, parameters);
    }

    public static <T> T select(Class<T> returnClass, String sql, Collection<?> parameters) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.select(returnClass, sql, parameters);
    }

    public static <T> T select(Class<T> returnClass, NamedParameterStatement statement) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.select(returnClass, statement);
    }

    public static <T> List<T> selectAsList(Class<T> returnClass) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.selectAsList(returnClass);
    }

    public static <T> List<T> selectAsList(Object obj) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.selectAsList(obj);
    }

    public static <T> List<T> selectAsList(Class<T> returnClass, Object obj) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.selectAsList(returnClass, obj);
    }

    public static <T> List<T> selectAsList(Class<T> returnClass, String sql) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.selectAsList(returnClass, sql);
    }

    public static <T> List<T> selectAsList(Class<T> returnClass, String sql, Object ... parameters) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.selectAsList(returnClass, sql, parameters);
    }

    public static <T> List<T> selectAsList(Class<T> returnClass, String sql, Collection<?> parameters) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.selectAsList(returnClass, sql, parameters);
    }

    public static <T> List<T> selectAsList(Class<T> returnClass, NamedParameterStatement statement) throws SQLException, ParseException, ReflectiveOperationException {
        return defaultInstance.selectAsList(returnClass, statement);
    }

    public static int insert(Object obj) throws SQLException, IllegalAccessException {
        return defaultInstance.insert(obj);
    }

    public static int[] insert(Object ... objects) throws SQLException, IllegalAccessException {
        return defaultInstance.insert(objects);
    }

    public static int[] insert(Collection<?> objects) throws SQLException, IllegalAccessException {
        return defaultInstance.insert(objects.toArray());
    }

    public static int update(Object obj) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        return defaultInstance.update(obj);
    }

    public static int[] update(Object ... objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        return defaultInstance.update(objects);
    }

    public static int[] update(Collection<?> objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        return defaultInstance.update(objects);
    }

    public static int delete(Object obj) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        return defaultInstance.delete(obj);
    }

    public static int[] delete(Object ... objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        return defaultInstance.delete(objects);
    }

    public static int[] delete(Collection<?> objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        return defaultInstance.delete(objects);
    }

    public static int merge(Object obj) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        return defaultInstance.merge(obj);
    }

    public static int[] merge(Object ... objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        return defaultInstance.merge(objects);
    }

    public static int[] merge(Collection<?> objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        return defaultInstance.merge(objects);
    }

    public static Monitor.MultipleObjects newMultipleObjects(long timeout, Object ... objects) {
        return monitor.newMultipleObjects(timeout, objects);
    }

    public static Monitor.MultipleObjects newMultipleObjects(long timeout, Collection<?> objects) {
        return monitor.newMultipleObjects(timeout, objects);
    }

    public static void notifyAll(Object object) {
        monitor.notifyAll(object);
    }

    static String findTableName(String sql) {
        String tableName = null;
        Matcher matcher = TABLE_NAME.matcher(sql);
        if (matcher.find()) {
            tableName = matcher.group(1);
            int pos = tableName.lastIndexOf(46);
            if (0 <= pos && pos < tableName.length() - 1) {
                tableName = tableName.substring(pos + 1);
            }
            if (tableName.length() >= 2 && tableName.startsWith("\"") && tableName.endsWith("\"")) {
                tableName = tableName.substring(1, tableName.length() - 1);
            }
            if (tableName.length() >= 2 && tableName.startsWith("[") && tableName.endsWith("]")) {
                tableName = tableName.substring(1, tableName.length() - 1);
            }
            tableName = tableName.toUpperCase();
        }
        return tableName;
    }

    public static class Instance {
        private ConnectionPool pool;
        private javax.sql.DataSource datasource;
        private String username;
        private String password;
        private Driver driver;
        private String url;
        private Properties info;
        private volatile RowSetFactory rowSetFactory;
        private SqlExecutionHandler sqlExecutionHandler;

        public Instance(String jndiNameOrJdbcUrl) throws NamingException, SQLException {
            this(jndiNameOrJdbcUrl, null, null);
        }

        public Instance(String jndiNameOrJdbcUrl, String username, String password) throws NamingException, SQLException {
            if (jndiNameOrJdbcUrl == null) {
                throw new IllegalArgumentException();
            }
            if (jndiNameOrJdbcUrl.toLowerCase().startsWith("jdbc:")) {
                this.url = jndiNameOrJdbcUrl;
                this.driver = DriverManager.getDriver(this.url);
                this.info = new Properties();
                if (username != null) {
                    this.info.put("user", username);
                }
                if (password != null) {
                    this.info.put("password", password);
                }
            } else {
                InitialContext context = new InitialContext();
                String name = jndiNameOrJdbcUrl;
                Object datasource = context.lookup(name);
                if (datasource instanceof javax.sql.DataSource) {
                    if (datasource instanceof ConnectionPoolDataSource) {
                        this.pool = new ConnectionPool((ConnectionPoolDataSource)datasource, username, password);
                    } else {
                        this.datasource = (javax.sql.DataSource)datasource;
                    }
                } else if (datasource instanceof ConnectionPoolDataSource) {
                    this.pool = new ConnectionPool((ConnectionPoolDataSource)datasource);
                } else {
                    throw new IllegalStateException("JNDI Resource '" + name + "' must implement the javax.sql.DataSource interface or the javax.sql.ConnectionPoolDataSource interface.");
                }
                this.username = username;
                this.password = password;
            }
        }

        public Instance(String jdbcUrl, Properties info) throws SQLException {
            if (jdbcUrl == null) {
                throw new IllegalArgumentException();
            }
            this.url = jdbcUrl;
            this.driver = DriverManager.getDriver(this.url);
            this.info = info != null ? info : new Properties();
        }

        public Instance(javax.sql.DataSource datasource) throws SQLException {
            this(datasource, null, null);
        }

        public Instance(javax.sql.DataSource datasource, String username, String password) throws SQLException {
            if (datasource instanceof ConnectionPoolDataSource) {
                this.pool = new ConnectionPool((ConnectionPoolDataSource)((Object)datasource));
            } else {
                this.datasource = datasource;
            }
            this.username = username;
            this.password = password;
        }

        public Instance(ConnectionPoolDataSource datasource) throws SQLException {
            this(datasource, null, null);
        }

        public Instance(ConnectionPoolDataSource datasource, String username, String password) throws SQLException {
            this.pool = new ConnectionPool(datasource);
            this.username = username;
            this.password = password;
        }

        public void setSqlExecutionHandler(SqlExecutionHandler sqlExecutionHandler) {
            this.sqlExecutionHandler = sqlExecutionHandler;
        }

        public SqlExecutionHandler getSqlExecutionHandler() {
            return this.sqlExecutionHandler;
        }

        public Transaction beginTransaction() throws SQLException {
            Transaction transaction = new Transaction(this, IsolationLevel.ReadCommitted, this.sqlExecutionHandler);
            return transaction;
        }

        public Transaction beginTransaction(IsolationLevel level) throws SQLException {
            Transaction transaction = new Transaction(this, level, this.sqlExecutionHandler);
            return transaction;
        }

        public Connection getConnection() throws SQLException {
            return this.getConnection(0);
        }

        public Connection getConnection(int options) throws SQLException {
            Connection cn;
            if (this.pool != null) {
                cn = this.pool.getConnection();
            } else if (this.datasource != null) {
                cn = this.username != null || this.password != null ? this.datasource.getConnection(this.username, this.password) : this.datasource.getConnection();
            } else if (this.driver != null && this.url != null) {
                cn = this.driver.connect(this.url, this.info);
            } else {
                throw new IllegalStateException("The DataSource has not been initialized.");
            }
            if ((options & 1) != 0) {
                Statement st = cn.createStatement();
                st.execute("SET NOCOUNT ON");
                st.close();
            }
            return cn;
        }

        public void close() {
            if (this.pool != null) {
                this.pool.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CachedRowSet populate(ResultSet rs) throws SQLException {
            if (rs == null) {
                return null;
            }
            if (this.rowSetFactory == null) {
                Instance instance = this;
                synchronized (instance) {
                    if (this.rowSetFactory == null) {
                        this.rowSetFactory = RowSetProvider.newFactory();
                    }
                }
            }
            CachedRowSet rowSet = this.rowSetFactory.createCachedRowSet();
            rowSet.populate(rs);
            return rowSet;
        }

        public ResultSet executeQuery(String sql) throws SQLException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                RowSet rowSet = transaction.executeQuery(sql);
                return rowSet;
            }
        }

        public ResultSet executeQuery(String sql, Object ... parameters) throws SQLException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                RowSet rowSet = transaction.executeQuery(sql, parameters);
                return rowSet;
            }
        }

        public ResultSet executeQuery(String sql, Collection<?> parameters) throws SQLException, IOException {
            return this.executeQuery(sql, parameters.toArray());
        }

        public ResultSet executeQuery(NamedParameterStatement statement) throws SQLException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                RowSet rowSet = transaction.executeQuery(statement);
                return rowSet;
            }
        }

        public int executeUpdate(String sql) throws SQLException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                int n = transaction.executeUpdate(sql);
                return n;
            }
        }

        public int executeUpdate(String sql, Object ... parameters) throws SQLException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                int n = transaction.executeUpdate(sql, parameters);
                return n;
            }
        }

        public int executeUpdate(String sql, Collection<?> parameters) throws SQLException, IOException {
            return this.executeUpdate(sql, parameters.toArray());
        }

        public int executeUpdate(NamedParameterStatement statement) throws SQLException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                int n = transaction.executeUpdate(statement);
                return n;
            }
        }

        public int executeUpdate(Object notifier, String sql, Object ... parameters) throws SQLException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                int n = transaction.executeUpdate(notifier, sql, parameters);
                return n;
            }
        }

        public int executeUpdate(Object notifier, String sql, Collection<?> parameters) throws SQLException, IOException {
            return this.executeUpdate(notifier, sql, parameters.toArray());
        }

        public int executeUpdate(Object notifier, NamedParameterStatement statement) throws SQLException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                int n = transaction.executeUpdate(notifier, statement);
                return n;
            }
        }

        public ResultSet executeQueryWaitForRows(long timeout, String sql, Object ... parameters) throws SQLException, TimeoutException, InterruptedException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                RowSet rowSet = transaction.executeQueryWaitForRows(timeout, sql, parameters);
                return rowSet;
            }
        }

        public ResultSet executeQueryWaitForRows(long timeout, String sql, Collection<?> parameters) throws SQLException, TimeoutException, InterruptedException, IOException {
            return this.executeQueryWaitForRows(timeout, sql, parameters.toArray());
        }

        public ResultSet executeQueryWaitForRows(long timeout, NamedParameterStatement statement) throws SQLException, TimeoutException, InterruptedException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                RowSet rowSet = transaction.executeQueryWaitForRows(timeout, statement);
                return rowSet;
            }
        }

        public ResultSet executeQueryWaitForRows(Monitor.MultipleObjects waiters, String sql, Object ... parameters) throws SQLException, TimeoutException, InterruptedException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                RowSet rowSet = transaction.executeQueryWaitForRows(waiters, sql, parameters);
                return rowSet;
            }
        }

        public ResultSet executeQueryWaitForRows(Monitor.MultipleObjects waiters, String sql, Collection<?> parameters) throws SQLException, TimeoutException, InterruptedException, IOException {
            return this.executeQueryWaitForRows(waiters, sql, parameters.toArray());
        }

        public ResultSet executeQueryWaitForRows(Monitor.MultipleObjects waiters, NamedParameterStatement statement) throws SQLException, TimeoutException, InterruptedException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                RowSet rowSet = transaction.executeQueryWaitForRows(waiters, statement);
                return rowSet;
            }
        }

        public <T> T executeScalar(String sql) throws SQLException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                Object t = transaction.executeScalar(sql);
                return t;
            }
        }

        public <T> T executeScalar(String sql, Object ... parameters) throws SQLException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                Object t = transaction.executeScalar(sql, parameters);
                return t;
            }
        }

        public <T> T executeScalar(String sql, Collection<?> parameters) throws SQLException, IOException {
            return this.executeScalar(sql, parameters.toArray());
        }

        public <T> T executeScalar(NamedParameterStatement statement) throws SQLException, IOException {
            try (Transaction transaction = this.beginTransaction(null);){
                Object t = transaction.executeScalar(statement);
                return t;
            }
        }

        public <T> T select(String columnName, Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
            try (Transaction transaction = this.beginTransaction(null);){
                Object t = transaction.select(columnName, obj);
                return t;
            }
        }

        public <T> T select(Object obj) throws SQLException, ParseException, ReflectiveOperationException {
            try (Transaction transaction = this.beginTransaction(null);){
                Object t = transaction.select(obj);
                return t;
            }
        }

        public <T> T select(Class<T> returnClass) throws SQLException, ParseException, ReflectiveOperationException {
            try (Transaction transaction = this.beginTransaction(null);){
                T t = transaction.select(returnClass);
                return t;
            }
        }

        public <T> T select(Class<T> returnClass, Object obj) throws SQLException, ParseException, ReflectiveOperationException {
            try (Transaction transaction = this.beginTransaction(null);){
                T t = transaction.select(returnClass, obj);
                return t;
            }
        }

        public <T> T select(Class<T> returnClass, String sql) throws SQLException, ParseException, ReflectiveOperationException {
            try (Transaction transaction = this.beginTransaction(null);){
                T t = transaction.select(returnClass, sql);
                return t;
            }
        }

        public <T> T select(Class<T> returnClass, String sql, Object ... parameters) throws SQLException, ParseException, ReflectiveOperationException {
            try (Transaction transaction = this.beginTransaction(null);){
                T t = transaction.select(returnClass, sql, parameters);
                return t;
            }
        }

        public <T> T select(Class<T> returnClass, String sql, Collection<?> parameters) throws SQLException, ParseException, ReflectiveOperationException {
            return this.select(returnClass, sql, parameters.toArray());
        }

        public <T> T select(Class<T> returnClass, NamedParameterStatement statement) throws SQLException, ParseException, ReflectiveOperationException {
            try (Transaction transaction = this.beginTransaction(null);){
                T t = transaction.select(returnClass, statement);
                return t;
            }
        }

        public <T> List<T> selectAsList(Class<T> returnClass) throws SQLException, ParseException, ReflectiveOperationException {
            try (Transaction transaction = this.beginTransaction(null);){
                List<T> list = transaction.selectAsList(returnClass, (Object)null);
                return list;
            }
        }

        public <T> List<T> selectAsList(Object obj) throws SQLException, ParseException, ReflectiveOperationException {
            try (Transaction transaction = this.beginTransaction(null);){
                List list = transaction.selectAsList(obj);
                return list;
            }
        }

        public <T> List<T> selectAsList(Class<T> returnClass, Object obj) throws SQLException, ParseException, ReflectiveOperationException {
            try (Transaction transaction = this.beginTransaction(null);){
                List<T> list = transaction.selectAsList(returnClass, obj);
                return list;
            }
        }

        public <T> List<T> selectAsList(Class<T> returnClass, String sql) throws SQLException, ParseException, ReflectiveOperationException {
            try (Transaction transaction = this.beginTransaction(null);){
                List<T> list = transaction.selectAsList(returnClass, sql);
                return list;
            }
        }

        public <T> List<T> selectAsList(Class<T> returnClass, String sql, Object ... parameters) throws SQLException, ParseException, ReflectiveOperationException {
            try (Transaction transaction = this.beginTransaction(null);){
                List<T> list = transaction.selectAsList(returnClass, sql, parameters);
                return list;
            }
        }

        public <T> List<T> selectAsList(Class<T> returnClass, String sql, Collection<?> parameters) throws SQLException, ParseException, ReflectiveOperationException {
            return this.selectAsList(returnClass, sql, parameters.toArray());
        }

        public <T> List<T> selectAsList(Class<T> returnClass, NamedParameterStatement statement) throws SQLException, ParseException, ReflectiveOperationException {
            try (Transaction transaction = this.beginTransaction(null);){
                List<T> list = transaction.selectAsList(returnClass, statement);
                return list;
            }
        }

        public int insert(Object obj) throws SQLException, IllegalAccessException {
            int[] r = this.insert(new Object[]{obj});
            return r[0];
        }

        public int[] insert(Object ... objects) throws SQLException, IllegalAccessException {
            int[] results;
            try (Transaction transaction = this.beginTransaction(IsolationLevel.ReadUncommitted);){
                results = transaction.insert(objects);
                transaction.commit();
            }
            return results;
        }

        public int[] insert(Collection<?> objects) throws SQLException, IllegalAccessException {
            return this.insert(objects.toArray());
        }

        public int update(Object obj) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
            int[] r = this.update(new Object[]{obj});
            return r[0];
        }

        public int[] update(Object ... objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
            int[] results;
            try (Transaction transaction = this.beginTransaction(IsolationLevel.ReadUncommitted);){
                results = transaction.update(objects);
                transaction.commit();
            }
            return results;
        }

        public int[] update(Collection<?> objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
            return this.update(objects.toArray());
        }

        public int delete(Object obj) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
            int[] r = this.delete(new Object[]{obj});
            return r[0];
        }

        public int[] delete(Object ... objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
            int[] results;
            try (Transaction transaction = this.beginTransaction(IsolationLevel.ReadUncommitted);){
                results = transaction.delete(objects);
                transaction.commit();
            }
            return results;
        }

        public int[] delete(Collection<?> objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
            return this.delete(objects.toArray());
        }

        public int merge(Object obj) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
            int[] r = this.merge(new Object[]{obj});
            return r[0];
        }

        public int[] merge(Object ... objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
            int[] results;
            try (Transaction transaction = this.beginTransaction(IsolationLevel.ReadUncommitted);){
                results = transaction.merge(objects);
                transaction.commit();
            }
            return results;
        }

        public int[] merge(Collection<?> objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
            return this.merge(objects.toArray());
        }
    }
}

