/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.sql;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.sql.RowSet;
import javax.sql.rowset.CachedRowSet;
import net.osdn.util.concurrent.Monitor;
import net.osdn.util.sql.DataSource;
import net.osdn.util.sql.IsolationLevel;
import net.osdn.util.sql.NamedParameter;
import net.osdn.util.sql.NamedParameterStatement;
import net.osdn.util.sql.ORMapper;
import net.osdn.util.sql.OptimisticConcurrencyException;
import net.osdn.util.sql.Table;

public class Transaction
implements Closeable {
    private DataSource.Instance datasource;
    private IsolationLevel isolationLevel;
    private Connection cn;
    private boolean isCommitted = false;

    Transaction(DataSource.Instance datasource, IsolationLevel isolationLevel) throws SQLException {
        this.datasource = datasource;
        this.isolationLevel = isolationLevel;
        this.cn = datasource.getConnection();
        if (isolationLevel != null) {
            if (this.cn.getTransactionIsolation() != isolationLevel.getValue()) {
                this.cn.setTransactionIsolation(isolationLevel.getValue());
            }
            if (isolationLevel != IsolationLevel.None && this.cn.getAutoCommit()) {
                this.cn.setAutoCommit(false);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.cn != null && !this.cn.isClosed()) {
                if (this.isolationLevel != null && !this.isCommitted) {
                    this.cn.rollback();
                }
                this.cn.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void commit() throws SQLException {
        if (this.isolationLevel == null) {
            throw new IllegalStateException();
        }
        this.cn.commit();
        this.isCommitted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet executeQuery(String sql) throws SQLException {
        CachedRowSet rowSet = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.cn.createStatement();
            rs = st.executeQuery(sql);
            rowSet = this.datasource.populate(rs);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        return rowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet executeQuery(String sql, Object ... parameters) throws SQLException {
        CachedRowSet rowSet = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.cn.prepareStatement(sql);
            if (parameters != null) {
                if (parameters instanceof NamedParameter[]) {
                    for (NamedParameter parameter : (NamedParameter[])parameters) {
                        parameter.applyTo(st);
                    }
                } else {
                    int i = 0;
                    for (Object parameter : parameters) {
                        st.setObject(++i, parameter);
                    }
                }
            }
            rs = st.executeQuery();
            rowSet = this.datasource.populate(rs);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        return rowSet;
    }

    public RowSet executeQuery(String sql, Collection<?> parameters) throws SQLException {
        return this.executeQuery(sql, parameters.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet executeQuery(NamedParameterStatement statement) throws SQLException {
        CachedRowSet rowSet = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.cn.prepareStatement(statement.getSql());
            for (NamedParameter parameter : statement.getParameters()) {
                parameter.applyTo(st);
            }
            rs = st.executeQuery();
            rowSet = this.datasource.populate(rs);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        return rowSet;
    }

    public int executeUpdate(String sql, Object ... parameters) throws SQLException {
        String notifier = DataSource.findTableName(sql);
        return this.executeUpdate((Object)notifier, sql, parameters);
    }

    public int executeUpdate(String sql, Collection<?> parameters) throws SQLException {
        return this.executeUpdate(sql, parameters.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(NamedParameterStatement statement) throws SQLException {
        int rowCount;
        try (PreparedStatement st = null;){
            st = this.cn.prepareStatement(statement.getSql());
            for (NamedParameter parameter : statement.getParameters()) {
                parameter.applyTo(st);
            }
            rowCount = st.executeUpdate();
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(Object notifier, String sql, Object ... parameters) throws SQLException {
        int rowCount;
        try (PreparedStatement st = null;){
            st = this.cn.prepareStatement(sql);
            if (parameters != null) {
                if (parameters instanceof NamedParameter[]) {
                    for (NamedParameter parameter : (NamedParameter[])parameters) {
                        parameter.applyTo(st);
                    }
                } else {
                    int i = 0;
                    for (Object parameter : parameters) {
                        st.setObject(++i, parameter);
                    }
                }
            }
            if ((rowCount = st.executeUpdate()) > 0 && notifier != null) {
                DataSource.getMonitor().notifyAll(notifier);
            }
        }
        return rowCount;
    }

    public int executeUpdate(Object notifier, String sql, Collection<?> parameters) throws SQLException {
        return this.executeUpdate(notifier, sql, parameters.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(Object notifier, NamedParameterStatement statement) throws SQLException {
        int rowCount;
        try (PreparedStatement st = null;){
            st = this.cn.prepareStatement(statement.getSql());
            for (NamedParameter parameter : statement.getParameters()) {
                parameter.applyTo(st);
            }
            rowCount = st.executeUpdate();
            if (rowCount > 0 && notifier != null) {
                DataSource.getMonitor().notifyAll(notifier);
            }
        }
        return rowCount;
    }

    public RowSet executeQueryWaitForRows(long timeout, String sql, Object ... parameters) throws SQLException, TimeoutException, InterruptedException {
        Monitor.MultipleObjects waiters = null;
        String tableName = DataSource.findTableName(sql);
        if (tableName != null) {
            waiters = DataSource.newMultipleObjects(timeout, tableName);
        }
        return this.executeQueryWaitForRows(waiters, sql, parameters);
    }

    public RowSet executeQueryWaitForRows(long timeout, String sql, Collection<?> parameters) throws SQLException, TimeoutException, InterruptedException {
        return this.executeQueryWaitForRows(timeout, sql, parameters.toArray());
    }

    public RowSet executeQueryWaitForRows(long timeout, NamedParameterStatement statement) throws SQLException, TimeoutException, InterruptedException {
        Monitor.MultipleObjects waiters = null;
        String tableName = DataSource.findTableName(statement.getSql());
        if (tableName != null) {
            waiters = DataSource.newMultipleObjects(timeout, tableName);
        }
        return this.executeQueryWaitForRows(waiters, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet executeQueryWaitForRows(Monitor.MultipleObjects waiters, String sql, Object ... parameters) throws SQLException, TimeoutException, InterruptedException {
        CachedRowSet rowSet = null;
        try (PreparedStatement st = null;){
            st = this.cn.prepareStatement(sql);
            if (parameters != null) {
                if (parameters instanceof NamedParameter[]) {
                    for (NamedParameter parameter : (NamedParameter[])parameters) {
                        parameter.applyTo(st);
                    }
                } else {
                    int i = 0;
                    for (Object parameter : parameters) {
                        st.setObject(++i, parameter);
                    }
                }
            }
            do {
                try (ResultSet rs = null;){
                    rs = st.executeQuery();
                    rowSet = DataSource.populate(rs);
                }
                if (rowSet.next()) {
                    rowSet.beforeFirst();
                } else {
                    rowSet = null;
                    if (waiters != null) continue;
                }
                break;
            } while (waiters.waitForMultipleObjects() != null);
        }
        if (rowSet == null) {
            throw new TimeoutException();
        }
        return rowSet;
    }

    public RowSet executeQueryWaitForRows(Monitor.MultipleObjects waiters, String sql, Collection<?> parameters) throws SQLException, TimeoutException, InterruptedException {
        return this.executeQueryWaitForRows(waiters, sql, parameters.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet executeQueryWaitForRows(Monitor.MultipleObjects waiters, NamedParameterStatement statement) throws SQLException, TimeoutException, InterruptedException {
        CachedRowSet rowSet = null;
        try (PreparedStatement st = null;){
            st = this.cn.prepareStatement(statement.getSql());
            for (NamedParameter parameter : statement.getParameters()) {
                parameter.applyTo(st);
            }
            do {
                try (ResultSet rs = null;){
                    rs = st.executeQuery();
                    rowSet = DataSource.populate(rs);
                }
                if (rowSet.next()) {
                    rowSet.beforeFirst();
                } else {
                    rowSet = null;
                    if (waiters != null) continue;
                }
                break;
            } while (waiters.waitForMultipleObjects() != null);
        }
        if (rowSet == null) {
            throw new TimeoutException();
        }
        return rowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeScalar(String sql) throws SQLException {
        Object value = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.cn.createStatement();
            rs = st.executeQuery(sql);
            if (rs.next()) {
                value = rs.getObject(1);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        Object result = value;
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeScalar(String sql, Object ... parameters) throws SQLException {
        Object value = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.cn.prepareStatement(sql);
            if (parameters != null) {
                if (parameters instanceof NamedParameter[]) {
                    for (NamedParameter parameter : (NamedParameter[])parameters) {
                        parameter.applyTo(st);
                    }
                } else {
                    int i = 0;
                    for (Object parameter : parameters) {
                        st.setObject(++i, parameter);
                    }
                }
            }
            if ((rs = st.executeQuery()).next()) {
                value = rs.getObject(1);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        Object result = value;
        return (T)result;
    }

    public <T> T executeScalar(String sql, Collection<?> parameters) throws SQLException {
        return this.executeScalar(sql, parameters.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeScalar(NamedParameterStatement statement) throws SQLException {
        Object value = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.cn.prepareStatement(statement.getSql());
            for (NamedParameter parameter : statement.getParameters()) {
                parameter.applyTo(st);
            }
            rs = st.executeQuery();
            if (rs.next()) {
                value = rs.getObject(1);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
        Object result = value;
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T select(String columnName, Object obj) throws SQLException, IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        ResultSet rs = null;
        try {
            String tableName = obj instanceof Table ? ((Table)obj).getTableName() : ORMapper.getTableName(this.cn, obj.getClass());
            rs = ORMapper.select(this.cn, tableName, obj);
            if (rs.next()) {
                Object value = rs.getObject(columnName);
                if (!rs.wasNull()) {
                    Object result;
                    Object object = result = value;
                    return (T)object;
                }
            }
            T t = null;
            return t;
        }
        finally {
            if (rs != null) {
                Statement st = rs.getStatement();
                rs.close();
                if (st != null) {
                    st.close();
                }
            }
        }
    }

    public <T> T select(Object obj) throws SQLException, ParseException, ReflectiveOperationException {
        Class<?> cls = obj.getClass();
        while (cls.isAnonymousClass()) {
            cls = cls.getSuperclass();
        }
        Class<?> returnClass = cls;
        return (T)this.select(returnClass, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T select(Class<T> returnClass) throws SQLException, ParseException, ReflectiveOperationException {
        ResultSet rs = null;
        try {
            rs = ORMapper.select(this.cn, returnClass);
            if (rs.next()) {
                T t = new ORMapper(rs).get(returnClass);
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            if (rs != null) {
                Statement st = rs.getStatement();
                rs.close();
                if (st != null) {
                    st.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T select(Class<T> returnClass, Object obj) throws SQLException, ParseException, ReflectiveOperationException {
        ResultSet rs = null;
        try {
            String tableName = obj instanceof Table ? ((Table)obj).getTableName() : ORMapper.getTableName(this.cn, returnClass);
            rs = ORMapper.select(this.cn, tableName, obj);
            if (rs.next()) {
                T t = new ORMapper(rs).get(returnClass);
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            if (rs != null) {
                Statement st = rs.getStatement();
                rs.close();
                if (st != null) {
                    st.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T select(Class<T> returnClass, String sql) throws SQLException, ParseException, ReflectiveOperationException {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.cn.createStatement();
            rs = st.executeQuery(sql);
            if (rs.next()) {
                T t = new ORMapper(rs).get(returnClass);
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public <T> T select(Class<T> returnClass, String sql, Object ... parameters) throws SQLException, ParseException, ReflectiveOperationException {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.cn.prepareStatement(sql);
            if (parameters != null) {
                if (parameters instanceof NamedParameter[]) {
                    for (NamedParameter parameter : (NamedParameter[])parameters) {
                        parameter.applyTo(st);
                    }
                } else {
                    boolean bl = false;
                    for (Object parameter : parameters) {
                        void var6_8;
                        st.setObject((int)(++var6_8), parameter);
                    }
                }
            }
            if ((rs = st.executeQuery()).next()) {
                T t = new ORMapper(rs).get(returnClass);
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    public <T> T select(Class<T> returnClass, String sql, Collection<?> parameters) throws SQLException, ParseException, ReflectiveOperationException {
        return this.select(returnClass, sql, parameters.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T select(Class<T> returnClass, NamedParameterStatement statement) throws SQLException, ParseException, ReflectiveOperationException {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.cn.prepareStatement(statement.getSql());
            for (NamedParameter parameter : statement.getParameters()) {
                parameter.applyTo(st);
            }
            rs = st.executeQuery();
            if (rs.next()) {
                T t = new ORMapper(rs).get(returnClass);
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    public <T> List<T> selectAsList(Class<T> returnClass) throws SQLException, ParseException, ReflectiveOperationException {
        return this.selectAsList(returnClass, (Object)null);
    }

    public <T> List<T> selectAsList(Object obj) throws SQLException, ParseException, ReflectiveOperationException {
        Class<?> cls = obj.getClass();
        while (cls.isAnonymousClass()) {
            cls = cls.getSuperclass();
        }
        Class<?> returnClass = cls;
        return this.selectAsList(returnClass, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> selectAsList(Class<T> returnClass, Object obj) throws SQLException, ParseException, ReflectiveOperationException {
        ResultSet rs = null;
        try {
            String tableName = obj instanceof Table ? ((Table)obj).getTableName() : ORMapper.getTableName(this.cn, returnClass);
            rs = ORMapper.select(this.cn, tableName, obj);
            List<T> list = new ORMapper(rs).getList(returnClass);
            return list;
        }
        finally {
            if (rs != null) {
                Statement st = rs.getStatement();
                rs.close();
                if (st != null) {
                    st.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> selectAsList(Class<T> returnClass, String sql) throws SQLException, ParseException, ReflectiveOperationException {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.cn.createStatement();
            rs = st.executeQuery(sql);
            List<T> list = new ORMapper(rs).getList(returnClass);
            return list;
        }
        finally {
            if (st != null) {
                st.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public <T> List<T> selectAsList(Class<T> returnClass, String sql, Object ... parameters) throws SQLException, ParseException, ReflectiveOperationException {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.cn.prepareStatement(sql);
            if (parameters != null) {
                if (parameters instanceof NamedParameter[]) {
                    for (NamedParameter parameter : (NamedParameter[])parameters) {
                        parameter.applyTo(st);
                    }
                } else {
                    boolean bl = false;
                    for (Object parameter : parameters) {
                        void var6_8;
                        st.setObject((int)(++var6_8), parameter);
                    }
                }
            }
            rs = st.executeQuery();
            List<T> list = new ORMapper(rs).getList(returnClass);
            return list;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    public <T> List<T> selectAsList(Class<T> returnClass, String sql, Collection<?> parameters) throws SQLException, ParseException, ReflectiveOperationException {
        return this.selectAsList(returnClass, sql, parameters.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> selectAsList(Class<T> returnClass, NamedParameterStatement statement) throws SQLException, ParseException, ReflectiveOperationException {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            st = this.cn.prepareStatement(statement.getSql());
            for (NamedParameter parameter : statement.getParameters()) {
                parameter.applyTo(st);
            }
            rs = st.executeQuery();
            List<T> list = new ORMapper(rs).getList(returnClass);
            return list;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    public int insert(Object obj) throws SQLException, IllegalAccessException {
        int[] r = this.insert(new Object[]{obj});
        return r[0];
    }

    public int[] insert(Object ... objects) throws SQLException, IllegalAccessException {
        int[] results = ORMapper.insert(this.cn, objects);
        return results;
    }

    public int[] insert(Collection<?> objects) throws SQLException, IllegalAccessException {
        return this.insert(objects.toArray());
    }

    public int update(Object obj) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        int[] r = this.update(new Object[]{obj});
        return r[0];
    }

    public int[] update(Object ... objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        int[] results = ORMapper.update(this.cn, objects);
        return results;
    }

    public int[] update(Collection<?> objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        return this.update(objects.toArray());
    }

    public int delete(Object obj) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        int[] r = this.delete(new Object[]{obj});
        return r[0];
    }

    public int[] delete(Object ... objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        int[] results = ORMapper.delete(this.cn, objects);
        return results;
    }

    public int[] delete(Collection<?> objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        return this.delete(objects.toArray());
    }

    public int merge(Object obj) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        int[] r = this.merge(new Object[]{obj});
        return r[0];
    }

    public int[] merge(Object ... objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        int[] results = ORMapper.merge(this.cn, objects);
        return results;
    }

    public int[] merge(Collection<?> objects) throws OptimisticConcurrencyException, SQLException, IllegalAccessException {
        return this.merge(objects.toArray());
    }
}

