/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.sql;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.osdn.util.sql.ORMapper;

public class ObjectIterator<E>
implements Iterator<E> {
    private Class<E> type;
    private ResultSet rs;
    private String[] columnNames;
    private int columnCount;
    private Map<String, Field> fields;
    private Boolean hasNext;

    public ObjectIterator(Class<E> type, ResultSet rs) throws SQLException {
        this.type = type;
        this.rs = rs;
        this.columnNames = ORMapper.getColumnNames(rs.getMetaData());
        this.columnCount = rs.getMetaData().getColumnCount();
        this.fields = ORMapper.getFields(type);
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext == null) {
            try {
                this.hasNext = this.rs.next();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.hasNext;
    }

    @Override
    public E next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasNext = null;
        try {
            E obj = ORMapper.createInstance(this.type);
            for (int i = 1; i <= this.columnCount; ++i) {
                Field field = this.fields.get(this.columnNames[i]);
                if (field == null) continue;
                Object value = ORMapper.getValue(this.rs, i, field);
                field.set(obj, value);
            }
            return obj;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

