/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSet;

public class RowSetSerializer
extends JsonSerializer<RowSet> {
    public void serialize(RowSet rs, JsonGenerator json, SerializerProvider provider) throws IOException, JsonProcessingException {
        json.writeStartArray();
        try {
            int i;
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            String[] columnNames = new String[columnCount + 1];
            for (i = 1; i <= columnCount; ++i) {
                columnNames[i] = meta.getColumnLabel(i);
            }
            while (rs.next()) {
                json.writeStartObject();
                for (i = 1; i <= columnCount; ++i) {
                    String value = rs.getString(i);
                    if (rs.wasNull()) {
                        value = "";
                    }
                    json.writeStringField(columnNames[i], value);
                }
                json.writeEndObject();
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        json.writeEndArray();
    }
}

