/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.jersey.log;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LoggingInputStream
extends InputStream {
    private InputStream in;
    private OutputStream log;
    private Runnable callback;

    public LoggingInputStream(InputStream in, OutputStream log, Runnable callback) {
        this.in = in;
        this.log = log;
        this.callback = callback;
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        try {
            if (b == -1) {
                this.log.close();
                if (this.callback != null) {
                    this.callback.run();
                }
            } else {
                this.log.write(b);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int size = this.in.read(b);
        try {
            if (size == -1) {
                this.log.close();
                if (this.callback != null) {
                    this.callback.run();
                }
            } else if (size > 0) {
                this.log.write(b);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int size = this.in.read(b, off, len);
        try {
            if (size == -1) {
                this.log.close();
                if (this.callback != null) {
                    this.callback.run();
                }
            } else if (size > 0) {
                this.log.write(b, off, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }
}

