use strict;

my ($species,$revision) = @ARGV;
my $keykind = 'Gene Name';

my $chrname_map = {
  'chrI'          => 'chr01',
  'chrII'         => 'chr02',
  'chrIII'        => 'chr03',
  'chrIV'         => 'chr04',
  'chrV'          => 'chr05',
  'chrVI'         => 'chr06',
  'chrVII'        => 'chr07',
  'chrVIII'       => 'chr08',
  'chrIX'         => 'chr09',
  'chrX'          => 'chr10',
  'chrXI'         => 'chr11',
  'chrXII'        => 'chr12',
  'chrXIII'       => 'chr13',
  'chrXIV'        => 'chr14',
  'chrXV'         => 'chr15',
  'chrXVI'        => 'chr16',
  'mitochondrion' => 'chrmt',
};

if( defined $species and defined $revision ) {
  print "INSERT INTO knownkeykind (species,revision,keykind) VALUES ('$species','$revision','$keykind');\n";

  foreach my $line ( <STDIN> ) {
    while( (substr $line, (length $line)-1, 1) =~ /[\r\n]/ ) { chop $line; }
    my ($seqid,$source,$type,$start,$end,$score,$strand,$phase,$attributes_str) = split /\t/, $line;
    my $attributes = parse_attributes( $attributes_str );
    if( $type eq 'gene' ) {
      my %geneNames;
      if( defined $attributes->{ID} )    { $geneNames{$attributes->{ID}} = 1; }
      if( defined $attributes->{Name} )  { $geneNames{$attributes->{Name}} = 1; }
      if( defined $attributes->{gene} )  { $geneNames{$attributes->{gene}} = 1; }
      if( defined $attributes->{Alias} ) { $geneNames{$attributes->{Alias}} = 1; }
      foreach my $geneName ( keys %geneNames ) {
        $geneName =~ s/['"]//g;
        print "INSERT INTO keyword (kkkid,keyword) VALUES ((SELECT kkkid FROM knownkeykind WHERE species='$species' and revision='$revision' and keykind='$keykind'),'$geneName');\n";
        print "INSERT INTO gene (kid) VALUES ((SELECT kid FROM keyword WHERE kkkid=(SELECT kkkid FROM knownkeykind WHERE species='$species' and revision='$revision' and keykind='$keykind') and keyword='$geneName'));\n";
        print "INSERT INTO location (gid,target,t_start,t_end) VALUES ((SELECT gid FROM gene WHERE kid=(SELECT kid FROM keyword WHERE kkkid=(SELECT kkkid FROM knownkeykind WHERE species='$species' and revision='$revision' and keykind='$keykind') and keyword='$geneName')), '$chrname_map->{$seqid}',$start,$end);\n";
      }
    }
  }
}

sub parse_attributes {
  my ($attributes_str) = @_;
  my $attributes = {};
  foreach( split /;/, $attributes_str ) {
    my($key,$val) = split /=/;
    $attributes->{$key} = $val;
  }
  return $attributes;
}

sub urldecode {
  my $buff = shift;
  $buff =~ tr/+/ /;
  $buff =~ s/%([0-9a-fA-F]{2})/chr(hex($1))/eg;
  return $buff;
}
