use strict;

my ($species,$revision) = @ARGV;

my $chrname_map = {
  'chrI'          => 'chr01',
  'chrII'         => 'chr02',
  'chrIII'        => 'chr03',
  'chrIV'         => 'chr04',
  'chrV'          => 'chr05',
  'chrVI'         => 'chr06',
  'chrVII'        => 'chr07',
  'chrVIII'       => 'chr08',
  'chrIX'         => 'chr09',
  'chrX'          => 'chr10',
  'chrXI'         => 'chr11',
  'chrXII'        => 'chr12',
  'chrXIII'       => 'chr13',
  'chrXIV'        => 'chr14',
  'chrXV'         => 'chr15',
  'mitochondrion' => 'chrmt',
};

if( defined $species and defined $revision ) {
  print "geneTrack name=yeastGenes species=$species revision=$revision\n";

  my ($currentGene);
  while( <STDIN> ) {
    my ($seqid,$source,$type,$start,$end,$score,$strand,$phase,$attributes_str) = split /\t/;
    my $attributes = parse_attributes( $attributes_str );
    if( $type eq 'gene' ) {
      if( defined $currentGene ) {
        print_gene( $currentGene );
        undef $currentGene;
      }
      $currentGene = {
        id     => $attributes->{ID},
        name   => $attributes->{Name},
        note   => urldecode( $attributes->{Note} ),
        target => $chrname_map->{$seqid},
        start  => $start,
        end    => $end,
        strand => $strand,
        exons  => [],
      };
    }
    elsif( $type eq 'CDS' && $attributes->{Parent} eq $currentGene->{id} ) {
      push @{$currentGene->{exons}}, { start => $start, end => $end };
    }
  }
  if( defined $currentGene ) {
    print_gene( $currentGene );
  }
}

sub parse_attributes {
  my ($attributes_str) = @_;
  my $attributes = {};
  foreach( split /;/, $attributes_str ) {
    my($key,$val) = split /=/;
    $attributes->{$key} = $val;
  }
  return $attributes;
}

sub print_gene {
  my ($currentGene) = @_;
  print "gene target=$currentGene->{target} name=$currentGene->{name} strand=$currentGene->{strand} range=$currentGene->{start},$currentGene->{end} url=http://db.yeastgenome.org/cgi-bin/search/quickSearch?query=$currentGene->{name} ";
  foreach( @{$currentGene->{exons}} ) {
    print "exon=$_->{start},$_->{end} "
  }
  print "\n";
}

sub urldecode {
  my $buff = shift;
  $buff =~ tr/+/ /;
  $buff =~ s/%([0-9a-fA-F]{2})/chr(hex($1))/eg;
  return $buff;
}
