-- trackinformation

BEGIN;

CREATE TABLE users (
  uid serial PRIMARY KEY,
  name varchar(32) NOT NULL,
  password varchar(32) NOT NULL,
  e_mail varchar,
  authority varchar(8),
  UNIQUE (name)
);
CREATE INDEX users_name_index ON users (name);

CREATE TABLE track (
  tid serial PRIMARY KEY,
  name varchar NOT NULL, -- ex. mappedGene
  species varchar NOT NULL,
  revision varchar NOT NULL,
  uid integer REFERENCES users (uid),
  kind varchar(8) NOT NULL, -- ex. system/gene/graph/color/gene2/graph2/color2
  exhibit varchar(8) NOT NULL, -- ex. public / private
  data_location varchar NOT NULL,
  description_url varchar,
  comment varchar,
  species_url varchar,
  optattr_str varchar,
  optparam varchar,
  color_r integer,
  color_g integer,
  color_b integer,
  UNIQUE (name, species,revision, uid)
);
CREATE INDEX track_species_index ON track (species);
CREATE INDEX track_revision_index ON track (revision);
CREATE INDEX track_name_index ON track (name);

CREATE TABLE history (
  hid serial PRIMARY KEY,
  tid integer NOT NULL REFERENCES track (tid),
  uid integer REFERENCES users (uid),
  time timestamp NOT NULL,
  operation varchar(8),
  comment varchar
);
CREATE INDEX history_tid_index ON history (tid);
CREATE INDEX history_uid_index ON history (uid);

CREATE TABLE trackorder (
  toid serial PRIMARY KEY,
  species varchar NOT NULL,
  revision varchar NOT NULL,
  uid integer REFERENCES users (uid),
  order_str varchar NOT NULL,
  remove_str varchar,
  UNIQUE (species,revision,uid)
);

CREATE TABLE disparam (
	did integer,
	species varchar,
	revision varchar,
	target varchar,
	start_position integer,
	end_position integer,
	width integer
);

COMMIT;
