-- targetsequence

BEGIN;
CREATE TABLE knownspecies (
  ksid serial PRIMARY KEY,
  species text NOT NULL,
  revision text NOT NULL,
  UNIQUE (species,revision)
);
CREATE INDEX knownspecies_species_index ON knownspecies (species);
CREATE INDEX knownspecies_revision_index ON knownspecies (revision);
CREATE TABLE targetseq (
  tsid serial PRIMARY KEY,
  ksid integer NOT NULL REFERENCES knownspecies (ksid),
  target text NOT NULL,
  sequence text NOT NULL CHECK (sequence ~ '^[ATGCN]*'),
  annotation text CHECK (annotation ~ '^>.*'),
  UNIQUE (ksid,target)
);
CREATE INDEX targetseq_ksid_index ON targetseq (ksid);
CREATE INDEX targetseq_target_index ON targetseq (target);
GRANT SELECT ON knownspecies,targetseq TO browser;

COMMIT;