-- synteny

BEGIN;
CREATE TABLE knownspecies (
  ksid     serial PRIMARY KEY,
  species  text   NOT NULL,
  revision text   NOT NULL,
  UNIQUE (species,revision)
);
CREATE INDEX knownspecies_species_index  ON knownspecies (species);
CREATE INDEX knownspecies_revision_index ON knownspecies (revision);
CREATE TABLE syntenicspecies (
  ssid        serial  PRIMARY KEY,
  fromspecies integer NOT NULL REFERENCES knownspecies (ksid),
  tospecies   integer NOT NULL REFERENCES knownspecies (ksid),
  method      text,
  UNIQUE (fromspecies,tospecies,method),
  CHECK (fromspecies<>tospecies)
);
CREATE INDEX syntenicspecies_from_to_species_index ON syntenicspecies(fromspecies,tospecies);
CREATE TABLE synteny (
  sid         serial  PRIMARY KEY,
  ssid        integer NOT NULL REFERENCES syntenicspecies (ssid),
  from_target text    NOT NULL,
  from_start  integer NOT NULL,
  from_end    integer NOT NULL,
  to_target   text    NOT NULL,
  to_start    integer NOT NULL,
  to_end      integer NOT NULL,
  match_ratio real,
  cover_ratio real,
  CHECK (abs(from_end-from_start)=abs(from_end-from_start))
);
CREATE INDEX synteny_ssid_index ON synteny (ssid);
CREATE INDEX synteny_from_target_index ON synteny (from_target);
CREATE INDEX synteny_from_start_end_index ON synteny (from_start,from_end);
CREATE INDEX synteny_to_target_index ON synteny (to_target);
CREATE INDEX synteny_to_start_end_index ON synteny (to_start,to_end);
GRANT SELECT ON knownspecies,syntenicspecies,synteny TO browser;

COMMIT;