-- keywordsearch

  BEGIN;
  CREATE TABLE knownkeykind (
    kkkid    serial PRIMARY KEY,
    species  text   NOT NULL,
    revision text   NOT NULL,
    keykind  text   NOT NULL,
    UNIQUE (species,revision,keykind)
  );
  CREATE INDEX knownkeykind_species_index  ON knownkeykind (species);
  CREATE INDEX knownkeykind_revision_index ON knownkeykind (revision);
  CREATE INDEX knownkeykind_keykind_index  ON knownkeykind (keykind);
  CREATE TABLE keyword (
    kid        serial  PRIMARY KEY,
    kkkid      integer NOT NULL REFERENCES knownkeykind (kkkid),
    keyword    text    NOT NULL,
    UNIQUE (kkkid,keyword)
  );
  CREATE INDEX keyword_kkkid_index ON keyword (kkkid);
  CREATE INDEX keyword_keyword_index ON keyword (keyword);
  CREATE TABLE gene (
    gid          serial  PRIMARY KEY,
    kid          integer NOT NULL REFERENCES keyword (kid),
    annotation   text    CHECK (annotation ~ '^>.*\$'),
    UNIQUE (kid,annotation)
  );
  CREATE INDEX gene_kid_index ON gene (kid);
  CREATE INDEX gene_annotation_index ON gene (annotation);
  CREATE TABLE location (
    lid     serial  PRIMARY KEY,
    gid     integer NOT NULL REFERENCES gene (gid),
    target  text    NOT NULL,
    t_start integer NOT NULL,
    t_end   integer NOT NULL,
    cover   real,
    match   real,
    UNIQUE (gid,target,t_start,t_end)
  );
  CREATE INDEX location_gid_index ON location (gid);
  GRANT SELECT ON knownkeykind,keyword,gene,location TO browser;
  COMMIT;
