-- acceptspecies

BEGIN;

CREATE TABLE knownspecies (
  ksid serial PRIMARY KEY,
  species text NOT NULL,
  revision text NOT NULL,
  UNIQUE (species,revision)
);
CREATE INDEX knownspecies_species_index ON knownspecies (species);
CREATE INDEX knownspecies_revision_index ON knownspecies (revision);
CREATE TABLE targetlen (
  tlid serial PRIMARY KEY,
  ksid integer NOT NULL REFERENCES knownspecies (ksid),
  target text NOT NULL,
  length integer NOT NULL,
  UNIQUE (ksid,target)
);
CREATE INDEX targetlen_ksid_index ON targetlen (ksid);
CREATE INDEX targetlen_target_index ON targetlen (target);
GRANT SELECT ON knownspecies,targetlen TO browser;

COMMIT;