# ύXĂ+++++++++++++++++++++++++++++++
$BROWSER_URL="http://www.utgenome.org";
$DB_HOST="localhost";
$DBNAME_PREFIX="test";
$species="yeast";
$revision="200407";
$default_target="chr1";
$default_start="1";
$default_end="338304";
$default_width="800";
# +++++++++++++++++++++++++++++++++++++++++++++++++++++

$msg = system("cat $ARGV[0] | perl tools/fasta2acceptspecies_db.pl $species $revision | psql -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}acceptspecies");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

$msg = system("cat $ARGV[0] | perl tools/fasta2targetsequence_db.pl $species $revision | psql -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}targetsequence");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

my $track_str =  <<EOF;
BEGIN;

-- disparam
INSERT INTO disparam (species,revision,target,start_position,end_position,width)
VALUES ('$species','$revision','$default_target',$default_start,$default_end,$default_width);

INSERT INTO track (species, revision, name, kind, exhibit, data_location )
 VALUES ('$species', '$revision', 'Overview Track', 'system', 'public', '$BROWSER_URL/genome_browser/tracks/overview/overview.xml');
INSERT INTO history (tid,  time, operation, comment) VALUES
( (SELECT tid FROM track WHERE species='$species' AND revision='$revision' AND name='Overview Track' ),
'2005-03-23 00:00:00', 'create', 'create');

INSERT INTO track (species, revision, name, kind, exhibit, data_location )
 VALUES ('$species', '$revision', 'Ruler Track', 'system', 'public', '$BROWSER_URL/genome_browser/tracks/ruler/rulertrack.xml');
INSERT INTO history (tid,  time, operation, comment) VALUES
( (SELECT tid FROM track WHERE species='$species' AND revision='$revision' AND name='Ruler Track' ),
'2005-03-23 00:00:00', 'create', 'create');

INSERT INTO track (species, revision, name, kind, exhibit, data_location )
 VALUES ('$species', '$revision', 'Zooming Track', 'system', 'public', '$BROWSER_URL/genome_browser/tracks/zoomer/zoomertrack.xml');
INSERT INTO history (tid,  time, operation, comment) VALUES
( (SELECT tid FROM track WHERE species='$species' AND revision='$revision' AND name='Zooming Track' ),
'2005-03-23 00:00:00', 'create', 'create');

INSERT INTO track (species, revision, name, kind, exhibit, data_location )
 VALUES ('$species', '$revision', 'BaseColor', 'system', 'public', '$BROWSER_URL/genome_browser/tracks/basecolor/basecolortrack.xml');
INSERT INTO history (tid,  time, operation, comment) VALUES
( (SELECT tid FROM track WHERE species='$species' AND revision='$revision' AND name='BaseColor' ),
'2005-03-23 00:00:00', 'create', 'create');

INSERT INTO TRACKORDER (SPECIES,REVISION,ORDER_STR)
VALUES
('$species', '$revision','Overview Track:Ruler Track:Zooming Track:BaseColor');

COMMIT;
EOF

open SQL, "| psql -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}trackinformation";
print SQL $track_str;
close SQL;

