#========================================================================
# UT Genome Browser 1.0 RC1
#                                                             2005.12.15
#========================================================================
#
# ύXĂ+++++++++++++++++++++++++++++++
$PG_BIN="/usr/bin";
$HTDOCS_PATH="/var/www";
$BROWSER_URL="http://wwww.utgenome.org";
$DB_HOST="localhost";
$DBNAME_PREFIX="test";
$DB_USER="browser";
# +++++++++++++++++++++++++++++++++++++++++++++++++++++

open LOG,">>install.log" or die "Cann not create 'install.log'\n";
$msg = "====START INSTALL====\n";
print $msg."\n";
print LOG $msg."\n";

###################################
#	CREATE 'browser_config.php'
###################################

open CONFIG, '>browser_config.php' or die "Cannot create 'browser_config.php'";

#-- browser_config.php ----------------------------------------------------------
print CONFIG <<HERE;
<?php
  ///////////////////////////////////////////////////////////////////////////////
  // UT Genome Browser Configurations
  ///////////////////////////////////////////////////////////////////////////////

  // base_url
  \$base_url="$BROWSER_URL/genome_browser/";
  \$htdocs_path="$HTDOCS_PATH/genome_browser";

  //utgb_DB_user
  \$utgb_DB_user = "$DB_USER";

  // replica host of CacheDB
  \$utgb_cachedb_insert_host = "";
  \$utgb_cachedb_public_host = "localhost";

  // DB configurations.
  \$acceptspecies_connection_string  = "host=${DB_HOST} dbname=${DBNAME_PREFIX}acceptspecies user=\$utgb_DB_user";
  \$targetsequence_connection_string = "host=${DB_HOST} dbname=${DBNAME_PREFIX}targetsequence user=\$utgb_DB_user";
  \$keywordsearch_connection_string  = "host=${DB_HOST} dbname=${DBNAME_PREFIX}keywordsearch user=\$utgb_DB_user";
  \$synteny_connection_string        = "host=${DB_HOST} dbname=${DBNAME_PREFIX}synteny user=\$utgb_DB_user";
  \$session_connection_string        = "host=${DB_HOST} dbname=${DBNAME_PREFIX}session user=\$utgb_DB_user";
  \$trackinformation_connection_string  = "host=${DB_HOST} dbname=${DBNAME_PREFIX}trackinformation user=\$utgb_DB_user";

 // OpenSSL configurations.
  \$openssl_certs_dir = './certs/';
  \$openssl_privatekey_filename  = 'privatekey';
  \$openssl_certificate_filename = 'certificate';
  \$openssl_certreq_filename     = 'certreq';
  \$openssl_privatekey_password  = 'nlutriuBrlaphiaylejoe9riurlAdr4u';
  \$openssl_expiration = 100 * 365;

  \$openssl_dn = array(
    'countryName' => 'XX',
    'stateOrProvinceName' => 'State',
    'localityName' => 'SomewhereCity',
    'organizationName' => 'MySelf',
    'organizationalUnitName' => 'Whatever',
    'commonName' => 'mySelf',
    'emailAddress' => 'user@domain.com'
   );

  // Font File
  \$utgb_font_Abadi_file = './fonts/Abadi MT Condensed Light.ttf';
	\$utgb_font_Abadi_file = realpath(\$utgb_font_Abadi_file);
	if (\$utgb_font_Abadi_file == "") {
		// call from renderer
    \$utgb_font_Abadi_file = '../fonts/Abadi MT Condensed Light.ttf';
    \$utgb_font_Abadi_file = realpath(\$utgb_font_Abadi_file);
	}

  // Cache Directory
  \$utgb_cache_dir = './cache';
	\$utgb_cache_real_dir = realpath(\$utgb_cache_dir);

	if (\$utgb_cache_real_dir == "") {
		// call from renderer
	  \$utgb_cache_dir = '../cache';
		\$utgb_cache_real_dir = realpath(\$utgb_cache_dir);
	}
  \$utgb_cache_binary_dir = \$utgb_cache_real_dir.'/binary';
  \$utgb_cache_add_track_file = \$utgb_cache_binary_dir.'/addtrack';
  \$utgb_cache_search_gene_file = \$utgb_cache_binary_dir.'/testgene';
  \$utgb_cache_search_graph_file = \$utgb_cache_binary_dir.'/testgraph';
  \$utgb_cache_search_color_file = \$utgb_cache_binary_dir.'/testcolor';

  \$utgb_cache_graphcolor_dir = './CacheData';

  // EasyTrack File Upload Directory
  \$utgb_uploaded_easytrack_dir = './uploaded_easytrack';
	\$utgb_uploaded_easytrack_dir = realpath(\$utgb_uploaded_easytrack_dir);

  // Log Directory
  \$utgb_log_dir = './log';
	\$utgb_log_dir = realpath(\$utgb_log_dir);

  // PostgreSQL installed directory
  \$utgb_postgre_install_dir = "$POSTGRES_HOME";

  // undisplay_modify
	\$disable_modify['BaseColor'] = 1 ;
?>
HERE
#--------------------------------------------------------------------------------

$msg = system("mv browser_config.php ./genome_browser");
print $msg;
print LOG $msg;

#############################
#	COPY DIRECTORY AND FILE
#############################
$msg = system("mkdir -p ".$HTDOCS_PATH."/"."genome_browser");

if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}
$msg = system("cp -r genome_browser/* ".$HTDOCS_PATH."/genome_browser");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

# log
$msg = system("chmod 777 ".$HTDOCS_PATH."/genome_browser/log");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

# CacheDdata
$msg = system("chmod 777 ".$HTDOCS_PATH."/genome_browser/CacheData");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

# uploaded_easytrack
$msg = system("chmod 777 ".$HTDOCS_PATH."/genome_browser/uploaded_easytrack");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

# certs
$msg = system("chmod 777 ".$HTDOCS_PATH."/genome_browser/certs");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

###########################
#	CREATE '.htaccess'
###########################
$msg = system("echo 'DirectoryIndex browser_keyword.php' > ".$HTDOCS_PATH."/genome_browser/.htaccess");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

###########################
#	CREATE  *.sql
###########################
open ACCEPTSPECIES_SQL, '>sql/CreateTable_acceptspecies.sql' or die "Cannot create 'CreateTable_acceptspecies.sql'";
print ACCEPTSPECIES_SQL <<EOF;
BEGIN;

CREATE TABLE knownspecies (
  ksid serial PRIMARY KEY,
  species text NOT NULL,
  revision text NOT NULL,
  UNIQUE (species,revision)
);
CREATE INDEX knownspecies_species_index ON knownspecies (species);
CREATE INDEX knownspecies_revision_index ON knownspecies (revision);
CREATE TABLE targetlen (
  tlid serial PRIMARY KEY,
  ksid integer NOT NULL REFERENCES knownspecies (ksid),
  target text NOT NULL,
  length integer NOT NULL,
  UNIQUE (ksid,target)
);
CREATE INDEX targetlen_ksid_index ON targetlen (ksid);
CREATE INDEX targetlen_target_index ON targetlen (target);
REVOKE ALL ON DATABASE ${DBNAME_PREFIX}acceptspecies FROM $DB_USER;
GRANT SELECT ON knownspecies,targetlen TO $DB_USER;

COMMIT;
EOF

close ACCEPTSPECIES_SQL;

open TARGETSEQUENCE_SQL, '>sql/CreateTable_targetsequence.sql' or die "Cannot create 'CreateTable_targetsequence.sql'";
print TARGETSEQUENCE_SQL <<EOF;
BEGIN;
CREATE TABLE knownspecies (
  ksid serial PRIMARY KEY,
  species text NOT NULL,
  revision text NOT NULL,
  UNIQUE (species,revision)
);
CREATE INDEX knownspecies_species_index ON knownspecies (species);
CREATE INDEX knownspecies_revision_index ON knownspecies (revision);
CREATE TABLE targetseq (
  tsid serial PRIMARY KEY,
  ksid integer NOT NULL REFERENCES knownspecies (ksid),
  target text NOT NULL,
  sequence text NOT NULL CHECK (sequence ~ '^[ATGCN]*'),
  annotation text CHECK (annotation ~ '^>.*'),
  UNIQUE (ksid,target)
);
CREATE INDEX targetseq_ksid_index ON targetseq (ksid);
CREATE INDEX targetseq_target_index ON targetseq (target);
REVOKE ALL ON DATABASE ${DBNAME_PREFIX}acceptspecies FROM $DB_USER;
GRANT SELECT ON knownspecies,targetseq TO $DB_USER;

COMMIT;
EOF

close TARGETSEQUENCE_SQL;

open KEYWORDSEARCH_SQL, '>sql/CreateTable_keywordsearch.sql' or die "Cannot create 'CreateTable_keywordsearch.sql'";
print KEYWORDSEARCH_SQL <<EOF;
BEGIN;
CREATE TABLE knownkeykind (
  kkkid    serial PRIMARY KEY,
  species  text   NOT NULL,
  revision text   NOT NULL,
  keykind  text   NOT NULL,
  UNIQUE (species,revision,keykind)
);
CREATE INDEX knownkeykind_species_index  ON knownkeykind (species);
CREATE INDEX knownkeykind_revision_index ON knownkeykind (revision);
CREATE INDEX knownkeykind_keykind_index  ON knownkeykind (keykind);
CREATE TABLE keyword (
  kid        serial  PRIMARY KEY,
  kkkid      integer NOT NULL REFERENCES knownkeykind (kkkid),
  keyword    text    NOT NULL,
  UNIQUE (kkkid,keyword)
);
CREATE INDEX keyword_kkkid_index ON keyword (kkkid);
CREATE INDEX keyword_keyword_index ON keyword (keyword);
CREATE TABLE gene (
  gid          serial  PRIMARY KEY,
  kid          integer NOT NULL REFERENCES keyword (kid),
  annotation   text    CHECK (annotation ~ '^>.*\$'),
  UNIQUE (kid,annotation)
);
CREATE INDEX gene_kid_index ON gene (kid);
CREATE INDEX gene_annotation_index ON gene (annotation);
CREATE TABLE location (
  lid     serial  PRIMARY KEY,
  gid     integer NOT NULL REFERENCES gene (gid),
  target  text    NOT NULL,
  t_start integer NOT NULL,
  t_end   integer NOT NULL,
  cover   real,
  match   real,
  UNIQUE (gid,target,t_start,t_end)
);
CREATE INDEX location_gid_index ON location (gid);
REVOKE ALL ON DATABASE ${DBNAME_PREFIX}keywordsearch FROM $DB_USER;
GRANT SELECT ON knownkeykind,keyword,gene,location TO $DB_USER;
COMMIT;
EOF

close KEYWORDSEARCH_SQL;

open SYNTENY_SQL, '>sql/CreateTable_synteny.sql' or die "Cannot create 'CreateTable_synteny.sql'";
print SYNTENY_SQL <<EOF;
BEGIN;
CREATE TABLE knownspecies (
  ksid     serial PRIMARY KEY,
  species  text   NOT NULL,
  revision text   NOT NULL,
  UNIQUE (species,revision)
);
CREATE INDEX knownspecies_species_index  ON knownspecies (species);
CREATE INDEX knownspecies_revision_index ON knownspecies (revision);
CREATE TABLE syntenicspecies (
  ssid        serial  PRIMARY KEY,
  fromspecies integer NOT NULL REFERENCES knownspecies (ksid),
  tospecies   integer NOT NULL REFERENCES knownspecies (ksid),
  method      text,
  UNIQUE (fromspecies,tospecies,method),
  CHECK (fromspecies<>tospecies)
);
CREATE INDEX syntenicspecies_from_to_species_index ON syntenicspecies(fromspecies,tospecies);
CREATE TABLE synteny (
  sid         serial  PRIMARY KEY,
  ssid        integer NOT NULL REFERENCES syntenicspecies (ssid),
  from_target text    NOT NULL,
  from_start  integer NOT NULL,
  from_end    integer NOT NULL,
  to_target   text    NOT NULL,
  to_start    integer NOT NULL,
  to_end      integer NOT NULL,
  match_ratio real,
  cover_ratio real,
  CHECK (abs(from_end-from_start)=abs(from_end-from_start))
);
CREATE INDEX synteny_ssid_index ON synteny (ssid);
CREATE INDEX synteny_from_target_index ON synteny (from_target);
CREATE INDEX synteny_from_start_end_index ON synteny (from_start,from_end);
CREATE INDEX synteny_to_target_index ON synteny (to_target);
CREATE INDEX synteny_to_start_end_index ON synteny (to_start,to_end);
REVOKE ALL ON DATABASE ${DBNAME_PREFIX}synteny FROM $DB_USER;
GRANT SELECT ON knownspecies,syntenicspecies,synteny TO $DB_USER;

COMMIT;
EOF

close SYNTENY_SQL;

open SESSION_SQL, '>sql/CreateTable_session.sql' or die "Cannot create 'CreateTable_session.sql'";
print SESSION_SQL <<EOF;
BEGIN;

CREATE TABLE session (
  sid serial PRIMARY KEY,
  session bytea NOT NULL
);
REVOKE ALL ON DATABASE ${DBNAME_PREFIX}session FROM $DB_USER;
GRANT SELECT,INSERT ON session TO $DB_USER;
GRANT SELECT,UPDATE ON session_sid_seq TO $DB_USER;

COMMIT;
EOF

open TRACKINFORMATION_SQL, '>sql/CreateTable_trackinformation.sql' or die "Cannot create 'CreateTable_trackinformation.sql'";
print TRACKINFORMATION_SQL <<EOF;
BEGIN;

CREATE TABLE users (
  uid serial PRIMARY KEY,
  name varchar(32) NOT NULL,
  password varchar(32) NOT NULL,
  e_mail varchar,
  authority varchar(8),
  UNIQUE (name)
);
CREATE INDEX users_name_index ON users (name);

CREATE TABLE track (
  tid serial PRIMARY KEY,
  name varchar NOT NULL, -- ex. mappedGene
  species varchar NOT NULL,
  revision varchar NOT NULL,
  uid integer REFERENCES users (uid),
  kind varchar(8) NOT NULL, -- ex. system/gene/graph/color/gene2/graph2/color2
  exhibit varchar(8) NOT NULL, -- ex. public / private
  data_location varchar NOT NULL,
  description_url varchar,
  comment varchar,
  species_url varchar,
  optattr_str varchar,
  optparam varchar,
  color_r integer,
  color_g integer,
  color_b integer,
  UNIQUE (name, species,revision, uid)
);
CREATE INDEX track_species_index ON track (species);
CREATE INDEX track_revision_index ON track (revision);
CREATE INDEX track_name_index ON track (name);

CREATE TABLE history (
  hid serial PRIMARY KEY,
  tid integer NOT NULL REFERENCES track (tid),
  uid integer REFERENCES users (uid),
  time timestamp NOT NULL,
  operation varchar(8),
  comment varchar
);
CREATE INDEX history_tid_index ON history (tid);
CREATE INDEX history_uid_index ON history (uid);

CREATE TABLE trackorder (
  toid serial PRIMARY KEY,
  species varchar NOT NULL,
  revision varchar NOT NULL,
  uid integer REFERENCES users (uid),
  order_str varchar NOT NULL,
  remove_str varchar,
  UNIQUE (species,revision,uid)
);

CREATE TABLE disparam (
        did integer,
        species varchar,
        revision varchar,
        target varchar,
        start_position integer,
        end_position integer,
        width integer
);
REVOKE ALL ON DATABASE  ${DBNAME_PREFIX}trackinformation FROM $DB_USER;
GRANT SELECT,INSERT,DELETE,UPDATE ON users,track,history,trackorder,disparam TO $DB_USER;
GRANT SELECT,UPDATE ON users_uid_seq,track_tid_seq,history_hid_seq,trackorder_toid_seq TO $DB_USER;
COMMIT;
EOF

close TRACKINFORMATION_SQL;

###################
# CREATE DATABASE
###################

$msg = system("createuser -h ${DB_HOST} -U postgres $DB_USER");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

# acceptspecies
$msg = system("createdb -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}acceptspecies");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

$msg = system("psql -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}acceptspecies < ./sql/CreateTable_acceptspecies.sql");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

# keywordsearch
$msg = system("createdb -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}keywordsearch");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}
$msg = system("psql -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}keywordsearch < ./sql/CreateTable_keywordsearch.sql");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}
# session
$msg = system("createdb -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}session");

if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}
$msg = system("psql -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}session < ./sql/CreateTable_session.sql");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

# synteny
$msg = system("createdb -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}synteny");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

$msg = system("psql -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}synteny < ./sql/CreateTable_synteny.sql");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

# targetsequence
$msg = system("createdb -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}targetsequence");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

$msg = system("psql -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}targetsequence < ./sql/CreateTable_targetsequence.sql");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

# trackinformation
$msg = system("createdb -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}trackinformation");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

$msg = system("psql -h ${DB_HOST} -U postgres ${DBNAME_PREFIX}trackinformation < ./sql/CreateTable_trackinformation.sql");
if ($msg != 0 ) {
	print $msg."\n";
	print LOG $msg."\n";
}

$msg = "====FINISH INSTALL====\n";
print $msg."\n";
print LOG $msg."\n";

__END__
