<?php

  // ƤӽФ:
  //   rulertrack_graphic.php?species=medaka&revision=test&target=scaffold1&start=0&end=8000&width=800

  // [rulertrack_graphic.php]
  //   : The intelligent scalable rurer track.

  function get_request($request) {
    $req = array();
    $req['species']  = $request['species'];
    $req['revision'] = $request['revision'];
    $req['target']   = $request['target'];
    $req['start']    = $request['start'];
    $req['end']      = $request['end'];
    $req['width']    = $request['width'];
    return $req;
  }

  $req = get_request($_REQUEST);
  $widthbp = abs( $req['end'] - $req['start'] ) + 1;
  $scale = $req['width'] / $widthbp;

  // ᡼
  $fontsize = 10;
  $fontfile = '../../fonts/Abadi MT Condensed Light.ttf';
  $height = 10;
  $image = imagecreatetruecolor( $req['width'], $height );
  $bkColor = imagecolorallocate( $image, 0xFF, 0xFF, 0xFF );
  $charColor = imagecolorallocate( $image, 0xFF, 0x00, 0x00 );
  $lineColor = imagecolorallocate( $image, 0x00, 0x00, 0x00 );
  imagefilledrectangle( $image, 0, 0, $req['width']-1, $height-1, $bkColor );

  // ưĴ
  $gradPerDotMax = 150;
  $gradPerDotMin = 50;
  $bpPerGrad = 1.0;
  $gradPerDot = $scale;
  while(TRUE) {
    if( $bpPerGrad <= 1.0 && $gradPerDotMin <= $gradPerDot ) { break; }
    if( $gradPerDotMin <= $gradPerDot && $gradPerDot <= $gradPerDotMax ) { break; }
    $bpPerGrad  *= ( $gradPerDot < $gradPerDotMin ) ? 2.0 : 0.5;
    $gradPerDot *= ( $gradPerDot < $gradPerDotMin ) ? 2.0 : 0.5;
    if( $gradPerDotMin <= $gradPerDot && $gradPerDot <= $gradPerDotMax ) { break; }
    $bpPerGrad  *= ( $gradPerDot < $gradPerDotMin ) ? 2.5 : 0.4;
    $gradPerDot *= ( $gradPerDot < $gradPerDotMin ) ? 2.5 : 0.4;
    if( $gradPerDotMin <= $gradPerDot && $gradPerDot <= $gradPerDotMax ) { break; }
    $bpPerGrad  *= ( $gradPerDot < $gradPerDotMin ) ? 2.0 : 0.5;
    $gradPerDot *= ( $gradPerDot < $gradPerDotMin ) ? 2.0 : 0.5;
  }

  if( $req['start'] <= $req['end'] ) {
    $startbasepos = $req['start'] - $req['start'] % $bpPerGrad;
    for( $i=$startbasepos ; $i<$req['end']+$bpPerGrad ; $i+=$bpPerGrad ) {
      $disppos = ( $i - $req['start'] ) * $scale;
      imageline( $image, $disppos, 0, $disppos, $height, $lineColor );
      if( $widthbp >= 1000000 )  { $numstr = ($i/1000000) . 'M'; }
      elseif( $widthbp >= 1000 ) { $numstr = ($i/1000) . 'k'; }
      else                       { $numstr = $i; }
      $strbox = imagettfbbox( $fontsize, 0, $fontfile, $numstr );
      imagettftext( $image, $fontsize, 0, $disppos+3, ($height+$strbox[3]-$strbox[5])/2, $charColor, $fontfile, $numstr );
    }
  }
  else {
    $startbasepos = $req['start'] - $req['start'] % $bpPerGrad;
    for( $i=$startbasepos ; $i>$req['end']-$bpPerGrad ; $i-=$bpPerGrad ) {
      $disppos = abs( $i - $req['start'] ) * $scale;
      imageline( $image, $disppos, 0, $disppos, $height, $lineColor );
      if( $widthbp >= 1000000 )  { $numstr = ($i/1000000) . 'M'; }
      elseif( $widthbp >= 1000 ) { $numstr = ($i/1000) . 'k'; }
      else                       { $numstr = $i; }
      $strbox = imagettfbbox( $fontsize, 0, $fontfile, $numstr );
      imagettftext( $image, $fontsize, 0, $disppos+3, ($height+$strbox[3]-$strbox[5])/2, $charColor, $fontfile, $numstr );
    }
  }

  // ᡼ν
  header( 'Content-type: image/png' );
  imagepng( $image );

  imagedestroy( $image );
?>
