<?php
require_once '../../browser_config.php';

///////////////////////////////////////////////////////////////////////////////
// [db_connect]
///////////////////////////////////////////////////////////////////////////////
function db_connect() {
  global $acceptspecies_connection_string;
  return pg_pconnect( $acceptspecies_connection_string );
}

///////////////////////////////////////////////////////////////////////////////
// [get_targetlen]
///////////////////////////////////////////////////////////////////////////////
function get_targetlen( $species, $revision, $target ) {
  $dbconn = db_connect();
  $res = pg_query( $dbconn, "SELECT length FROM targetlen WHERE ksid=(SELECT ksid FROM knownspecies
                               WHERE species='$species' and revision='$revision') and target='$target';" );
  $col = pg_fetch_assoc( $res );
  if( $col ) { return $col['length']; }
  else { return NULL; }
}

  $start = $_GET['start'];
  $end   = $_GET['end'];
  $width = $_GET['width'];
  $pos   = $_GET['pos'];

  $species   = $_GET['species'];
  $revision   = $_GET['revision'];
  $target   = $_GET['target'];

  $length = get_targetlen($species, $revision, $target);

  assert( is_numeric($start) );
  assert( is_numeric($end) );
  assert( is_numeric($width) );
  assert( preg_match( '/^\d+,\d+$/', $pos ) );

  preg_match( '/^(\d+),(\d+)$/', $pos, $match );

  $pos_x  = $match[1];
#  $target = round( $start + ( $end - $start ) * $pos_x / $width );

  if ($start <= $end){
    $target = round( $length * $pos_x / $width );
  } else {
    $target = round( $length - $length * $pos_x / $width );
  }

  header( 'Content-type: text/xml' );
  print '<?xml version="1.0" ?>';
?>
<suboperation_layer>
  <frame_operation>
    <command name="moveabs" value="<?php print $target; ?>" />
  </frame_operation>
</suboperation_layer>
