<?php
require_once '../../browser_config.php';

///////////////////////////////////////////////////////////////////////////////
// [db_connect]
///////////////////////////////////////////////////////////////////////////////
function db_connect() {
  global $acceptspecies_connection_string;
  return pg_pconnect( $acceptspecies_connection_string );
}

///////////////////////////////////////////////////////////////////////////////
// [get_targetlen]
///////////////////////////////////////////////////////////////////////////////
function get_targetlen( $species, $revision, $target ) {
  $dbconn = db_connect();
  $res = pg_query( $dbconn, "SELECT length FROM targetlen WHERE ksid=(SELECT ksid FROM knownspecies
                               WHERE species='$species' and revision='$revision') and target='$target';" );
  $col = pg_fetch_assoc( $res );
  if( $col ) { return $col['length']; }
  else { return NULL; }
}

  function get_request($request) {
    $req = array();
    $req['species']  = $request['species'];
    $req['revision'] = $request['revision'];
    $req['target']   = $request['target'];
    $req['start']    = $request['start'];
    $req['end']      = $request['end'];
    $req['width']    = $request['width'];
    return $req;
  }

  $req = get_request($_REQUEST);
  $length = get_targetlen($req['species'], $req['revision'], $req['target']);

  $scale = $req['width'] / $length;

  // ᡼
  $fontsize = 10;
  $fontfile = '../../fonts/Abadi MT Condensed Light.ttf';
  $height = 16;
  $h1 = 10;
  $h2 = 3;
  $image = imagecreatetruecolor( $req['width'], $height );
  $bkColor = imagecolorallocate( $image, 0xFF, 0xFF, 0xFF );
  $bkColor2 = imagecolorallocate( $image, 0xFF, 0xFF, 0xD9 );
  $bkColor3 = imagecolorallocate( $image, 0xF0, 0xE4, 0x42 );  // 
  $charColor = imagecolorallocate( $image, 0xD5, 0x5E, 0x00 ); // 
  $lineColor = imagecolorallocate( $image, 0x00, 0x00, 0x00 );
  $rangeColor2 = imagecolorallocate( $image, 0x00, 0x72, 0xB2 ); // 
  $rangeColor = imagecolorallocate( $image, 0x56, 0xB4, 0xD9 ); // 忧
  $rangeColor_rev = imagecolorallocate( $image, 0x00, 0xAF, 0x00 );

  imagefilledrectangle( $image, 0, 0, $req['width']-1, $height-1, $bkColor );
  imagefilledrectangle( $image, 0, $h2 , $req['width']-1, $height- 1 -$h2, $bkColor2 );

  if( $req['start'] <= $req['end'] ) {
    imagefilledrectangle($image, ($req['start'] - 1) * $scale, 0, ($req['end']) * $scale, $height, $rangeColor);
  }else {
    imagefilledrectangle($image, (($length) - $req['start']) * $scale, 0, (($length ) - $req['end'] + 1) * $scale, $height, $rangeColor);
  }

  imageline( $image, 0, $h2 -1 , $req['width']-1, $h2 - 1, $lineColor );
  imageline( $image, 0, $height - $h2, $req['width']-1, $height - $h2, $lineColor );


  // ưĴ
  $gradPerDotMax = 150;
  $gradPerDotMin = 50;
  $bpPerGrad =1.0;
  $gradPerDot = $scale;
  while(TRUE) {
    if( $gradPerDotMin <= $gradPerDot && $gradPerDot <= $gradPerDotMax ) { break; }
    $bpPerGrad  *= ( $gradPerDot < $gradPerDotMin ) ? 2.0 : 0.5;
    $gradPerDot *= ( $gradPerDot < $gradPerDotMin ) ? 2.0 : 0.5;
    if( $gradPerDotMin <= $gradPerDot && $gradPerDot <= $gradPerDotMax ) { break; }
    $bpPerGrad  *= ( $gradPerDot < $gradPerDotMin ) ? 2.5 : 0.4;
    $gradPerDot *= ( $gradPerDot < $gradPerDotMin ) ? 2.5 : 0.4;
    if( $gradPerDotMin <= $gradPerDot && $gradPerDot <= $gradPerDotMax ) { break; }
    $bpPerGrad  *= ( $gradPerDot < $gradPerDotMin ) ? 2.0 : 0.5;
    $gradPerDot *= ( $gradPerDot < $gradPerDotMin ) ? 2.0 : 0.5;
  }

  if( $req['start'] <= $req['end'] ) {
    $startbasepos = 0; # % $bpPerGrad;
    for( $i=$startbasepos ; $i<=$length+$bpPerGrad ; $i+=$bpPerGrad ) {
      $disppos =  $i * $scale;
      imageline( $image, $disppos, $h2, $disppos, $height - 1 - $h2, $lineColor );
      if( $i >= 1000000 )  { $numstr = ($i/1000000) . 'M'; }
      elseif( $i >= 1000 ) { $numstr = ($i/1000) . 'k'; }
      else                 { $numstr = $i; }
      $strbox = imagettfbbox( $fontsize, 0, $fontfile, $numstr );
      if ($i != 0) {
	imagettftext( $image, $fontsize, 0, $disppos+3, ($height+$strbox[3]-$strbox[5])/2, $charColor, $fontfile, $numstr );
      }
    }
  }
  else {
    $startbasepos = ($length) - ($length) % $bpPerGrad;
    for( $i=$startbasepos ; $i>1-$bpPerGrad ; $i-=$bpPerGrad ) {
     $disppos = abs( $i - ($length) ) * $scale;
      imageline( $image, $disppos, $h2, $disppos, $height - 1 - $h2 , $lineColor );
      if( $i >= 1000000 )  { $numstr = ($i/1000000) . 'M'; }
      elseif( $i >= 1000 ) { $numstr = ($i/1000) . 'k'; }
      else                 { $numstr = $i; }
      $strbox = imagettfbbox( $fontsize, 0, $fontfile, $numstr );
      imagettftext( $image, $fontsize, 0, $disppos+3, ($height+$strbox[3]-$strbox[5])/2, $charColor, $fontfile, $numstr );
    }
  }

  // ᡼ν
  header( 'Content-type: image/png' );
  imagepng( $image );

  imagedestroy( $image );
  fclose( $file );
?>
