<?php

  // ƤӽФ:
  //   basecolortrack_graphic.php?species=medaka&revision=test&target=scaffold1&start=0&end=8000&width=800

  require_once '../../browser_config.php';

  $req = $_GET;

  $species  = pg_escape_string( $req['species'] );
  $revision = pg_escape_string( $req['revision'] );
  $target   = pg_escape_string( $req['target'] );
  $start    = $req['start'];
  $end      = $req['end'];
  $width    = $req['width'];

  assert( isset($species) );
  assert( isset($revision) );
  assert( isset($target) );
  assert( is_numeric($start) );
  assert( is_numeric($end) );
  assert( is_numeric($width) );

  $sequence = get_targetseq( $species, $revision, $target );
  assert( $sequence );
  assert( preg_match( '/^[ATGCN]*$/', $seq ) );

  $inv_tbl = array( 'A' => 'T', 'T' => 'A', 'G' => 'C', 'C' => 'G', 'N' => 'N' );

  // ᡼
  $height = 10;
  $scale = $width / ( abs($end-$start) + 1 );
  $image = imagecreatetruecolor( $width, $height );
  $baseColor = array();
  $baseColor['A'] = is_null($req['color-base+color-A']) ? imagecolorallocate( $image, 0x66, 0xCC, 0x00 ) : colorstr2color($image,$req['color-base+color-A']);
  $baseColor['T'] = is_null($req['color-base+color-T']) ? imagecolorallocate( $image, 0xFF, 0x00, 0x00 ) : colorstr2color($image,$req['color-base+color-T']);
  $baseColor['G'] = is_null($req['color-base+color-G']) ? imagecolorallocate( $image, 0x00, 0x99, 0xFF ) : colorstr2color($image,$req['color-base+color-G']);
  $baseColor['C'] = is_null($req['color-base+color-C']) ? imagecolorallocate( $image, 0xFF, 0xFF, 0x99 ) : colorstr2color($image,$req['color-base+color-C']);

  // ᡼κ
  for( $i=0 ; $i<$width ; $i++ ) {
    if( $start <= $end ) {
      $pos = ($start-1) + $i / $scale;
      $char = substr( $sequence, $pos, 1 );
    }
    else {
      $pos = ($start-1) - $i / $scale + 1;
      $char = $inv_tbl[ substr( $sequence, $pos, 1 ) ];
    }
    imageline( $image, $i, 0, $i, $height, $baseColor[$char] );
  }

  // ǽʤʸ
  $basewidth = $width / (abs($start-$end)+1);
  if( $basewidth > 5 ) {
    $charColor = imagecolorallocate( $image, 0xFF, 0xFF, 0xFF );
    $fontfile = '../../fonts/Abadi MT Condensed Light.ttf';
    $basedisppos = $basewidth / 2;
    while( $basedisppos < $width ) {
      if( $start <= $end ) {
        $pos = ($start-1) + $basedisppos / $scale;
        $char = substr( $sequence, $pos, 1 );
      }
      else {
        $pos = ($start-1) - $basedisppos / $scale + 1;
        $char = $inv_tbl[ substr( $sequence, $pos, 1 ) ];
      }
      $charsize = min( $basewidth, $height );
      $strbox = imagettfbbox( $charsize, 0, $fontfile, $char );
      imagettftext( $image, $charsize, 0, $basedisppos-($strbox[2]-$strbox[0])/2+1, $height/2+($strbox[3]-$strbox[5])/2, $charColor, $fontfile, $char );
      $basedisppos += $basewidth;
    }
  }

  // ᡼ν
  header( 'Content-type: image/png' );
  imagepng( $image );

  imagedestroy( $image );

  ///////////////////////////////////////////////////////////////////////////////
  // [colorstr2color]
  ///////////////////////////////////////////////////////////////////////////////
  function colorstr2color( $image, $colorstr ) {
    preg_match( '/^\((\d+)\,(\d+)\,(\d+)\)$/', $colorstr, $match );
    assert( count($match) == 4 );
    return imagecolorallocate( $image, $match[1], $match[2], $match[3] );
  }

  ///////////////////////////////////////////////////////////////////////////////
  // [get_targetseq]
  ///////////////////////////////////////////////////////////////////////////////
  function get_targetseq( $species, $revision, $target ) {
    global $targetsequence_connection_string;
    $dbconn = pg_pconnect( $targetsequence_connection_string );
    assert( $dbconn );
    $res = pg_query( $dbconn, "SELECT sequence FROM targetseq WHERE ksid=(SELECT ksid FROM knownspecies WHERE species='$species' and revision='$revision') and target='$target';" );
    $col = pg_fetch_assoc($res);
    $seq = $col['sequence'];
    $seq = preg_replace( '/[^ATGCN]/', '', $seq );
    assert( preg_match( '/^[ATGCN]*$/', $seq ) );
    return $seq;
  }
?>
