<?php

  require_once( '../browser_config.php' );

  ///////////////////////////////////////////////////////////////////////////////
  // [get_easytrack_from_cache_by_url]
  ///////////////////////////////////////////////////////////////////////////////
  function get_easytrack_from_cache_by_url( $url )
  {
    // url Υѥ᡼
    $parse_res = preg_split("/\?/", $url);
    $url_path = $parse_res[0];
    $parse_result = parse_easytrack_trackline_url($url_path);
    $track_type = $parse_result['Track_type'];
    $track_name = pg_escape_string($parse_result['Track_name']);
    $track_species = $parse_result['Track_species'];
    $track_revision = $parse_result['Track_revision'];
  
    if (is_registered_trackinformation($track_name, $track_species, $track_revision)) {
      // trackinformation DB ϿƤʤ顢åDB⤷ϥե뤬¸ߤ롣
      $req_pre = pre_get_request($_REQUEST);
      $req_species = $req_pre['species'];
      $req_revision = $req_pre['revision'];
      $req_target = $req_pre['target'];
      $req_start = $req_pre['start'];
      $req_end = $req_pre['end'];
      $req_width = $req_pre['width'];
      $req_style = $req_pre['style'];
    
      switch ($track_type) 
      {
      case 'gene':
        {
          $max = 30000;
          if ($req_style != 'full') {
            if (abs($req_end - $req_start + 1) >=  50000) {
              $max = 200;
            }
          }
          global $utgb_cache_search_gene_file;
          $filename = 'stdout';
          $f = "$utgb_cache_search_gene_file $track_name $track_species $track_revision $req_target $req_start $req_end $req_width $filename $max";
          $file = popen ($f, "r");
        }
        break;
      case 'graph':
        {
          global $utgb_cache_search_graph_file;
          global $utgb_cache_binary_dir;
          $pwd_dir = getcwd();
          chdir($utgb_cache_binary_dir);
          $blend = 'ave';
          $filename = 'stdout';
          $f = "$utgb_cache_search_graph_file $track_name $track_species $track_revision $req_target $req_start $req_end $req_width $blend $filename";
          $file = popen ($f, "r");
    			chdir($pwd_dir);
        }
        break;
      case 'color':
        {
          global $utgb_cache_search_color_file;
          global $utgb_cache_binary_dir;
          $pwd_dir = getcwd();
          chdir($utgb_cache_binary_dir);
          $blend = 'ave';
          $filename = 'stdout';
          $f = "$utgb_cache_search_color_file $track_name $track_species $track_revision $req_target $req_start $req_end $req_width $blend $filename";
          $file = popen ($f, "r");
    			chdir($pwd_dir);
        }
        break;
      default:
        break;
      }
    }
    else {
      // å¸ߤʤ
      $file = fopen ($url_path, "r");
    }
    return $file;
  }


  ///////////////////////////////////////////////////////////////////////////////
  // [get_easytrack_from_cache_by_tid]
  ///////////////////////////////////////////////////////////////////////////////
  function get_easytrack_from_cache_by_tid( $tid )
  {
    global $trackinformation_connection_string;
    $hDB_trackinformation = pg_connect($trackinformation_connection_string);
    assert($hDB_trackinformation);

    $sql = "SELECT * FROM TRACK WHERE TID=$tid";
    $res = pg_query( $hDB_trackinformation, $sql);

    $track_name = pg_escape_string(pg_fetch_result($res, 0, 'name'));
    $track_type = pg_fetch_result($res, 0, 'kind');
    $track_species= pg_fetch_result($res, 0, 'species');
    $track_revision = pg_fetch_result($res, 0, 'revision');

    if (is_registered_trackinformation($track_name, $track_species, $track_revision)) {

      $req_pre = pre_get_request($_REQUEST);
      $req_species = $req_pre['species'];
      $req_revision = $req_pre['revision'];
      $req_target = $req_pre['target'];
      $req_start = $req_pre['start'];
      $req_end = $req_pre['end'];
      $req_width = $req_pre['width'];
      $req_style = $req_pre['style'];
    
      switch ($track_type) 
      {
      case 'gene':
        {
          $max = 30000;
          if ($req_style != 'full') {
            if (abs($req_end - $req_start + 1) >=  50000) {
              $max = 200;
            }
          }
          global $utgb_cache_search_gene_file;
          global $utgb_cache_binary_dir;
          $pwd_dir = getcwd();
          chdir($utgb_cache_binary_dir);
          $filename = 'stdout';
          $f = "$utgb_cache_search_gene_file $track_name $track_species $track_revision $req_target $req_start $req_end $req_width $filename $max";
          $file = popen ($f, "r");
        }
        break;
      case 'graph':
        {
          global $utgb_cache_search_graph_file;
          global $utgb_cache_binary_dir;
          $pwd_dir = getcwd();
          chdir($utgb_cache_binary_dir);
          $blend = 'ave';
          $filename = 'stdout';
          $f = "$utgb_cache_search_graph_file $track_name $track_species $track_revision $req_target $req_start $req_end $req_width $blend $filename";
          $file = popen ($f, "r");
    			chdir($pwd_dir);
        }
        break;
      case 'color':
        {
          global $utgb_cache_search_color_file;
          $blend = 'ave';
          $filename = 'stdout';
          $f = "$utgb_cache_search_color_file $track_name $track_species $track_revision $req_target $req_start $req_end $req_width $blend $filename";
          $file = popen ($f, "r");
    			chdir($pwd_dir);
        }
        break;
      default:
        break;
      }
    }
    else {
      // å¸ߤʤ
      $file = fopen ($url_path, "r");
    }
    return $file;
  }

  
  ///////////////////////////////////////////////////////////////////////////////
  // [parse_easytrack_trackline_url]
  ///////////////////////////////////////////////////////////////////////////////
  function parse_easytrack_trackline_url($url)
  {
    $fp_track = fopen($url, "r");
    while (!feof($fp_track)) {
      $line = fgets($fp_track);
      // comment line
      if (preg_match("/^#/", $line, $matches) >= 1) {
        continue;
      }
      // parse track line
      $parse_result = parse_easytrack_trackline($line);
      break;
    }
    fclose($fp_track);
    return $parse_result;
  }

  ///////////////////////////////////////////////////////////////////////////////
  // [parse_easytrack_trackline]
  ///////////////////////////////////////////////////////////////////////////////
  function parse_easytrack_trackline($line)
  {
    $ret = array();
    // Track type
    $ret['Track_type'] = get_tracktype($line);
    // parse track line
    $ret['Track_name']             = parse_with_term($line, "name");
    $ret['Track_species']          = parse_with_term($line, "species");
    $ret['Track_revision']         = parse_with_term($line, "revision");
    /*
    $ret['Track_species_url']      = parse_with_term($line, "species_url");
    $ret['Track_description_url']  = parse_with_term($line, "description_url");
    $ret['Track_color']            = parse_with_term($line, "color");
    $ret['Track_date']             = parse_with_term($line, "date");
    $ret['Track_comment']          = parse_with_term($line, "comment");
    $ret['Track_optattr']          = parse_with_term($line, "optattr");
    $ret['Track_max']              = parse_with_term($line, "max"); // only Graph
    $ret['Track_min']              = parse_with_term($line, "min"); // only Graph
    $ret['Track_blend']            = parse_with_term($line, "blend"); // only Graph and Color
    */
    return $ret;
  }

  ///////////////////////////////////////////////////////////////////////////////
  // [get_tracktype]
  ///////////////////////////////////////////////////////////////////////////////
  function get_tracktype($line)
  {
    if (preg_match("/^geneTrack/i", $line, $matches) >= 1) {
      # EasyGeneTrack
      $track_type = "gene";
    } elseif (preg_match("/^graphTrack/i", $line, $matches) >= 1) {
      # EasyGraphTrack
      $track_type = "graph";
    } elseif (preg_match("/^colorTrack/i", $line, $matches) >= 1) {
      # EasyColorTrack
      $track_type = "color";
    } else {
      # Not EasyTrack
      $track_type = NULL;
    }
    return $track_type;
  }
  
  ///////////////////////////////////////////////////////////////////////////////
  // [parse_with_term]
  ///////////////////////////////////////////////////////////////////////////////
  function parse_with_term($line, $term)
  {
    $str ="";
    if ((preg_match("/[\s]$term=\"([^\"]+)\"/", $line, $matches)) ||
        (preg_match("/[\s]$term=([^\s]+)/", $line, $matches))) {
      $str = $matches[1];
      $str = trim($str);
      $str = str_replace("'", "\'", $str);
    }
    return $str;
  }

  ///////////////////////////////////////////////////////////////////////////////
  // [is_registered_trackinformation]
  ///////////////////////////////////////////////////////////////////////////////
  function is_registered_trackinformation($track_name, $species, $revision)
  {
    global $trackinformation_connection_string;
    $hDB_trackinformation = pg_connect($trackinformation_connection_string);
    assert($hDB_trackinformation);
    $track_name = pg_escape_string($track_name);
    $species = pg_escape_string($species);
    $revision = pg_escape_string($revision);
    $sql = "SELECT * FROM track WHERE name='$track_name' AND species='$species' AND revision='$revision';";
    $res_trackinformation = pg_query($hDB_trackinformation, $sql);
    if (pg_num_rows($res_trackinformation) >= 1) {
      return TRUE;
    } else {
      return FALSE;
    }
  }
  
?>