<?php
  function pre_get_request($request) {
    $req = array();
    $req['species']  = $request['species'];
    $req['revision'] = $request['revision'];
    $req['target']   = $request['target'];
    $req['start']    = $request['start'];
    $req['end']      = $request['end'];
    $req['width']    = $request['width'];

    $req['style'] = get_style_option($request);

    return $req;
  }

  function get_request($request,$opt, $defaultColor) {
    $req = array();
    $req['species']  = $request['species'];
    $req['revision'] = $request['revision'];
    $req['target']   = $request['target'];
    $req['start']    = $request['start'];
    $req['end']      = $request['end'];
    $req['width']    = $request['width'];
    $req['disp']     = array();
    $req['color']     = array();
    $req['select']    = array();
    $req['gradation']  = array();
    $req['ubound']     = array();
    $req['lbound']     = array();

    $count = 0;
    if (array_key_exists ('usecolor', $request) ){
      $req['usecolor']    = $request['usecolor'];
    } else {
      for ($i=0; $i<count($opt);$i++){
        if(preg_match("/color/",$opt[$i][3],$m)){
          $req['usecolor'] = $opt[$i][0] . '-color';
          $count++;
        }
        if(preg_match("/gradation/",$opt[$i][3],$m)){
          $req['usecolor'] = $opt[$i][0] . '-gradation';
          $count++;
        }
      }
      if ($count > 1){
        $req['usecolor'] = ''; 
      }
    }
    $req['style'] = get_style_option($request);

    for ($i=0; $i<count($opt);$i++){
      $attr = $opt[$i][0];
      $types = $opt[$i][2];
      if($opt[$i][1] == 'select'){
        get_disp_option($attr,$types,$opt[$i][3],$request,$req['disp']);
      
        get_color_option($attr,$types,$opt[$i][3],$request,$req['color'],$count);
      
        get_select_option($attr,$types,$opt[$i][3],$request,$req['select']);


      } else if($opt[$i][1] == 'real'){

        get_gradation_option($attr,$types,$opt[$i][3],$request,$req['gradation'], $defaultColor, $count);
      
        get_ubound_option($attr,$opt[$i][3],$request,$req['ubound']);
      
        get_lbound_option($attr,$opt[$i][3],$request,$req['lbound']);

      }
    }

    if (array_key_exists ('foundGene', $request) ){
      $req['foundGene']    = $request['foundGene'];
    } 

    return $req;
  }

function  draw_ruler($image, $req, $height) {
  $scale = $req['width'] / (abs( $req['end'] - $req['start']) + 1) ;
  $lineColor = imagecolorallocate( $image, 0xA0, 0xA0, 0xA0 );

  $gradPerDotMax = 150;
  $gradPerDotMin = 50;
  $bpPerGrad =1.0;
  $gradPerDot = $scale;
  while(TRUE) {
    if( $bpPerGrad <= 1.0 && $gradPerDotMin <= $gradPerDot ) { break; }
    if( $gradPerDotMin <= $gradPerDot && $gradPerDot <= $gradPerDotMax ) { break; }
    $bpPerGrad  *= ( $gradPerDot < $gradPerDotMin ) ? 2.0 : 0.5;
    $gradPerDot *= ( $gradPerDot < $gradPerDotMin ) ? 2.0 : 0.5;
    if( $gradPerDotMin <= $gradPerDot && $gradPerDot <= $gradPerDotMax ) { break; }
    $bpPerGrad  *= ( $gradPerDot < $gradPerDotMin ) ? 2.5 : 0.4;
    $gradPerDot *= ( $gradPerDot < $gradPerDotMin ) ? 2.5 : 0.4;
    if( $gradPerDotMin <= $gradPerDot && $gradPerDot <= $gradPerDotMax ) { break; }
    $bpPerGrad  *= ( $gradPerDot < $gradPerDotMin ) ? 2.0 : 0.5;
    $gradPerDot *= ( $gradPerDot < $gradPerDotMin ) ? 2.0 : 0.5;
  }

  if( $req['start'] <= $req['end'] ) {
    $startbasepos = $req['start'] - $req['start'] % $bpPerGrad;
    for( $i=$startbasepos ; $i<$req['end']+$bpPerGrad ; $i+=$bpPerGrad ) {
      $disppos = ( $i - $req['start'] ) * $scale;
      imageline( $image, $disppos, 0, $disppos, $height, $lineColor );
    }
  }
  else {
    $startbasepos = $req['start'] - $req['start'] % $bpPerGrad;
    for( $i=$startbasepos ; $i>$req['end']-$bpPerGrad ; $i-=$bpPerGrad ) {
      $disppos = abs( $i - $req['start'] ) * $scale;
      imageline( $image, $disppos, 0, $disppos, $height, $lineColor );
    }
  }

}



?>
