<?

function get_disp_option($attr,$types,$operation,$request,&$disp){
  if(preg_match("/disp/", $operation , $m)){
    while(preg_match("/^(.+?),(.+)$/",$types,$type)){
      $t = urlencode($type[1]);
      $fromFW = "disp-" . $attr ."-"  . $t;
      if(array_key_exists($fromFW, $request)){
        if($request[$fromFW] === 'off') {
          array_push ($disp, array($attr, $type[1]));
        }
      }
      $types = $type[2]; 
    }
    $t = urlencode($types);
    $fromFW = "disp-" . $attr ."-"  . $t;
    if(array_key_exists($fromFW, $request)){
      if($request[$fromFW] === 'off'){
        array_push ($disp, array($attr, $types));
      }
    }
  }
  return;
}

function get_color_option($attr,$types,$operation,$request,&$color,$count){
  if(preg_match("/color/",$operation,$m)){
    $usecolor =  $attr . "-color"  ;
    if ($usecolor == $request['usecolor'] || $count == 1){
       while(preg_match("/^(.+?),(.+)/",$types,$type)){
        $t = urlencode($type[1]);
        $fromFW = "color-" . $attr ."-"  . $t;
        if(preg_match("/\((\d+),(\d+),(\d+)\)/",$request[$fromFW],$col)){
          array_push ($color, array($attr, $type[1],$col[1],$col[2],$col[3]));
        }
        $types = $type[2]; 
      }
      $t = urlencode($types);
      $fromFW = "color-" . $attr ."-"  . $t;
      if(preg_match("/\((\d+),(\d+),(\d+)\)/",$request[$fromFW],$col)){
        array_push ($color, array($attr, $types,$col[1],$col[2],$col[3]));
      }
    }
  }
  return;
}

function get_select_option($attr,$types,$operation,$request, &$select){
  if(preg_match("/select/", $operation , $m)){
    $fromFW = 'select-' . $attr;
    if(array_key_exists($fromFW, $request)) {
      array_push ($select, array($attr, $request[$fromFW]));
    }
  }
  return;
}

function get_gradation_option($attr, $types, $operation, $request, &$gradation, $defColor, $count ) {
  if(preg_match("/gradation/",$operation,$m)){
    $usecolor = $attr . "-gradation";
     if ($usecolor == $request['usecolor'] || $count == 1){
      $fromFW_min = "gradation-" . $attr ."-min";
      $fromFW_max = "gradation-" . $attr ."-max";
      if(preg_match("/^(\S+),(\S+)/",$types,$type)){
        array_push ($gradation, $attr, $type[1], $defColor[0], $defColor[1], $defColor[2], $type[2], $defColor[0], $defColor[1], $defColor[2]);
        if (preg_match ("/\((\d+),(\d+),(\d+)\)/",$request[$fromFW_min],$col)){
          $gradation[2] = $col[1];
          $gradation[3] = $col[2];
          $gradation[4] = $col[3];
        }
        if (preg_match ("/\((\d+),(\d+),(\d+)\)/",$request[$fromFW_max],$col2)){
          $gradation[6] = $col2[1];
          $gradation[7] = $col2[2];
          $gradation[8] = $col2[3];
        }
      }
    }
  }
  return;
}

function get_ubound_option($attr, $operation, $request, &$ubound) {
  if(preg_match("/ubound/", $operation, $m)){
    $fromFW = 'ubound-' . $attr;
    if(array_key_exists($fromFW, $request)) {
      if (preg_match ("/^\d/",$request[$fromFW],$num)){
        array_push($ubound, array($attr, $request[$fromFW]));
      }
    }
  }
  return;
}

function get_lbound_option($attr, $operation, $request, &$lbound) {
  if(preg_match("/lbound/",$operation,$m)){
    $fromFW = 'lbound-' . $attr;
    if(array_key_exists($fromFW, $request)) {
      if (preg_match ("/^\d/",$request[$fromFW],$num)){
        array_push($lbound, array($attr, $request[$fromFW]));
      }
    }
  }
  return;
}


function get_disp_attr ($line, $disp){
  for ($i=0; $i<count($disp);$i++){
    $attr = $disp[$i][0];
    if(preg_match("/\b$attr=(\w+)\b/",  $line, $optline)){
      if ($optline[1] == $disp[$i][1]){
        return 0;
      }
    }
    if(preg_match("/$attr=\"(.+?)\"/",  $line, $optline)){
      if ($optline[1] == $disp[$i][1]){
        return 0;
      }
    }
  }
  return 1;
}    

function get_ubound_attr ($line, $ubound){
  for ($i=0; $i<count($ubound);$i++){
    $attr = $ubound[$i][0];
    $bound = $ubound[$i][1];
    if(preg_match("/\b$attr=(\S+)\b/",  $line, $optline)){
      if ($optline[1] > $bound){
        return 0;
      }
    }
  }
  return 1;
}

function get_lbound_attr ($line, $lbound){
  for ($i=0; $i<count($lbound);$i++){
    $attr = $lbound[$i][0];
    $bound = $lbound[$i][1];
    if(preg_match("/\b$attr=(\S+)\b/",  $line, $optline)){
      if ($optline[1] < $bound){
        return 0;
      }
    }
  }
  return 1;
}

// $lineʺǽιԡˤdefaultcolor
  function get_defaultcolor($line){
    $colorR = 0;
    $colorG = 0;
    $colorB = 0;
    if(preg_match("/\bcolor=(\d+),(\d+),(\d+)\b/",$line, $dcolor)){
      $colorR = $dcolor[1];
      $colorG = $dcolor[2];
      $colorB = $dcolor[3];
    }
    return array($colorR,$colorG,$colorB);
  }

function get_optional_attribute($first_line){
  if (preg_match("/\boptattr=\"(.+?)\"/",$first_line,$matches)){ #\"\"\b
      $optionalattrs = $matches[1];
      $optattrs = array();
      $i =0;
      while(preg_match("/(\w+)\/(\w+)\[(.+?)\]\((.+?)\)(.*)$/",$optionalattrs, $optionalattr)){ # \[\]\((\S+)\)[,\s] 
        $i++;
        array_push ($optattrs, array($optionalattr[1], $optionalattr[2], $optionalattr[3], $optionalattr[4]));
        if(preg_match("/^,(.+?)$/", $optionalattr[5], $remain)){
          $optionalattrs = $remain[1];
        }else {
          break;
        }
      }
  }
  return $optattrs;
}

  function get_genecolor_by_color($colordefault, $line, $attr, $coloroption){

    $color = $colordefault; 
    if(preg_match("/\b$attr=(\w+)\b/",  $line, $optline)){
      for($i=0;$i<count($coloroption);$i++){
        if($coloroption[$i][1] == $optline[1])
          $color = array($coloroption[$i][2], $coloroption[$i][3], $coloroption[$i][4] );
      }
    }
    if(preg_match("/$attr=\"(.+?)\"/",  $line, $optline)){
      for($i=0;$i<count($coloroption);$i++){
        if($coloroption[$i][1] == $optline[1])
          $color = array($coloroption[$i][2], $coloroption[$i][3], $coloroption[$i][4] );
      }
    }
    return $color;
  }    


  function get_genecolor_by_gradation($colordefault, $line, $attr, $coloroption){
    $color = $colordefault; 

     if(preg_match("/\b$attr=(\S+)\b/",  $line, $optline)){
        $ratio = ($optline[1] - $coloroption[1]) / ($coloroption[5] - $coloroption[1]);
        $colorR = $coloroption[2] + ($coloroption[6] - $coloroption[2]) * $ratio;
        $colorG = $coloroption[3] + ($coloroption[7] - $coloroption[3]) * $ratio;
        $colorB = $coloroption[4] + ($coloroption[8] - $coloroption[4]) * $ratio;
        $color = array($colorR , $colorG, $colorB); 

      }
    return $color;
  }


  
function get_display_genes($file,$req){
  if($req['start'] < $req['end']){
    $start = $req['start'];
    $end = $req['end'];
  }else {
    $start = $req['end'];
    $end = $req['start'];
  }

  $genes = array();

  while (!feof ($file)) {
    $line = trim(fgets($file));
    if(strncmp($line, "gene", 4) != 0) continue;

    $target_line = substr(( strchr ($line, 'target=') ), 7);
    list($target, $remain) = split("[ \t]", $target_line);
    if(strcmp($target, $req['target']) != 0) continue;

    $range_line = substr(strchr ($line, 'range='), 6);
    list($range_start, $range_end, $remain) = split("[, \t]", $range_line);
    if($range_start > $range_end) {
      $tmp = $range_start;
      $range_start = $range_end;
      $range_end = $tmp;
    }
    if(($range_start > $end) || ($range_end < $start)) continue; 

# option򸡺 ######

# option disp

    $disp = get_disp_attr($line, $req['disp']);
    if($disp == 0) continue;

# option real ubound

    $ubound = get_ubound_attr($line, $req['ubound']);
    if($ubound == 0) continue;

# option real lbound

    $lbound = get_lbound_attr($line, $req['lbound']);
    if($lbound == 0) continue;

    $genes[] = $line;
  }
  usort ($genes, "cmp_genes");
  return $genes;
}

function cmp_genes($a, $b){
    $range_line = substr(strchr ($a, 'range='), 6);
    list($start_a, $end_a, $remain) = split("[, \t]", $range_line);
    if($start_a > $end_a) {
      $start_a = $end_a;
    }

    $range_line = substr(strchr ($b, 'range='), 6);
    list($start_b, $end_b, $remain) = split("[, \t]", $range_line);
    if($start_b > $end_b) {
      $start_b = $end_b;
    }

    if ($start_a == $start_b) return 0;
    return ($start_a < $start_b) ? -1 : 1;
}

function cmp_genes_rev($a, $b){
    $range_line = substr(strchr ($a, 'range='), 6);
    list($start_a, $end_a, $remain) = split("[, \t]", $range_line);
    if($start_a > $end_a) {
      $end_a = $start_a;
    }

    $range_line = substr(strchr ($b, 'range='), 6);
    list($start_b, $end_b, $remain) = split("[, \t]", $range_line);
    if($start_b > $end_b) {
      $end_b = $start_b;
    }

    if ($end_a == $end_b) return 0;
    return ($end_a < $end_b) ? 1 : -1;
}

function get_style($select){
  for ($i=0; $i<count($select);$i++){
    $attr = $select[$i][0];
    if($attr == 'select'){
      return $select[$i][1];
    }
  }
  return 'full';
}

function draw_gene_style_dense($genes,$req,$colorD, $height){
  $num_genes = sizeof($genes);
  $basewidth = abs ($req['end'] - $req['start'] ) + 1;

  $h = floor($height / 2);
  $hgene = floor($height / 2); # 20

  $image = imagecreatetruecolor( $req['width'], $height );

  $white = imagecolorallocate( $image, 0xFF, 0xFF, 0xFF );
  $black = imagecolorallocate( $image, 0x00, 0x00, 0x00 );  

  imagefilledrectangle($image, 0, 0, $req['width']-1,$height-1, $white);

  for($num=0; $num < $num_genes; $num++){
    $line = $genes[$num];
    $range_line = substr(strchr ($line, 'range='), 6);
    list($range_start, $range_end, $remain) = split("[, \t]", $range_line);
    if($range_start > $range_end) {
      $tmp = $range_start;
      $range_start = $range_end;
      $range_end = $tmp;
    }

// μ
    $colorRGB = $colorD;
   if(preg_match("/^(\w+)\-color$/",$req['usecolor'],$at)){
     $colorRGB = get_genecolor_by_color($colorD, $line, $at[1], $req['color']);
   }else if(preg_match("/^(\w+)\-gradation$/",$req['usecolor'],$at)){
     $colorRGB = get_genecolor_by_gradation($colorD, $line, $at[1], $req['gradation']);
   }

   $color = imagecolorallocate( $image, $colorRGB[0], $colorRGB[1], $colorRGB[2] );

    if($req['end'] >= $req['start']){
      $startpos = $req['width'] * ($range_start - $req['start'] ) / $basewidth;
      $endpos = $req['width'] * ($range_end - $req['start'] + 1) / $basewidth;
    } else {
      $startpos = $req['width'] * ($req['start'] - $range_end) / $basewidth;
      $endpos = $req['width'] * ($req['start'] - $range_start + 1) / $basewidth;
    }
    if($startpos < 0) $startpos = 0;
    if($endpos > $req['width']) $endpos = $req['width']-1;


    imageline($image, $startpos, $h, $endpos, $h, $color);

#    $strand = substr(strchr ($line, 'strand='), 7, 1);
#    if ( $strand == '+' xor $req['start'] >= $req['end']) {
#      for($i = $startpos; $i < $endpos-10; $i+=10){
# imageline($image, $i, $h-$hgene, $i+$hgene, $h, $color);
# imageline($image, $i, $h+$hgene, $i+$hgene, $h, $color);
#      }
#    }else if ( $strand == '-' xor $req['start'] >= $req['end']) {
#      for($i = $startpos; $i < $endpos -10; $i+=10){
# imageline($image, $i, $h, $i+$hgene, $h-$hgene, $color);
# imageline($image, $i, $h, $i+$hgene, $h+$hgene, $color);
#      }
#    }

    $exon_line = $line;
    for(;;){
      if(($exon = strchr ($exon_line, 'exon=')) == FALSE) break;
      $exon_line = substr($exon, 5);
      list($exon_start, $exon_end, $remain) = split("[, \t]", $exon_line);
      if($exon_start > $exon_end) {
        $tmp = $exon_start;
        $exon_start = $exon_end;
        $exon_end = $tmp;
      }


      if($req['end'] >= $req['start']){
        if ($exon_end < $req['start']) continue;
        if ($exon_start > $req['end']) continue;
        $startpos = $req['width'] * ($exon_start - $req['start'] ) / $basewidth;
        $endpos = $req['width'] * ($exon_end - $req['start'] + 1) / $basewidth;
      }else {
        if ($exon_end < $req['end']) continue;
        if ($exon_start > $req['start']) continue;
        $endpos = $req['width'] * ($req['start'] - $exon_start + 1) / $basewidth;
        $startpos = $req['width'] * ($req['start'] - $exon_end) / $basewidth;
      }

      if (($endpos < 0) || ($startpos >$req['width'] ))  continue;

      if($startpos < 0) $startpos = 0;
      if($endpos > $req['width']) $endpos = $req['width']-1;

      imagefilledrectangle($image, $startpos, $h-$hgene, $endpos, $h+$hgene, $color);

    }

  }

  header( 'Content-type: image/png' );
  imagepng( $image );

  imagedestroy( $image );

}


function draw_gene_style_full($genes, $req, $colorD, $h1, $hgene){

  $num_genes = sizeof($genes);
  $basewidth = abs ($req['end'] - $req['start'] ) + 1;

  $h2 = 0;

  $height = $num_genes * $h1 + $h2;
  if ($num_genes == 0) $height = 5;
  $image = imagecreatetruecolor( $req['width'], $height );
  $white = imagecolorallocate( $image, 0xFF, 0xFF, 0xFF );
  $black = imagecolorallocate( $image, 0x00, 0x00, 0x00 );  

// imagefill( $image, 0, 0, $white);
  imagefilledrectangle($image, 0, 0, $req['width']-1,$height-1, $white);

  draw_ruler($image, $req, $height);

  for($num=0; $num < $num_genes; $num++){
    $line = $genes[$num];
    $range_line = substr(strchr ($line, 'range='), 6);
    list($range_start, $range_end, $remain) = split("[, \t]", $range_line);
    if($range_start > $range_end) {
      $tmp = $range_start;
      $range_start = $range_end;
      $range_end = $tmp;
    }

// μ
    $colorRGB = $colorD;
   if(preg_match("/^(\w+)\-color$/",$req['usecolor'],$at)){
     $colorRGB = get_genecolor_by_color($colorD, $line, $at[1], $req['color']);
   }else if(preg_match("/^(\w+)\-gradation$/",$req['usecolor'],$at)){
     $colorRGB = get_genecolor_by_gradation($colorD, $line, $at[1], $req['gradation']);
   }

   if (array_key_exists ('foundGene', $req) ){
     if(($name_pos = strpos($line, 'name=')) !== FALSE) {
       $name_line = substr($line, $name_pos + 5);
       list($name, $remain) = split("[ \t]", $name_line);
       if ($name == $req['foundGene']){
         $colorRGB = array(230,159,0);
       }
     }
   } 



   $color = imagecolorallocate( $image, $colorRGB[0], $colorRGB[1], $colorRGB[2] );

    $h = $h1 / 2 +  $h2 + $h1 * $num;
    if($req['end'] >= $req['start']){
      $startpos = $req['width'] * ($range_start - $req['start']) / $basewidth;
      $endpos = $req['width'] * ($range_end - $req['start'] + 1) / $basewidth;
    } else {
      $startpos = $req['width'] * ($req['start'] - $range_end) / $basewidth;
      $endpos = $req['width'] * ($req['start'] - $range_start + 1) / $basewidth;
    }
    if ($startpos < 0)  $startpos = 0;
    if ($endpos >$req['width'] )  $endpos = $req['width'];

    imageline($image, $startpos, $h, $endpos, $h, $color);

    $strand = substr(strchr ($line, 'strand='), 7, 1);
    if ( $strand == '+' xor $req['start'] >= $req['end']) {
      for($i = $startpos; $i < $endpos-10; $i+=10){
        imageline($image, $i, $h-$hgene, $i+$hgene, $h, $color);
        imageline($image, $i, $h+$hgene, $i+$hgene, $h, $color);
      }
    }else if ( $strand == '-' xor $req['start'] >= $req['end']) {
      for($i = $startpos; $i < $endpos -10; $i+=10){
        imageline($image, $i, $h, $i+$hgene, $h-$hgene, $color);
        imageline($image, $i, $h, $i+$hgene, $h+$hgene, $color);
      }
    }


    $exon_line = $line;
    for(;;){
      if(($exon = strchr ($exon_line, 'exon=')) == FALSE) break;
      $exon_line = substr($exon, 5);
      list($exon_start, $exon_end, $remain) = split("[, \t]", $exon_line);
      if($exon_start > $exon_end) {
        $tmp = $exon_start;
        $exon_start = $exon_end;
        $exon_end = $tmp;
      }
      if($req['end'] >= $req['start']){
        $startpos = $req['width'] * ($exon_start - $req['start']) / $basewidth;
        $endpos = $req['width'] * ($exon_end - $req['start'] + 1) / $basewidth;
      }else {
        $endpos = $req['width'] * ($req['start'] - $exon_start + 1) / $basewidth;
        $startpos = $req['width'] * ($req['start'] - $exon_end ) / $basewidth;
      }


      if (($endpos < 0) || ($startpos >$req['width'] ))  continue;

      if ($startpos < 0)  $startpos = 0;
      if ($endpos >$req['width'] )  $endpos = $req['width'];

      imagefilledrectangle($image, $startpos, $h-$hgene, $endpos, $h+$hgene, $color);
    }

  }

  // ᡼ν
  header( 'Content-type: image/png' );
  imagepng( $image );

  imagedestroy( $image );
}

function get_pack_height ($genes, $req, &$gene_height, $h1, $distance){
  $num_genes = sizeof($genes);
  $basewidth = abs ($req['end'] - $req['start'] + 1);
  if ($num_genes == 0) return 5;
  $base_end = array();
  for($num=0; $num < $num_genes; $num++){
    $line = $genes[$num];
    $range_line = substr(strchr ($line, 'range='), 6);
    list($range_start, $range_end, $remain) = split("[, \t]", $range_line);
    if($range_start > $range_end) {
      $tmp = $range_start;
      $range_start = $range_end;
      $range_end = $tmp;
    }

    if($req['end'] >= $req['start']){
      $startpos = $req['width'] * ($range_start - $req['start']) / $basewidth;
      $endpos = $req['width'] * ($range_end - $req['start']) / $basewidth;
    } else {
      $startpos = $req['width'] * ($req['start'] - $range_end) / $basewidth;
      $endpos = $req['width'] * ($req['start'] - $range_start) / $basewidth;
    }
   
    $height = sizeof ($base_end);
    $flag = 0;

    for($i=0; $i < $height; $i++){
      if($base_end[$i] <= ($startpos - $distance)){
        $base_end[$i] = $endpos;
        array_push ($gene_height, $i);
        $flag = 1; 
        break;
      }
    }
    if ($flag == 0){
      array_push ($base_end, $endpos);
      array_push ($gene_height, $height);
    }
  }

  return sizeof ($base_end) * $h1;
}

function draw_gene_style_pack($genes, $req, $colorD, $h1, $hgene){
  global $utgb_font_Abadi_file;

  $num_genes = sizeof($genes);

  if ($req['start'] > $req['end']){
    usort ($genes, "cmp_genes_rev");
  } 
  $basewidth = abs ($req['end'] - $req['start']) + 1;

  $size = 8;
  $fontfile = $utgb_font_Abadi_file;


#  $h1 = 10;
#  $hgene = 3; # 20
#  $h2 = 5;
#  $h2 = 1;
  $h2 = 0;

  $gene_height = array();
  $height = get_pack_height ($genes, $req, $gene_height, $h1, 100);

  $image = imagecreatetruecolor( $req['width'], $height );
  $white = imagecolorallocate( $image, 0xFF, 0xFF, 0xFF );
  $black = imagecolorallocate( $image, 0x00, 0x00, 0x00 );  

// imagefill( $image, 0, 0, $white);
  imagefilledrectangle($image, 0, 0, $req['width']-1,$height-1, $white);
  // ᡼κ

#  for($i=50; $i < $req['width']; $i = $i +50){
#    imageline($image, $i, 0, $i, $height, $black);
#  }

  draw_ruler($image, $req, $height);

  for($num=0; $num < $num_genes; $num++){
    $line = $genes[$num];
    $range_line = substr(strchr ($line, 'range='), 6);
    list($range_start, $range_end, $remain) = split("[, \t]", $range_line);
    if($range_start > $range_end) {
      $tmp = $range_start;
      $range_start = $range_end;
      $range_end = $tmp;
    }

// μ
    $colorRGB = $colorD;
   if(preg_match("/^(\w+)\-color$/",$req['usecolor'],$at)){
     $colorRGB = get_genecolor_by_color($colorD, $line, $at[1], $req['color']);
   }else if(preg_match("/^(\w+)\-gradation$/",$req['usecolor'],$at)){
     $colorRGB = get_genecolor_by_gradation($colorD, $line, $at[1], $req['gradation']);
   }


   if (array_key_exists ('foundGene', $req) ){
     if(($name_pos = strpos($line, 'name=')) !== FALSE) {
       $name_line = substr($line, $name_pos + 5);
       list($name, $remain) = split("[ \t]", $name_line);
       if ($name == $req['foundGene']){
         $colorRGB = array(230,159,0);
       }  
     }
   } 

   $color = imagecolorallocate( $image, $colorRGB[0], $colorRGB[1], $colorRGB[2] );

    $h = $h1 / 2 +  $h2 + $h1 * $gene_height[$num];
    if($req['end'] >= $req['start']){
      $startpos = $req['width'] * ($range_start - $req['start']) / $basewidth;
      $endpos = $req['width'] * ($range_end - $req['start'] + 1) / $basewidth;
    } else {
      $startpos = $req['width'] * ($req['start'] - $range_end) / $basewidth;
      $endpos = $req['width'] * ($req['start'] - $range_start + 1) / $basewidth;
    }
    if($startpos < 0) $startpos = 0;
    if($endpos > $req['width']) $endpos = $req['width']-1;

    imageline($image, $startpos, $h, $endpos, $h, $color);

    $strand = substr(strchr ($line, 'strand='), 7, 1);
    if ( $strand == '+' xor $req['start'] >= $req['end']) {
      for($i = $startpos; $i < $endpos-10; $i+=10){
        imageline($image, $i, $h-$hgene, $i+$hgene, $h, $color);
        imageline($image, $i, $h+$hgene, $i+$hgene, $h, $color);
      }
    }else if ( $strand == '-' xor $req['start'] >= $req['end']) {
      for($i = $startpos; $i < $endpos -10; $i+=10){
        imageline($image, $i, $h, $i+$hgene, $h-$hgene, $color);
        imageline($image, $i, $h, $i+$hgene, $h+$hgene, $color);
      }
    }

    if($startpos > 100){
      if(($name_pos = strpos($line, 'name=')) !== FALSE) {
        $name_line = substr($line, $name_pos + 5);
        list($name, $remain) = split("[ \t]", $name_line);
      
        $strbox = imagettfbbox( $size, 0, $fontfile, $name );      
        imagettftext( $image, $size, 0, $startpos-$strbox[2]+$strbox[0]- 10, $h + (- $h2 + $strbox[3]-$strbox[5])/2, $color, $fontfile, $name);
      }
    }

    $exon_line = $line;
    for(;;){
      if(($exon = strchr ($exon_line, 'exon=')) == FALSE) break;
      $exon_line = substr($exon, 5);
      list($exon_start, $exon_end, $remain) = split("[, \t]", $exon_line);
      if($exon_start > $exon_end) {
        $tmp = $exon_start;
        $exon_start = $exon_end;
        $exon_end = $tmp;
      }
      if($req['end'] >= $req['start']){
        $startpos = $req['width'] * ($exon_start - $req['start']) / $basewidth;
        $endpos = $req['width'] * ($exon_end - $req['start'] + 1) / $basewidth;
      }else {
        $endpos = $req['width'] * ($req['start'] - $exon_start + 1) / $basewidth;
        $startpos = $req['width'] * ($req['start'] - $exon_end) / $basewidth;
      }
      if (($endpos < 0) || ($startpos >$req['width'] ))  continue;

      if($startpos < 0) $startpos = 0;
      if($endpos > $req['width']) $endpos = $req['width']-1;

      imagefilledrectangle($image, $startpos, $h-$hgene, $endpos, $h+$hgene, $color);
    }

  }

  // ᡼ν
  header( 'Content-type: image/png' );
  imagepng( $image );

  imagedestroy( $image );
}

function draw_gene_style_small($genes, $req, $colorD, $h1, $hgene){
  global $utgb_font_Abadi_file;

  $num_genes = sizeof($genes);

  if ($req['start'] > $req['end']){
    usort ($genes, "cmp_genes_rev");
  } 
  $basewidth = abs ($req['end'] - $req['start']) + 1;

  $size = 8;
  $fontfile = $utgb_font_Abadi_file;


#  $h1 = 10;
#  $hgene = 3; # 20
#  $h2 = 5;
#  $h2 = 1;
  $h2 = 0;

  $gene_height = array();
  $height = get_pack_height ($genes, $req, $gene_height, $h1,10);

  $image = imagecreatetruecolor( $req['width'], $height );
  $white = imagecolorallocate( $image, 0xFF, 0xFF, 0xFF );
  $black = imagecolorallocate( $image, 0x00, 0x00, 0x00 );  

// imagefill( $image, 0, 0, $white);
  imagefilledrectangle($image, 0, 0, $req['width']-1,$height-1, $white);
  // ᡼κ

#  for($i=50; $i < $req['width']; $i = $i +50){
#    imageline($image, $i, 0, $i, $height, $black);
#  }

  draw_ruler($image, $req, $height);

  for($num=0; $num < $num_genes; $num++){
    $line = $genes[$num];
    $range_line = substr(strchr ($line, 'range='), 6);
    list($range_start, $range_end, $remain) = split("[, \t]", $range_line);
    if($range_start > $range_end) {
      $tmp = $range_start;
      $range_start = $range_end;
      $range_end = $tmp;
    }

// μ
    $colorRGB = $colorD;

   if(array_key_exists('usecolor', $req)) {
     if(preg_match("/^(\w+)\-color$/",$req['usecolor'],$at)){
       $colorRGB = get_genecolor_by_color($colorD, $line, $at[1], $req['color']);
     }else if(preg_match("/^(\w+)\-gradation$/",$req['usecolor'],$at)){
       $colorRGB = get_genecolor_by_gradation($colorD, $line, $at[1], $req['gradation']);
     }
   }

   if (array_key_exists ('foundGene', $req) ){
     if(($name_pos = strpos($line, 'name=')) !== FALSE) {
       $name_line = substr($line, $name_pos + 5);
       list($name, $remain) = split("[ \t]", $name_line);
       if ($name == $req['foundGene']){
         $colorRGB = array(230,159,0);
       }
     }
   } 

   $color = imagecolorallocate( $image, $colorRGB[0], $colorRGB[1], $colorRGB[2] );

    $h = $h1 / 2 +  $h2 + $h1 * $gene_height[$num];
    if($req['end'] >= $req['start']){
      $startpos = $req['width'] * ($range_start - $req['start']) / $basewidth;
      $endpos = $req['width'] * ($range_end - $req['start'] + 1) / $basewidth;
    } else {
      $startpos = $req['width'] * ($req['start'] - $range_end) / $basewidth;
      $endpos = $req['width'] * ($req['start'] - $range_start + 1) / $basewidth;
    }
    if($startpos < 0) $startpos = 0;
    if($endpos > $req['width']) $endpos = $req['width']-1;

    imageline($image, $startpos, $h, $endpos, $h, $color);

    $exon_line = $line;
    for(;;){
      if(($exon = strchr ($exon_line, 'exon=')) == FALSE) break;
      $exon_line = substr($exon, 5);
      list($exon_start, $exon_end, $remain) = split("[, \t]", $exon_line);
      if($exon_start > $exon_end) {
        $tmp = $exon_start;
        $exon_start = $exon_end;
        $exon_end = $tmp;
      }
      if($req['end'] >= $req['start']){
        $startpos = $req['width'] * ($exon_start - $req['start']) / $basewidth;
        $endpos = $req['width'] * ($exon_end - $req['start'] + 1) / $basewidth;
      }else {
        $endpos = $req['width'] * ($req['start'] - $exon_start + 1) / $basewidth;
        $startpos = $req['width'] * ($req['start'] - $exon_end) / $basewidth;
      }
      if (($endpos < 0) || ($startpos >$req['width'] ))  continue;

      if($startpos < 0) $startpos = 0;
      if($endpos > $req['width']) $endpos = $req['width']-1;

      imagefilledrectangle($image, $startpos, $h-$hgene, $endpos, $h+$hgene, $color);
    }

  }

  // ᡼ν
  header( 'Content-type: image/png' );
  imagepng( $image );

  imagedestroy( $image );
}


function draw_gene($file,$first_line){
  $first_line = trim (substr($first_line, 9));

  $colorD = get_defaultcolor($first_line);

  $opattrs = get_optional_attribute($first_line);

  $req = get_request($_REQUEST, $opattrs, $colorD);

  $genes = get_display_genes($file,$req);

  // style θ
  $style = $req['style'];
  if ($style == 'full'){
    draw_gene_style_full($genes,$req,$colorD,9,3);
  }else if ($style == 'dense'){
    draw_gene_style_dense($genes,$req,$colorD,9);
  }else if ($style == 'pack'){
    draw_gene_style_pack($genes,$req,$colorD, 9,3);
  }else if ($style == 'small'){
    draw_gene_style_small($genes,$req,$colorD, 4,1);
  }
}


function draw_gene_index_style_full($genes,$req,$colorD, $h1, $hgene){
  global $utgb_font_Abadi_file;
  
  $num_genes = sizeof($genes);

  // ᡼
#  $h1 = 10;
#  $hgene = 5; # 20
  $h2 = 0;

  $size = 8;
  $fontfile = $utgb_font_Abadi_file;

  $height = $num_genes * $h1 + $h2;
  if ($num_genes == 0) $height = 5;
  $width = 100;
  $image = imagecreatetruecolor( $width, $height );
  $white = imagecolorallocate( $image, 0xFF, 0xFF, 0xFF );
  $black = imagecolorallocate( $image, 0x00, 0x00, 0x00 );  

// imagefill( $image, 0, 0, $white);
  imagefilledrectangle($image, 0, 0, $width-1,$height-1, $white);
  // ᡼κ

  for($num=0; $num < $num_genes; $num++){
    $line = $genes[$num];
// μ
    $colorRGB = $colorD;
    if(preg_match("/^(\w+)\-color$/",$req['usecolor'],$at)){
      $colorRGB = get_genecolor_by_color($colorD, $line, $at[1], $req['color']);
    }else if(preg_match("/^(\w+)\-gradation$/",$req['usecolor'],$at)){
      $colorRGB = get_genecolor_by_gradation($colorD, $line, $at[1], $req['gradation']);
    }


    if (array_key_exists ('foundGene', $req) ){
      if(($name_pos = strpos($line, 'name=')) !== FALSE) {
        $name_line = substr($line, $name_pos + 5);
        list($name, $remain) = split("[ \t]", $name_line);
        if ($name == $req['foundGene']){
          $colorRGB = array(230,159,0);
        }
      }
    } 

    $color = imagecolorallocate( $image, $colorRGB[0], $colorRGB[1], $colorRGB[2] );

    $h = $h1 * $num;

    if(($name_pos = strpos($line, 'name=')) !== FALSE) {
      $name_line = substr($line, $name_pos + 5);
      list($name, $remain) = split("[ \t]", $name_line);

      $strbox = imagettfbbox( $size, 0, $fontfile, $name );      
      imagettftext( $image, $size, 0, ($width-$strbox[2]+$strbox[0])/2, $h + ($h1 + $h2 + $strbox[3]-$strbox[5])/2, $color, $fontfile, $name);
    }
  }

  // ᡼ν
  header( 'Content-type: image/png' );
  imagepng( $image );

  imagedestroy( $image );
}


function draw_gene_index_style_dense($genes,$req,$colorD,$height){
  $num_genes = sizeof($genes);

  $width = 100;
  $image = imagecreatetruecolor( $width, $height );
  $white = imagecolorallocate( $image, 0xFF, 0xFF, 0xFF );
  $black = imagecolorallocate( $image, 0x00, 0x00, 0x00 );  

  imagefilledrectangle($image, 0, 0, $width-1,$height-1, $white);

  // ᡼ν
  header( 'Content-type: image/png' );
  imagepng( $image );

  imagedestroy( $image );
}

function  draw_gene_index_style_pack($genes,$req,$colorD, $h1,$hgene){
  global $utgb_font_Abadi_file;
  
  $num_genes = sizeof($genes);
  if ($req['start'] > $req['end']){
    usort ($genes, "cmp_genes_rev");
  } 
  $basewidth = abs ($req['end'] - $req['start'] + 1);
  // ᡼
  $h2 = 0;

  $size = 8;
  $fontfile = $utgb_font_Abadi_file;


  $gene_height = array();
  $height = get_pack_height ($genes, $req, $gene_height, $h1, 100);

  $width = 100;
  $image = imagecreatetruecolor( $width, $height );
  $white = imagecolorallocate( $image, 0xFF, 0xFF, 0xFF );
  $black = imagecolorallocate( $image, 0x00, 0x00, 0x00 );  

// imagefill( $image, 0, 0, $white);
  imagefilledrectangle($image, 0, 0, $width-1,$height-1, $white);
  // ᡼κ

  for($num=0; $num < $num_genes; $num++){
    $line = $genes[$num];
    $range_line = substr(strchr ($line, 'range='), 6);
    list($range_start, $range_end, $remain) = split("[, \t]", $range_line);
    if($range_start > $range_end) {
      $tmp = $range_start;
      $range_start = $range_end;
      $range_end = $tmp;
    }

// μ
    $colorRGB = $colorD;
   if(preg_match("/^(\w+)\-color$/",$req['usecolor'],$at)){
     $colorRGB = get_genecolor_by_color($colorD, $line, $at[1], $req['color']);
   }else if(preg_match("/^(\w+)\-gradation$/",$req['usecolor'],$at)){
     $colorRGB = get_genecolor_by_gradation($colorD, $line, $at[1], $req['gradation']);
   }


   if (array_key_exists ('foundGene', $req) ){
     if(($name_pos = strpos($line, 'name=')) !== FALSE) {
       $name_line = substr($line, $name_pos + 5);
       list($name, $remain) = split("[ \t]", $name_line);
       if ($name == $req['foundGene']){
         $colorRGB = array(230,159,0);
       }
     }
   } 

   $color = imagecolorallocate( $image, $colorRGB[0], $colorRGB[1], $colorRGB[2] );

    $h = $h1 * $gene_height[$num];
    if($req['end'] >= $req['start']){
      $startpos = $req['width'] * ($range_start - $req['start']) / $basewidth;
      $endpos = $req['width'] * ($range_end - $req['start']) / $basewidth;
    } else {
      $startpos = $req['width'] * ($req['start'] - $range_end) / $basewidth;
      $endpos = $req['width'] * ($req['start'] - $range_start) / $basewidth;
    }

    if($startpos <= 100){

    if(($name_pos = strpos($line, 'name=')) !== FALSE) {
      $name_line = substr($line, $name_pos + 5);
      list($name, $remain) = split("[ \t]", $name_line);
      #imagestring($image, 1, 10, $h-20, $name, $black);
      // Replace path by your own font path

      $strbox = imagettfbbox( $size, 0, $fontfile, $name );      
      imagettftext( $image, $size, 0, ($width-$strbox[2]+$strbox[0])/2, $h + ($h1 + $h2 + $strbox[3]-$strbox[5])/2, $color, $fontfile, $name);
    }
    }
  }

  // ᡼ν
  header( 'Content-type: image/png' );
  imagepng( $image );

  imagedestroy( $image );
}

function  draw_gene_index_style_small($genes,$req,$colorD,$h1,$hgene){
  global $utgb_font_Abadi_file;

  $num_genes = sizeof($genes);
  if ($req['start'] > $req['end']){
    usort ($genes, "cmp_genes_rev");
  } 
  $basewidth = abs ($req['end'] - $req['start'] + 1);
  // ᡼
  $h2 = 0;

  $size = 8;
  $fontfile = $utgb_font_Abadi_file;


  $gene_height = array();
  $height = get_pack_height ($genes, $req, $gene_height, $h1, 10);
  $width = 100;
  $image = imagecreatetruecolor( $width, $height );
  $white = imagecolorallocate( $image, 0xFF, 0xFF, 0xFF );
  $black = imagecolorallocate( $image, 0x00, 0x00, 0x00 );  

// imagefill( $image, 0, 0, $white);
  imagefilledrectangle($image, 0, 0, $width-1,$height-1, $white);
  // ᡼ν
  header( 'Content-type: image/png' );
  imagepng( $image );

  imagedestroy( $image );

}


function draw_gene_index($file, $first_line){
  $first_line = trim (substr($first_line, 9));

  $colorD = get_defaultcolor($first_line);

  $opattrs = get_optional_attribute($first_line);

  $req = get_request($_REQUEST, $opattrs, $colorD);

  $genes = get_display_genes($file,$req);

  // style θ
  $style = $req['style'];
  if ($style == 'full'){
    draw_gene_index_style_full($genes,$req,$colorD,9,3);
  }else if ($style == 'dense'){
    draw_gene_index_style_dense($genes,$req,$colorD,9);
  }else if ($style == 'pack'){
    draw_gene_index_style_pack($genes,$req,$colorD,9,3);
  }else if ($style == 'small'){
    draw_gene_index_style_small($genes,$req,$colorD,4,1);
  }
}

function def_gene_operation_style_full($genes,$req,$h1,$hgene){
  $num_genes = sizeof($genes);
  $basewidth = abs ($req['end'] - $req['start']) + 1;

// ̥ѥ᡼
  $h2 = 0;

  $height = $num_genes * $h1 + $h2;
  if ($num_genes == 0) $height = 5;

// xml
  header('Content-Type: text/xml');

  print"<?xml version=\"1.0\" ?>\n";
  print "<operation_layer>\n";
  for($num=0; $num < $num_genes; $num++){
    $line = $genes[$num];
    $range_line = substr(strchr ($line, 'range='), 6);
    list($range_start, $range_end, $remain) = split("[, \t]", $range_line);
    if($range_start > $range_end) {
      $tmp = $range_start;
      $range_start = $range_end;
      $range_end = $tmp;
    }

    if($req['end'] >= $req['start']){
      $startpos = $req['width'] * ($range_start - $req['start']) / $basewidth;
      $endpos = $req['width'] * ($range_end - $req['start'] + 1) / $basewidth;
    } else {
      $startpos = $req['width'] * ($req['start'] - $range_end) / $basewidth;
      $endpos = $req['width'] * ($req['start'] - $range_start + 1) / $basewidth;
    }

    $h = $h1 / 2 +  $h2 + $h1 * $num;

    $y1 = $h-$hgene;
    $y2 = $h+$hgene+1;
    if ($startpos < 0) {
      $x1 = 0;
    }else {
      $x1 = floor ($startpos); // 0;
    }
    if ($endpos >= $req['width']) {
      $x2 = $req['width']-1;
    }else {
      $x2 = ceil($endpos) ; // $req['width']-1;
    }
    // URLμ
    if (preg_match("/url=\"(\S+)\"/",$line, $url)){
    $url[1] = preg_replace('/&/', "&amp;" , $url[1]);
    print "  <rect_area rect=\"($x1,$y1,$x2,$y2)\">\n" ;
    print "    <mouseclick_event>\n";

    print "      <link_operation url=\"$url[1]\" />\n";

    print "    </mouseclick_event>\n" ;
    print "  </rect_area>\n" ;
    }else if (preg_match("/url=(\S+)/",$line, $url)){
    $url[1] = preg_replace('/&/', "&amp;" , $url[1]);
    print "  <rect_area rect=\"($x1,$y1,$x2,$y2)\">\n" ;
    print "    <mouseclick_event>\n";

    print "      <link_operation url=\"$url[1]\" />\n";

    print "    </mouseclick_event>\n" ;
    print "  </rect_area>\n" ;
    }

  }
  print "</operation_layer>";
}

function def_gene_operation_style_dense($genes,$req,$h1){
// xml
  header('Content-Type: text/xml');

  print "<?xml version=\"1.0\" ?>\n";
  print "<operation_layer>\n";
  
  print "</operation_layer>";
}

function def_gene_operation_style_pack($genes, $req,$h1,$hgene){
  global $utgb_font_Abadi_file;

  $num_genes = sizeof($genes);
  if ($req['start'] > $req['end']){
    usort ($genes, "cmp_genes_rev");
  } 

  $basewidth = abs ($req['end'] - $req['start'] + 1);

  $size = 8;
  $fontfile = $utgb_font_Abadi_file;

#  $h2 = 5;
  $h2 = 0;

  $gene_height = array();
  $height = get_pack_height ($genes, $req, $gene_height, $h1, 100);

// xml
  header('Content-Type: text/xml');

  print "<?xml version=\"1.0\" ?>\n";
  print "<operation_layer>\n";
  for($num=0; $num < $num_genes; $num++){
    $line = $genes[$num];
    $range_line = substr(strchr ($line, 'range='), 6);
    list($range_start, $range_end, $remain) = split("[, \t]", $range_line);
    if($range_start > $range_end) {
      $tmp = $range_start;
      $range_start = $range_end;
      $range_end = $tmp;
    }

    $h = $h1 / 2 +  $h2 + $h1 * $gene_height[$num];
    if($req['end'] >= $req['start']){
      $startpos = $req['width'] * ($range_start - $req['start']) / $basewidth;
      $endpos = $req['width'] * ($range_end - $req['start'] + 1) / $basewidth;
    } else {
      $startpos = $req['width'] * ($req['start'] - $range_end) / $basewidth;
      $endpos = $req['width'] * ($req['start'] - $range_start + 1) / $basewidth;
    }

    if($startpos > 100){
      if(($name_pos = strpos($line, 'name=')) !== FALSE) {
        $name_line = substr($line, $name_pos + 5);
        list($name, $remain) = split("[ \t]", $name_line);
        $strbox = imagettfbbox( $size, 0, $fontfile, $name );
        $startpos = $startpos - $strbox[2] + $strbox[0] - 10;
      }
    }

    $y1 = $h-$hgene;
    $y2 = $h+$hgene+1;
    if ($startpos < 0) {
      $x1 = 0;
    }else {
      $x1 = floor ($startpos); // 0;
    }
    if ($endpos >= $req['width']) {
      $x2 = $req['width']-1;
    }else {
      $x2 = ceil($endpos) ; // $req['width']-1;
    }
    // URLμ
    if (preg_match("/url=\"(\S+)\"/",$line, $url)){
    $url[1] = preg_replace('/&/', "&amp;" , $url[1]);
    print "  <rect_area rect=\"($x1,$y1,$x2,$y2)\">\n" ;
    print "    <mouseclick_event>\n";

    print "      <link_operation url=\"$url[1]\" />\n";

    print "    </mouseclick_event>\n" ;
    print "  </rect_area>\n" ;
    }else if (preg_match("/url=(\S+)/",$line, $url)){
    $url[1] = preg_replace('/&/', "&amp;" , $url[1]);
    print "  <rect_area rect=\"($x1,$y1,$x2,$y2)\">\n" ;
    print "    <mouseclick_event>\n";

    print "      <link_operation url=\"$url[1]\" />\n";

    print "    </mouseclick_event>\n" ;
    print "  </rect_area>\n" ;
    }
  }
  print "</operation_layer>";

}

function def_gene_operation_style_small($genes, $req,$h1,$hgene){
  global $utgb_font_Abadi_file;

  $num_genes = sizeof($genes);
  if ($req['start'] > $req['end']){
    usort ($genes, "cmp_genes_rev");
  } 

  $basewidth = abs ($req['end'] - $req['start'] + 1);

  $size = 8;
  $fontfile = $utgb_font_Abadi_file;


#  $h2 = 5;
  $h2 = 0;

  $gene_height = array();
  $height = get_pack_height ($genes, $req, $gene_height, $h1, 10);

// xml
  header('Content-Type: text/xml');

  print "<?xml version=\"1.0\" ?>\n";
  print "<operation_layer>\n";
  for($num=0; $num < $num_genes; $num++){
    $line = $genes[$num];
    $range_line = substr(strchr ($line, 'range='), 6);
    list($range_start, $range_end, $remain) = split("[, \t]", $range_line);
    if($range_start > $range_end) {
      $tmp = $range_start;
      $range_start = $range_end;
      $range_end = $tmp;
    }

    $h = $h1 / 2 +  $h2 + $h1 * $gene_height[$num];
    if($req['end'] >= $req['start']){
      $startpos = $req['width'] * ($range_start - $req['start']) / $basewidth;
      $endpos = $req['width'] * ($range_end - $req['start'] + 1) / $basewidth;
    } else {
      $startpos = $req['width'] * ($req['start'] - $range_end) / $basewidth;
      $endpos = $req['width'] * ($req['start'] - $range_start + 1) / $basewidth;
    }

#    if($startpos > 100){
#      if(($name_pos = strpos($line, 'name=')) !== FALSE) {
# $name_line = substr($line, $name_pos + 5);
# list($name, $remain) = split("[ \t]", $name_line);
# $strbox = imagettfbbox( $size, 0, $fontfile, $name );
# $startpos = $startpos - $strbox[2] + $strbox[0] - 10;
#      }
#    }

    $y1 = $h-$hgene;
    $y2 = $h+$hgene+1;
    if ($startpos < 0) {
      $x1 = 0;
    }else {
      $x1 = floor ($startpos); // 0;
    }
    if ($endpos >= $req['width']) {
      $x2 = $req['width']-1;
    }else {
      $x2 = ceil($endpos) ; // $req['width']-1;
    }
    // URLμ
    if (preg_match("/url=\"(\S+)\"/",$line, $url)){
    $url[1] = preg_replace('/&/', "&amp;" , $url[1]);
    print "  <rect_area rect=\"($x1,$y1,$x2,$y2)\">\n" ;
    print "    <mouseclick_event>\n";

    print "      <link_operation url=\"$url[1]\" />\n";

    print "    </mouseclick_event>\n" ;
    print "  </rect_area>\n" ;
    }else if (preg_match("/url=(\S+)/",$line, $url)){
    $url[1] = preg_replace('/&/', "&amp;" , $url[1]);
    print "  <rect_area rect=\"($x1,$y1,$x2,$y2)\">\n" ;
    print "    <mouseclick_event>\n";

    print "      <link_operation url=\"$url[1]\" />\n";

    print "    </mouseclick_event>\n" ;
    print "  </rect_area>\n" ;
    }
  }
  print "</operation_layer>";

}


function def_gene_operation($file, $first_line){
// ᡼μ
  $first_line = trim (substr($first_line, 9));

  $opattrs = get_optional_attribute($first_line);

  $req = get_request($_REQUEST, $opattrs, $colorD);

  $genes = get_display_genes($file,$req);

  // style θ
  $style = $req['style'];
  if ($style == 'full'){
    def_gene_operation_style_full($genes,$req,9,3);
  }else if ($style == 'dense'){
    def_gene_operation_style_dense($genes,$req,9);
  }else if ($style == 'pack'){
    def_gene_operation_style_pack($genes,$req,9,3);
  }else if ($style == 'small'){
    def_gene_operation_style_small($genes,$req,4,1);
  }
}

function def_gene_index_operation_style_full($genes,$req,$h1, $hgene){
  $num_genes = sizeof($genes);

// ̥ѥ᡼
  $h2 = 0;

  $height = $num_genes * $h1 + $h2;
  if($num_genes == 0) $height = 5;
  $width = 100;

// xml
  header('Content-Type: text/xml');

  print "<?xml version=\"1.0\" ?>\n"; 
  print "<operation_layer>\n";
  for($num=0; $num < $num_genes; $num++){
    $line = $genes[$num];

    $h = $h1 / 2 +  $h2 + $h1 * $num;

    $y1 = $h-$hgene;
    $y2 = $h+$hgene+1;

    $x1 = 0;
    $x2 = $width-1;

    // URLμ
    if (preg_match("/url=\"(\S+)\"/",$line, $url)){
    $url[1] = preg_replace('/&/', "&amp;" , $url[1]);
    print "  <rect_area rect=\"($x1,$y1,$x2,$y2)\">\n" ;
    print "    <mouseclick_event>\n";

    print "      <link_operation url=\"$url[1]\" />\n";

    print "    </mouseclick_event>\n" ;
    print "  </rect_area>\n" ;
    }else if (preg_match("/url=(\S+)/",$line, $url)){
    $url[1] = preg_replace('/&/', "&amp;" , $url[1]);
    print "  <rect_area rect=\"($x1,$y1,$x2,$y2)\">\n" ;
    print "    <mouseclick_event>\n";

    print "      <link_operation url=\"$url[1]\" />\n";

    print "    </mouseclick_event>\n" ;
    print "  </rect_area>\n" ;
    }

  }
  print "</operation_layer>";
}

function def_gene_index_operation_style_dense($genes,$req,$height){
// xml
  header('Content-Type: text/xml');

  print "<?xml version=\"1.0\" ?>\n";
  print "<operation_layer>\n";
  
  print "</operation_layer>";
}

function def_gene_index_operation_style_pack($genes, $req,$h1,$hgene){

  $num_genes = sizeof($genes);
  if ($req['start'] > $req['end']){
    usort ($genes, "cmp_genes_rev");
  } 
  $basewidth = abs ($req['end'] - $req['start'] + 1);

#  $h2 = 5;
  $h2 = 0;

  $gene_height = array();
  $height = get_pack_height ($genes, $req, $gene_height, $h1, 100);
  $width = 100;

// xml
  header('Content-Type: text/xml');

  print "<?xml version=\"1.0\" ?>\n";
  print "<operation_layer>\n";
  for($num=0; $num < $num_genes; $num++){
    $line = $genes[$num];
    $range_line = substr(strchr ($line, 'range='), 6);
    list($range_start, $range_end, $remain) = split("[, \t]", $range_line);
    if($range_start > $range_end) {
      $tmp = $range_start;
      $range_start = $range_end;
      $range_end = $tmp;
    }

    $h = $h1 / 2 +  $h2 + $h1 * $gene_height[$num];
    if($req['end'] >= $req['start']){
      $startpos = $req['width'] * ($range_start - $req['start']) / $basewidth;
      $endpos = $req['width'] * ($range_end - $req['start']) / $basewidth;
    } else {
      $startpos = $req['width'] * ($req['start'] - $range_end) / $basewidth;
      $endpos = $req['width'] * ($req['start'] - $range_start) / $basewidth;
    }

    if($startpos <= 100){

    $y1 = $h-$hgene;
    $y2 = $h+$hgene+1;

    $x1 = 0;
    $x2 = $width-1;

    // URLμ
    if (preg_match("/url=\"(\S+)\"/",$line, $url)){
    $url[1] = preg_replace('/&/', "&amp;" , $url[1]);
    print "  <rect_area rect=\"($x1,$y1,$x2,$y2)\">\n" ;
    print "    <mouseclick_event>\n";

    print "      <link_operation url=\"$url[1]\" />\n";

    print "    </mouseclick_event>\n" ;
    print "  </rect_area>\n" ;
    }else if (preg_match("/url=(\S+)/",$line, $url)){
    $url[1] = preg_replace('/&/', "&amp;" , $url[1]);
    print "  <rect_area rect=\"($x1,$y1,$x2,$y2)\">\n" ;
    print "    <mouseclick_event>\n";

    print "      <link_operation url=\"$url[1]\" />\n";

    print "    </mouseclick_event>\n" ;
    print "  </rect_area>\n" ;
    }


    }
  }
  print "</operation_layer>";

}


function def_gene_index_operation($file, $first_line){
  $first_line = trim (substr($first_line, 9));

  $opattrs = get_optional_attribute($first_line);

  $req = get_request($_REQUEST, $opattrs, $colorD);

  $genes = get_display_genes($file,$req);

  // style θ
  $style = $req['style'];
  if ($style == 'full'){
    def_gene_index_operation_style_full($genes,$req,9,3);
  }else if ($style == 'dense'){
    def_gene_index_operation_style_dense($genes,$req,10);
  }else if ($style == 'pack'){
    def_gene_index_operation_style_pack($genes,$req,9,3);
  }else if ($style == 'small'){
    def_gene_index_operation_style_dense($genes,$req,10);
  }
}
?>