<?php

  $fontsize  = 10;
  $fontfile  = './fonts/Abadi MT Condensed Light.ttf';
  $text      = $_GET['text'];

  assert( is_string($text) );

  if( strlen($text) > 0 ) {
    $strbox = imagettfbbox( $fontsize, 0, $fontfile, $text );
    $width  = max( 1, $strbox[2] - $strbox[0] );
    $height = max( 1, $strbox[1] - $strbox[7] );
    assert( $width > 0 );
    assert( $height > 0 );
    $image = imagecreatetruecolor( $width+1, $height+1 );
    $bkColor   = imagecolorallocate( $image, 0xE6, 0xE6, 0xFF );
    $charColor = imagecolorallocate( $image, 0x00, 0x00, 0x00 );
    imagefilledrectangle( $image, 0, 0, $width, $height, $bkColor );
    imagettftext( $image, $fontsize, 0, 0, -$strbox[7], $charColor, $fontfile, $text );

    header( 'Content-type: image/png' );
    imagepng( $image );
    imagedestroy( $image );
  }
?>
