#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include "et_parser.h"

int main(int argc, char *argv[])
{
  FILE *fp;
  char *buf;
  ET_TYPE        ettype;
  EasyGeneTrack  *geneTrack = NULL;
  EasyGraphTrack *graphTrack = NULL;
  EasyColorTrack *colorTrack = NULL;
//  EasyGene       *gene = NULL;
  EasyGraph      *graph = NULL;
//  EasyColor      *color = NULL;

  if (argc != 2) {
    fprintf(stderr, "usage: %s et-file\n", argv[0]);
    exit(1);
  }
  fp = fopen(argv[1], "r");
  if (!fp) {
    fprintf(stderr, "cannot open file: %s\n", argv[1]);
    exit(1);
  }
  while (vfgets(&buf, fp)) {
    ettype = identify_line(buf);
    switch (ettype) {
    case et_geneTrack:
      fprintf(stderr, "*** geneTrack is found.\n");
      geneTrack = parse_geneTrack_line(buf);
      break;
    case et_graphTrack:
      fprintf(stderr, "*** graphTrack is found.\n");
      graphTrack = parse_graphTrack_line(buf);
      printEasyGraphTrackHeader(stdout, graphTrack);
      break;
    case et_colorTrack:
      fprintf(stderr, "*** colorTrack is found.\n");
      colorTrack = parse_colorTrack_line(buf);
      break;
    case et_gene:
      fprintf(stderr, "*** gene is found.\n");
      break;
    case et_graph:
      fprintf(stderr, "*** graph is found.\n");
      graph = parse_graph_line(buf);
      graphTrack->graphs[graphTrack->graphnum] = graph;
      graphTrack->graphnum++;
      printEasyGraph(stdout, graph);
      break;
    case et_color:
      fprintf(stderr, "*** color is found.\n");
      break;
    default:
      fprintf(stderr, "*** other line is found.\n%s", buf);
    }
  }
  fprintf(stderr, "----------------------------------------------------------------\n");
  if (geneTrack) {
//    printEasyGeneTrack(stdout, geneTrack);
//    destroyEasyGeneTrack(geneTrack);
  }
  if (graphTrack) {
    printEasyGraphTrack(stdout, graphTrack);
    destroyEasyGraphTrack(graphTrack);
  }
  if (colorTrack) {
    printEasyColorTrack(stdout, colorTrack);
    destroyEasyColorTrack(colorTrack);
  }
  checkAllocationCount();
  exit(0);
}
