#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include "easyTrackCache.h"
#include "etcache.h"
#include "blend.h"

int main(int argc, char *argv[])
{
  int result;
  int start, end, width;

  if (argc != 10 && argc != 9) {
    fprintf(stderr, "-------------------------------------------------------------------------\n");
    fprintf(stderr, "usage: %s name species revision target start end width blend [outputfile]\n", argv[0]);
    fprintf(stderr, "   ex) %s mappedGene medaka 200406 scaffold1 1 1000 100 ave\n", argv[0]);
    fprintf(stderr, "-------------------------------------------------------------------------\n");
    exit(0);
  }
  start = atoi(argv[5]);
  end = atoi(argv[6]);
  start--;  // 1-originϤΤ0-origin᤹
  end--;    // Ʊ
  width = atoi(argv[7]);

  if (argc == 10)
    result = getGraphData(argv[1], argv[2], argv[3], argv[4], start, end,
                          width, NULL, argv[8], argv[9]);
  else
    result = getGraphData(argv[1], argv[2], argv[3], argv[4], start, end,
                          width, NULL, argv[8], "stdout");

  if (!result)
    fprintf(stderr, "!! error.\n");
  checkAllocationCount();
  exit(0);
}
