#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include "easyTrackCache.h"

int main(int argc, char *argv[])
{
  int result;
  int start, end, width;
  int geneThreshold;
  int optSelectFlag, optRealFlag;
  double realLower, realUpper;

  if (!((argc == 10) || (argc == 17))) {
    fprintf(stderr, "-------------------------------------------------------------------------\n");
    fprintf(stderr, "usage: %s name species revision target start end width outputfile threshold\n", argv[0]);
    fprintf(stderr, "       OptSelectFlag SelectName SelectParam OptRealFlag RealName RealLower RealUpper\n");
    fprintf(stderr, "   ex) %s mappedGene medaka 200406 scaffold1 100 1000000 800 stdout 100\n", argv[0]);
    fprintf(stderr, "       1 fromSpecies medaka 1 matchRatio 0.99 1.0\n");
    fprintf(stderr, "-------------------------------------------------------------------------\n");
    exit(0);
  }
  start = atoi(argv[5]);
  end = atoi(argv[6]);
  width = atoi(argv[7]);
  geneThreshold = atoi(argv[9]);

  if (argc == 10) {
    result = getGeneData(argv[1], argv[2], argv[3], argv[4],
			 start, end, width, NULL, argv[8], geneThreshold,
			 0, NULL, NULL, 0, NULL, 0.0, 0.0);
  }
  else {
    optSelectFlag  = atoi(argv[10]);
    optRealFlag    = atoi(argv[13]);
    realLower      = atof(argv[15]);
    realUpper      = atof(argv[16]);

    result = getGeneData(argv[1], argv[2], argv[3], argv[4],
			 start, end, width, NULL, argv[8], geneThreshold,
			 optSelectFlag, argv[11], argv[12], optRealFlag, argv[14], realLower, realUpper);
  }

  if (result)
    fprintf(stderr, "done.\n");
  else
    fprintf(stderr, "error.\n");
  checkAllocationCount();
  exit(0);
}
