#include <stdio.h>
#include <libpq-fe.h>
#include "etcache.h"

int max_gene_number = DEFAULT_MAX_GENE_NUMBER;
BLEND currentGraphBlend = DEFAULT_GRAPH_BLEND;
BLEND currentColorBlend = DEFAULT_COLOR_BLEND;
COLOR DefaultGraphColor = {0, 0, 255};
COLOR DefaultBackgroundColor = {255, 255, 255};
EG_VALUE DefaultGraphValueMax = 1;
EG_VALUE DefaultGraphValueMin = 0;

PGconn   *Conn = NULL;
PGresult *Results = NULL;

int onmemEGeneTrackNum = 0;
int onmemEGraphTrackNum = 0;
int onmemEColorTrackNum = 0;
int onmemEGeneNum = 0;
int onmemEGraphNum = 0;
int onmemEColorNum = 0;
int onmemValues = 0;
int onmemColors = 0;
int onmemOptAttrs = 0;
int onmemStrings = 0;
int onmemIntArrays = 0;
int onmemPointers = 0;
int onmemResults = 0;
int onmemModeStructs = 0;
int onmemSharedArea = 0;

EG_VALUE *shared_area = NULL;
int      shared_area_size = 0;

void checkAllocationCount()
{
  if (onmemEGeneTrackNum == 0 &&
      onmemEGraphTrackNum == 0 &&
      onmemEColorTrackNum == 0 &&
      onmemEGeneNum == 0 &&
      onmemEGraphNum == 0 &&
      onmemEColorNum == 0 &&
      onmemValues == 0 &&
      onmemColors == 0 &&
      onmemOptAttrs == 0 &&
      onmemStrings == 0 &&
      onmemIntArrays == 0 &&
      onmemPointers == 0 &&
      onmemResults == 0 &&
      onmemModeStructs == 0 &&
      onmemSharedArea == 0)
    return;
  fprintf(stderr, "----- memory leak list -------------\n");
  if (onmemEGeneTrackNum != 0)
    fprintf(stderr, "  EasyGeneTrack: %d\n", onmemEGeneTrackNum);
  if (onmemEGraphTrackNum != 0)
    fprintf(stderr, "  EasyGraphTrack: %d\n", onmemEGraphTrackNum);
  if (onmemEColorTrackNum != 0)
    fprintf(stderr, "  EasyColorTrack: %d\n", onmemEColorTrackNum);
  if (onmemEGeneNum != 0)
    fprintf(stderr, "  EasyGene: %d\n", onmemEGeneNum);
  if (onmemEGraphNum != 0)
    fprintf(stderr, "  EasyGraph: %d\n", onmemEGraphNum);
  if (onmemEColorNum != 0)
    fprintf(stderr, "  EasyColor: %d\n", onmemEColorNum);
  if (onmemValues != 0)
    fprintf(stderr, "  Values: %d\n", onmemValues);
  if (onmemColors != 0)
    fprintf(stderr, "  Colors: %d\n", onmemColors);
  if (onmemOptAttrs != 0)
    fprintf(stderr, "  OptAttrs: %d\n", onmemOptAttrs);
  if (onmemStrings != 0)
    fprintf(stderr, "  Strings: %d\n", onmemStrings);
  if (onmemIntArrays != 0)
    fprintf(stderr, "  IntArrays: %d\n", onmemIntArrays);
  if (onmemPointers != 0)
    fprintf(stderr, "  Pointers: %d\n", onmemPointers);
  if (onmemResults != 0)
    fprintf(stderr, "  DBResults: %d\n", onmemResults);
  if (onmemModeStructs != 0)
    fprintf(stderr, "  ModeStructs: %d\n", onmemModeStructs);
  if (onmemSharedArea != 0)
    fprintf(stderr, "  SharedArea: %d\n", onmemSharedArea);
}

int serialize(char *filename)
{
  FILE *fp;

  fp = fopen(filename, "w");
  if (!fp) {
    fprintf(stderr, "Cannot open file: %s\n", filename);
    return 0;
  }
  fprintf(fp, "%d %d %d\n",
          max_gene_number, currentGraphBlend, currentColorBlend);
  fclose(fp);
  return 1;
}

int deserialize(char *filename)
{
  FILE  *fp;
  int   max_num, graph, color;

  fp = fopen(filename, "r");
  if (!fp) {
    fprintf(stderr, "Cannot open file: %s\n", filename);
    return 0;
  }
  fscanf(fp, "%d %d %d", &max_num, &graph, &color);
  if (max_num < 0 || graph < NOBLEND || graph > max ||
      color < NOBLEND || color > mode) {
    fprintf(stderr,
            "deserialization is failed. (num=%d, graph=%d, color=%d)\n",
            max_num, graph, color);
    return 0;
  }
  max_gene_number = max_num;
  currentGraphBlend = (BLEND)graph;
  currentColorBlend = (BLEND)color;
  fclose(fp);
  return 1;
}

