#ifndef _ETCACHE_H_
#define _ETCACHE_H_

#include <sys/types.h>
#include <libpq-fe.h>

/****************************************************************************/
/*  (1)                                                             */
/****************************************************************************/
#define NAME_MAX_LEN         31
#define COMMENT_MAX_LEN      255
#define URL_MAX_LEN          255
#define PATH_MAX_LEN         255
#define SQL_MAX_LEN          1023
#define DATE_LEN             8
#define ATTR_VALUE_MAX_LEN   1023
#define DEFAULT_OPT_ATTR_NUM 4
#define DEFAULT_GRAPH_ENTRY  4
#define DEFAULT_COLOR_ENTRY  4
#define BLEND_NAME_MAX_LEN   7

/****************************************************************************/
/*  ̤ι¤                                                            */
/****************************************************************************/
typedef float EG_VALUE;                                     /* ͤη */

typedef enum t_blend {NOBLEND, average, mode, min, max} BLEND; /* ݥꥷ */

typedef enum t_easytrack_type {
    NOTYPE, et_geneTrack, et_graphTrack, et_colorTrack,
    et_gene, et_graph, et_color
} ET_TYPE;

typedef struct t_optattr {
  char name[NAME_MAX_LEN + 1];
  char value[ATTR_VALUE_MAX_LEN + 1];
} OPTATTR;

typedef struct t_color {
//  unsigned char red;
//  unsigned char green;
//  unsigned char blue;
//  unsigned char dummy;   /* ͤʪ */
  int red;
  int green;
  int blue;
  int           start;
  int           end;
} COLOR;                                                        /* ǡ */

typedef struct t_species {
  char  name[NAME_MAX_LEN + 1];
  char  species[NAME_MAX_LEN + 1];
  char  revision[NAME_MAX_LEN + 1];
} SPECIES;                                                        /* ʪ */

// դν̾Ѥ⡼ɡʺ͡˷
typedef struct t_mode_struct {
  EG_VALUE  mode_value;
  int       mode_count;
} MODE_STRUCT;

/* EasyGene, EasyGraph, EasyColor ζʬ */
/*
typedef struct t_et_common {
  char     target[NAME_MAX_LEN + 1];
  off_t    start;
  off_t    end;
  ssize_t  unit;
  char     url[URL_MAX_LEN + 1];
  int      optnum;
  int      optareanum;
  OPTATTR  *optattrs;
} ET_COMMON;
*/

/* EasyGeneTrack, EasyGraphTrack, EasyColorTrack ζʬ */
/*
typedef struct t_et_commonTrack {
  char    name[NAME_MAX_LEN + 1];
  char    comment[COMMENT_MAX_LEN + 1];
  char    desc_url[URL_MAX_LEN + 1];
  char    species[NAME_MAX_LEN + 1];
  char    revision[NAME_MAX_LEN + 1];
  char    species_url[URL_MAX_LEN + 1];
  BLEND   blend;
  char    date[DATE_LEN + 1];
  char    optattr[ATTR_VALUE_MAX_LEN + 1];
} ET_COMMONTRACK;
*/

/****************************************************************************/
/*  (2)                                                             */
/****************************************************************************/
#define ENTRY_SIZE    sizeof(EG_VALUE)
#define COLOR_SIZE    sizeof(COLOR)

/*
#define BUFSIZE       4194304
*/
#define BUFSIZE       65536
#define MAX_ENTRY_NUM 400000000

#define BUF_ENTRIES   ((BUFSIZE) / (ENTRY_SIZE))
#define BUF_COLORS    ((BUFSIZE) / (COLOR_SIZE))

#define BUFNUM        ((MAX_ENTRY_NUM) / (BUF_ENTRIES) + 1)
#define COLBUFNUM     ((MAX_ENTRY_NUM) / (BUF_COLORS) + 1)

#define BUFLEN        65536
#define HEAPLEN       65536


#define DEFAULT_MAX_GENE_NUMBER 100
#define DEFAULT_GRAPH_BLEND     average
#define DEFAULT_COLOR_BLEND     mode

/*
#define GRAPHDATA     "graphvalue.dat"
#define COLORDATA     "colorvalue.dat"
*/
#define CACHEDIR           "../../../CacheData/"
#define CACHE_DB           "cachefiles"
#define CACHE_TABLE        "cachefiles"
#define GRAPH_TRACK_TABLE  "graphtracks"
#define GRAPH_TABLE        "graphs"
#define COLOR_TRACK_TABLE  "colortracks"
#define COLOR_TABLE        "colors"

//#define UTGB_DB_USER       "browser"

/****************************************************************************/
/*  Хѿ (etglobal.c)                                       */
/****************************************************************************/
extern int   max_gene_number;        /* EasyGeneTrackϤҿ */
extern BLEND currentGraphBlend;      /* ͤθߤιݥꥷ          */
extern BLEND currentColorBlend;      /* θߤιݥꥷ                */
extern COLOR DefaultGraphColor;
extern COLOR DefaultBackgroundColor;
extern EG_VALUE DefaultGraphValueMax;
extern EG_VALUE DefaultGraphValueMin;
extern PGconn *Conn;                 /* åDB³            */
extern PGresult *Results;            /* åDBθ̳Ǽꥢ    */

extern int onmemEGeneTrackNum;
extern int onmemEGraphTrackNum;
extern int onmemEColorTrackNum;
extern int onmemEGeneNum;
extern int onmemEGraphNum;
extern int onmemEColorNum;
extern int onmemValues;
extern int onmemColors;
extern int onmemOptAttrs;
extern int onmemStrings;
extern int onmemIntArrays;
extern int onmemPointers;
extern int onmemResults;
extern int onmemModeStructs;
extern int onmemSharedArea;

extern EG_VALUE *shared_area;
extern int      shared_area_size;

void checkAllocationCount();
int serialize(char *);            /* ХѿƤե¸   */
int deserialize(char *);          /* եƤ򥰥Хѿ˥ */

#endif
