#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "et_parser.h"
#include "blend.h"

/*****************************************************************************/
/* fpȥ꡼फԤޤǤɤ߹ࡣ˥ΰݤ뤿ᡢ*/
/* ƤӽФϡ*rbufΰ뤳ȡ                         */
/* (פˡĹԤˤбǤ褦ΰݤfgets.)              */
/*   : ºݤɤ߹Хȿ (顼 -1)                          */
/*****************************************************************************/
int vfgets(char **rbuf, FILE *fp)
{
  char buf[BUFLEN];
  char *bufp = NULL;
  int  len;
  int  total = 0;
  int  size = 0;

  while (fgets(buf, sizeof(buf), fp)) {
    len = strlen(buf);
    if (total + len >= size) {
      if (total + len - size > HEAPLEN)
        size = total + len;
      else
        size += HEAPLEN;
      if (bufp == NULL) {
        bufp = (char *)calloc(size, sizeof(char));
        onmemStrings++;
      } else {
        bufp = (char *)realloc(bufp, size * sizeof(char));
      }
      if (bufp == NULL) {
        onmemStrings--;
        fprintf(stderr, "Cannot alloc memory (%d)\n", size * sizeof(char));
        bufp = NULL;
        total = -1;
        break;
      }
    }
    strncpy(bufp + total, buf, len);
    total += len;
    if (total > 0 && bufp[total - 1] == '\n') {
      total = strlen(bufp);
      break;
    }
  }
  *rbuf = bufp;
  return total;
}

/*****************************************************************************/
/* EasyTrackμ(EasyGeneTrack, EasyGraphTrack, EasyColorTrak)Ƚ̤   */
/*****************************************************************************/
ET_TYPE identify_line(char *line)
{
  if (line == NULL) return NOTYPE;
  if (strncmp(line, "geneTrack", 9) == 0)   return et_geneTrack;
  if (strncmp(line, "graphTrack", 10) == 0) return et_graphTrack;
  if (strncmp(line, "colorTrack", 10) == 0) return et_colorTrack;
  if (strncmp(line, "gene", 4) == 0)  return et_gene;
  if (strncmp(line, "graph", 5) == 0) return et_graph;
  if (strncmp(line, "color", 5) == 0) return et_color;
  return NOTYPE;
}

/*****************************************************************************/
/* token˴ޤޤ'='ʹߤʸmember˥ԡ                        */
/*   [] :ԡΥɥ쥹(member)  :NULL                     */
/*   [] member: ɤ߹(ʸ)򥳥ԡΰ衣NULLǤOK.        */
/*          length: ԡΰ礭ޤϳݤ٤礭       */
/*          token:  ᤹٤ʸ"name=string" η                   */
/*****************************************************************************/
static char *setStrValue(char *member, int length, char *token)
{
  char *p;
  char *area = NULL;
  int  clen = 0;

  /* tokenϤʸϡ"name=mappedGene" η */
  if (!token || length <= 0) {
    fprintf(stderr, "setStrValue: invalid argument.\n");
    return NULL;
  }
  if (member) {     /* ԡ褬ѰդƤϤΰȤ */
    area = member;
  } else {          /* ԡ褬ѰդƤˤʤϿ˳ݤ */
    area = (char *)malloc(length + 1);
    if (!area) {
      fprintf(stderr, "setStrValue: memory allocation error.\n");
      return NULL;
    }
    onmemStrings++;
  }

  p = index(token, '=');
  if (!p) {
     fprintf(stderr, "setStrValue: format error. ('=' not found)\n");
     if (!member) {
       free(area); onmemStrings--; /* String */
     }
     return NULL;
  }
  p++;

  /* ֥륯ơǰϤޤƤʤͤξ */
  if (*p != '\"') {
    clen = strlen(p);
    if (clen > length) {
      fprintf(stderr, "setStrValue: copying area is too small.\n");
      if (!member) {
        free(area); onmemStrings--; /* String */
      }
      return NULL;
    }
    strcpy(area, p);
    return area;
  }

  /* ֥ͤ륯ơǰϤޤƤ */
  p++;  /* '"'μΰ֤˰ư */
  if (*(p + strlen(p) - 1) == '\"') {   /* ֤˥ڡ䥿̵֤ */
    *(p + strlen(p) - 1) = '\0';
    clen = strlen(p);
    if (clen > length) {
      fprintf(stderr, "setStrValue: copying area is too small.\n");
      if (!member) {
        free(area); onmemStrings--; /* String */
      }
      return NULL;
    }
    strcpy(area, p);
  } else {                          /* ڡ䥿֤ޤޤƤ */
    while (p && *(p + strlen(p) - 1) != '\"') {
      clen += strlen(p) + 1;
      if (clen > length) {
        fprintf(stderr, "setStrValue: copying area is too small.\n");
        if (!member) {
          free(area); onmemStrings--; /* String */
        }
        return NULL;
      }
      strcat(area, p);
      strcat(area, " ");
      p = strtok(NULL, " \t\n");
    }
    if (!p) {
      fprintf(stderr, "setStrValue: quotation is not closed.\n");
      if (!member) {
        free(area); onmemStrings--; /* String */
      }
      return NULL;
    }
    *(p + strlen(p) - 1) = '\0';
    clen += strlen(p);
    strcat(area, p);
  }
  return area;
}

/*****************************************************************************/
/* token˴ޤޤͤᤷơưͤȤݻ롣                 */
/*   [] :ͳǼɥ쥹(value)  :NULL                          */
/*   [] value: ͤǼ륢ɥ쥹                                      */
/*          token:  ᤹٤ʸ"max=1.0" η                       */
/*****************************************************************************/
static EG_VALUE *setNumericValue(EG_VALUE *value, char *token)
{
  char *p;

  if (!token || !value) {
    fprintf(stderr, "setNumericValue: invalid argument.\n");
    return NULL;
  }
  p = index(token, '=');
  if (!p) {
    fprintf(stderr, "setNumerciValue: format error. ('=' is not found)\n");
    return NULL;
  }
  *value = atof(p + 1);
  return value;
}

/*****************************************************************************/
/* token˴ޤޤͤᤷơͤȤݻ롣                       */
/*   [] :ͳǼɥ쥹(unit)  :NULL                           */
/*   [] unit: ͤǼ륢ɥ쥹                                       */
/*          token:  ᤹٤ʸ"unit=10" η                       */
/*****************************************************************************/
static off_t *setUnit(off_t *unit, char *token)
{
  char *p;

  if (!token || !unit) {
    fprintf(stderr, "setUnit: invalid argument.\n");
    return NULL;
  }
  p = index(token, '=');
  if (!p) {
    fprintf(stderr, "setUnit: format error.('=' is not found)\n");
    return NULL;
  }
  *unit = atoi(p + 1);
  return unit;
}

/*****************************************************************************/
/* token˴ޤޤͤᤷơ2ĤͤȤݻ롣                  */
/*   [] :1  :0                                                 */
/*   [] first:  1ܤͤǼ륢ɥ쥹                              */
/*          second: 2ܤͤǼ륢ɥ쥹                              */
/*          token:  ᤹٤ʸ"range=1,1000" η                  */
/*****************************************************************************/
static int setRange(off_t *first, off_t *second, char *token)
{
  char *p;
  char *q;

  if (!token || !first || !second) {
    fprintf(stderr, "setRange: invalid argument.\n");
    return 0;
  }
  p = index(token, '=');
  if (!p) {
    fprintf(stderr, "setRange: format error. ('=' is not found)\n");
    return 0;
  }
  p++;
  q = index(p, ',');
  if (q) {
    *q = '\0';
    q++;
  }
  *first = (p) ? atoi(p) : 0;
  *second = (q) ? atoi(q) : 0;
  return 1;
}

/*****************************************************************************/
/* token˴ޤޤͤᤷơ֥ɥݥꥷͤȤݻ롣           */
/*   [] :ͳǼɥ쥹(blend)  :NULL                          */
/*   [] blend: ͤǼ륢ɥ쥹                                      */
/*          token:  ᤹٤ʸ"blend=average" η                 */
/*****************************************************************************/
static BLEND *setBlendValue(BLEND *blend, char *token)
{
  char *p;

  if (!token || !blend) {
    fprintf(stderr, "setBlendValue: invalid argument.\n");
    return NULL;
  }
  p = index(token, '=');
  if (!p) {
    fprintf(stderr, "setBlendValue: format error. ('=' is not found)\n");
    return NULL;
  }
  *blend = resolveBlend(p + 1);
  return blend;
}

/*****************************************************************************/
/* token˴ޤޤͤᤷơ顼ͤȤݻ롣                     */
/*   [] :1  :0                                                 */
/*   [] color: ͤǼΰΥɥ쥹                                */
/*          token: ᤹٤ʸ"color=255,0,99" η                 */
/*****************************************************************************/
static int setColorValue(COLOR *color, char *token)
{
  char  *red = NULL;
  char  *green = NULL;
  char  *blue = NULL;
  char  *q = NULL;

  if (!token || !color) {
    fprintf(stderr, "setColorValue: invalid argument.\n");
    return 0;
  }
  red = index(token, '=');
  if (!red) {
    fprintf(stderr, "setColorValue: format error. ('=' not found)\n");
    return 0;
  }
  red++;                         /*******************************************/
  q = index(red, ',');           /*   color=255,0,128                       */
  if (q) {                       /*         ^   ^ ^                         */
    *q = '\0';                   /*         r   g b                         */
    green = q + 1;               /*                                         */
    q = index(green, ',');       /*    (',''\0'֤)              */
    if (q) {                     /*******************************************/
      *q = '\0';
      blue = q + 1;
    }
  }
  color->red = (red) ? atoi(red) : 0;
  color->green = (green) ? atoi(green) : 0;
  color->blue = (blue) ? atoi(blue) : 0;
  return 1;
}

/*****************************************************************************/
/* token˴ޤޤͤᤷơ顼ͤȤݻ롣               */
/*   [] :ͳǼɥ쥹(colors)  :NULL                         */
/*   [] color: ͤǼΰΥɥ쥹                                */
/*          token: ᤹٤ʸ"colors=(255,0,99),(0,100,100)" η  */
/*****************************************************************************/
static COLOR *setColorValues(COLOR **colors, int *num,
                             int startpos, int endpos, int unit, char *token)
{
  char  *start;
  char  *p;
  char  *q;
  int   tnum = 0;
  COLOR *area;
  COLOR *color;
  char  *red = NULL;
  char  *green = NULL;
  char  *blue = NULL;
  char  tmp[128];
  int   offset;

  if (!token) {
    fprintf(stderr, "setColorValues: invalid argument.\n");
    return NULL;
  }

  /* tokenƤ: colors=(255,0,0),(100,100,0),(0,255,100) */
  start = index(token, '=');
  if (!start) {
    fprintf(stderr, "setColorValues: format error. ('=' not found)\n");
    return NULL;
  }

  /* Ŀο夲ȥ */
  p = start + 1;
  while ((q = index(p, ')')) != NULL) {
    tnum++;
    p = q + 1;
  }
  area = (COLOR *)calloc(tnum, sizeof(COLOR));
  if (!area) {
    fprintf(stderr, "setColorValues: memory allocation error.\n");
    return NULL;
  }
  onmemColors++;

  color = area;
  offset = startpos;
  p = start + 1;  /* pǽκ'('ΰ֤˥å */
  while (p) {
//printf("p={%s}\n", p);
    q = index(p, ')');
    if (!q) {
      fprintf(stderr, "setColorValues: format error. (breath is not closed)\n");
      free(area); onmemStrings--; /* String */
      return NULL;
    }
    strncpy(tmp, p + 1, q - p - 1);   /* ʬ򥳥ԡ */
    tmp[q - p - 1] = '\0';
//printf("tmp={%s} q=%p, p=%p\n", tmp, q, p);
    red = tmp;
    green = index(tmp, ',');
    if (!green) {
      fprintf(stderr, "setColorValues: format error.\n");
      free(area); onmemStrings--; /* String */
      return NULL;
    }
    *green = '\0';
    green++;
    blue = index(green, ',');
    if (!blue) {
      fprintf(stderr, "setColorValues: format errorl.\n");
      free(area); onmemStrings--; /* String */
      return NULL;
    }
    *blue = '\0';
    blue++;
//printf("red:{%s}, green:{%s}, blue:{%s}\n", red, green, blue);
    color->red = (red) ? atoi(red) : 0;
    color->green = (green) ? atoi(green) : 0;
    color->blue = (blue) ? atoi(blue) : 0;
    color->start = offset;
    color->end = offset + unit - 1;
    offset += unit;
    red = green = blue = NULL;
//    memset(tmp, 0, 128);
    color++;
    p = index(q + 1, '(');
  }
  if (offset - 1 != endpos) {
    fprintf(stderr, "!! There is a mismatch between color unit and start/end.\n");
    fprintf(stderr, "  ( whole range is [%d,%d], but last color unit is [%d,%d] )\n",
                    startpos, endpos, offset - unit, offset - 1);
  }
  *colors = area;
  *num = tnum;
  return area;
}

/*****************************************************************************/
/* token˴ޤޤͤᤷơͤȤݻ롣               */
/*   [] :ͳǼɥ쥹(*values)  :NULL                        */
/*   [] values: ͤǼƬؤѿΥɥ쥹               */
/*          num:    ᤷͤθĿǼΰΥɥ쥹           */
/*          token:  ᤹٤ʸ"nums=1,1.2,3.14,0,1" η           */
/*****************************************************************************/
static EG_VALUE *setGraphValues(EG_VALUE **rvalues, int *num, char *token)
{
  char *start;
  char *p;
  char *q;
  int  tnum = 0;
  EG_VALUE *area;
  EG_VALUE *vpos;
/*
  char tmp1[16];
  char tmp2[16];
  int  tmplen;
*/

  if (!token) {
    fprintf(stderr, "setGraphValues: invalid argument.\n");
    return NULL;
  }

  /*  tokenƤ: nums=99,9,99.0,999.0  */
  start = index(token, '=');
  if (!start) {
    fprintf(stderr, "setGraphValues: format error. ('=' not found)\n");
    return NULL;
  }

  /* Ŀο夲ȥ */
/*
tmplen = strlen(token);
strncpy(tmp1, token, 15); tmp1[15] = '\0';
strncpy(tmp2, token + tmplen - 15, 15); tmp2[15] = '\0';
fprintf(stderr, "@@ token length: %d, [%s ... %s]\n", tmplen, tmp1, tmp2);
*/
  p = start + 1;
  while ((q = index(p, ',')) != NULL) {
    tnum++;
    p = q + 1;
  }
  tnum++;
  area = (EG_VALUE *)calloc(tnum, sizeof(EG_VALUE));
  if (!area) {
    fprintf(stderr, "setGraphValues: memory allocation error.\n");
    return NULL;
  }
  onmemValues++;

  vpos = area;
  p = start + 1;
  while (p) {
    q = index(p, ',');
    if (q)
      *q = '\0';
    *vpos = atof(p);
    vpos++;
    p = (q) ? q + 1 : NULL;
  }
  *num = tnum;
  *rvalues = area;
//fprintf(stderr, "@@ found %d entries, copied from addr=%p to vpos=%p (%d bytes)\n", tnum, *rvalues, vpos, (vpos - area) * sizeof(EG_VALUE));
  return *rvalues;
}

/*****************************************************************************/
/* token˴ޤޤͤᤷơɲ°¤ΤȤݻ롣         */
/*   [] :ͳǼɥ쥹(*optattrs)  :NULL                      */
/*   [] optattrs: ɲ°ǼƬؤѿΥɥ쥹       */
/*          num:      ᤷɲ°θĿǼΰΥɥ쥹         */
/*          size:     ɲ°γǼѤ˳ݤΰΥ(¤ΤθĿ)   */
/*          token:    ᤹٤ʸ"name=value" η                  */
/*****************************************************************************/
static OPTATTR *addOptAttr(OPTATTR **optattrs, int *num, int *size, char *token)
{
  OPTATTR *curopt;
  char *p;

  if (!token || !num || !size || !optattrs) {
    fprintf(stderr, "addOptAttr: invalid argument.\n");
    return NULL;
  }
  p = index(token, '=');
  if (!p) {
    fprintf(stderr, "addOptAttr: format error. ('=' is not found)\n");
    return NULL;
  }
  if (!*optattrs) {
    *size = DEFAULT_OPT_ATTR_NUM;
    *optattrs = (OPTATTR *)calloc(*size, sizeof(OPTATTR));
    if (!*optattrs) {
      fprintf(stderr, "addOptAttr: memory allocation error.\n");
      *size = 0;
      return NULL;
    }
    onmemOptAttrs++;
  } else if (*size == 0 || *size == *num) {
    *size += DEFAULT_OPT_ATTR_NUM;
    *optattrs = (OPTATTR *)realloc(*optattrs, *size);
    if (!*optattrs) {
      fprintf(stderr, "addOptAttr: memory reallocation error.\n");
      *size = 0;
      return NULL;
    }
    onmemOptAttrs++;
  }
  curopt = *optattrs;
  curopt += *num;
  *p = '\0';
  strcpy(curopt->name, token);
  strcpy(curopt->value, p + 1);
  (*num)++;
  return curopt;
}

/*****************************************************************************/
/* EasyGeneTrack1ܤᤷƻι¤Τ˳Ǽ                      */
/*  [] : ݤ¤ΤΥɥ쥹, : NULL                      */
/*  []   line : ԤؤΥݥ                                           */
/*****************************************************************************/
EasyGeneTrack *parse_geneTrack_line(char *line)
{
  EasyGeneTrack *genetrack;

  if (line == NULL) {
    fprintf(stderr, "parse_geneTrack_line: invalid argument.\n");
    return NULL;
  }
  genetrack = (EasyGeneTrack *)malloc(sizeof(EasyGeneTrack));
  if (!genetrack) {
    fprintf(stderr, "parse_geneTrack_line: memory allocation error.\n");
    return NULL;
  }
  onmemEGeneTrackNum++;

  return genetrack;
}

/*****************************************************************************/
/* EasyGraphTrack1ܤᤷƻι¤Τ˳Ǽ                     */
/*  [] : ݤ¤ΤΥɥ쥹, : NULL                      */
/*  []   line : ԤؤΥݥ                                           */
/*****************************************************************************/
EasyGraphTrack *parse_graphTrack_line(char *line)
{
  EasyGraphTrack *graphtrack;
  char *p;
  int  attrcheck = 0;  /* 1:graphTrack, 2:name, 4:species, 8:revision */

  if (line == NULL) {
    fprintf(stderr, "parse_graphTrack_line: invalid argument.\n");
    return NULL;
  }
  graphtrack = (EasyGraphTrack *)malloc(sizeof(EasyGraphTrack));
  if (!graphtrack) {
    fprintf(stderr, "parse_graphTrack_line: memory allocation error.\n");
    return NULL;
  }
  onmemEGraphTrackNum++;

  // ե饰
  graphtrack->color.red = -1;

  p = strtok(line, " \t\n");
  while (p) {
    if (*p == '#') {
      break;
    } else if (strcmp(p, "graphTrack") == 0) {
      graphtrack->ettype = et_graphTrack;
      attrcheck += 1;
    } else if (strncmp(p, "name=", 5) == 0) {
      if (setStrValue(graphtrack->name, NAME_MAX_LEN, p)) {
        attrcheck += 2;
      }
    } else if (strncmp(p, "species=", 8) == 0) {
      if (setStrValue(graphtrack->species, NAME_MAX_LEN, p)) {
        attrcheck += 4;
      }
    } else if (strncmp(p, "revision=", 9) == 0) {
      if (setStrValue(graphtrack->revision, NAME_MAX_LEN, p)) {
        attrcheck += 8;
      }
    } else if (strncmp(p, "comment=", 8) == 0) {
      setStrValue(graphtrack->comment, COMMENT_MAX_LEN, p);
    } else if (strncmp(p, "description_url=", 16) == 0) {
      setStrValue(graphtrack->desc_url, URL_MAX_LEN, p);
    } else if (strncmp(p, "color=", 6) == 0) {
      setColorValue(&graphtrack->color, p);
    } else if (strncmp(p, "species_url=", 12) == 0) {
      setStrValue(graphtrack->species_url, URL_MAX_LEN, p);
    } else if (strncmp(p, "max=", 4) == 0) {
      setNumericValue(&graphtrack->max, p);
    } else if (strncmp(p, "min=", 4) == 0) {
      setNumericValue(&graphtrack->min, p);
    } else if (strncmp(p, "blend=", 6) == 0) {
      setBlendValue(&graphtrack->blend, p);
    } else if (strncmp(p, "date=", 5) == 0) {
      setStrValue(graphtrack->date, DATE_LEN, p);
    } else if (strncmp(p, "optattr=", 8) == 0) {
      setStrValue(graphtrack->optattr, ATTR_VALUE_MAX_LEN, p);
    } else {
      p = index(p, '=');
    }
    p = strtok(NULL, " \t\n");
  }
  return graphtrack;
}

/*****************************************************************************/
/* EasyColorTrack1ܤᤷƻι¤Τ˳Ǽ                     */
/*  [] : ݤ¤ΤΥɥ쥹, : NULL                      */
/*  []   line : ԤؤΥݥ                                           */
/*****************************************************************************/
EasyColorTrack *parse_colorTrack_line(char *line)
{
  EasyColorTrack *colortrack;
  char *p;
  int attrcheck = 0;  /* 1:colorTrack, 2:name, 4:species, 8:revision */

  if (line == NULL) {
    fprintf(stderr, "parse_colorTrack_line: invalid argument.\n");
    return NULL;
  }
  colortrack = (EasyColorTrack *)malloc(sizeof(EasyColorTrack));
  if (!colortrack) {
    fprintf(stderr, "parse_colorTrack_line: memory allocation error.\n");
    return NULL;
  }
  onmemEColorTrackNum++;

  p = strtok(line, " \t\n");
  while (p) {
    if (*p == '#') {
      break;
    } else if (strcmp(p, "colorTrack") == 0) {
      colortrack->ettype = et_colorTrack;
      attrcheck += 1;
    } else if (strncmp(p, "name=", 5) == 0) {
      if (setStrValue(colortrack->name, NAME_MAX_LEN, p)) {
        attrcheck += 2;
      }
    } else if (strncmp(p, "species=", 8) == 0) {
      if (setStrValue(colortrack->species, NAME_MAX_LEN, p)) {
        attrcheck += 4;
      }
    } else if (strncmp(p, "revision=", 9) == 0) {
      if (setStrValue(colortrack->revision, NAME_MAX_LEN, p)) {
        attrcheck += 8;
      }
    } else if (strncmp(p, "comment=", 8) == 0) {
      setStrValue(colortrack->comment, COMMENT_MAX_LEN, p);
    } else if (strncmp(p, "description_url=", 16) == 0) {
      setStrValue(colortrack->desc_url, URL_MAX_LEN, p);
    } else if (strncmp(p, "species_url=", 12) == 0) {
      setStrValue(colortrack->species_url, URL_MAX_LEN, p);
    } else if (strncmp(p, "blend=", 6) == 0) {
      setBlendValue(&colortrack->blend, p);
    } else if (strncmp(p, "date=", 5) == 0) {
      setStrValue(colortrack->date, DATE_LEN, p);
    } else if (strncmp(p, "optattr=", 8) == 0) {
      setStrValue(colortrack->optattr, ATTR_VALUE_MAX_LEN, p);
    } else {
      p = index(p, '=');
    }
    p = strtok(NULL, " \t\n");
  }
  return colortrack;
}

/*****************************************************************************/
/* EasyGeneTrackgeneܤᤷƻι¤Τ˳Ǽ                   */
/*  [] : ݤ¤ΤΥɥ쥹, : NULL                      */
/*  []   line : ԤؤΥݥ                                           */
/*****************************************************************************/
EasyGene *parse_gene_line(char *line)
{
  EasyGene *easygene;

  easygene = (EasyGene *)malloc(sizeof(EasyGene));
  if (!easygene) {
    fprintf(stderr, "parse_gene_line: memory allocation error.\n");
    return NULL;
  }
  onmemEGeneNum++;
  memset(easygene, 0, sizeof(EasyGene));
  return easygene;
}

/*****************************************************************************/
/* EasyGraphTrackgraphܤᤷƻι¤Τ˳Ǽ                 */
/*  [] : ݤ¤ΤΥɥ쥹, : NULL                      */
/*  []   line : ԤؤΥݥ                                           */
/*****************************************************************************/
EasyGraph *parse_graph_line(char *line)
{
  EasyGraph *easygraph;
  char *p;

  easygraph = (EasyGraph *)malloc(sizeof(EasyGraph));
  if (!easygraph) {
    fprintf(stderr, "parse_graph_line: memory allocation error.\n");
    return NULL;
  }
  onmemEGraphNum++;
  memset(easygraph, 0, sizeof(EasyGraph));

  p = strtok(line, " \t\n");
  while (p) {
    if (*p == '#') {
      break;
    } else if (strncmp(p, "graph", 5) == 0) {
      ;
    } else if (strncmp(p , "target=", 7) == 0) {
      setStrValue(easygraph->target, NAME_MAX_LEN, p);
    } else if (strncmp(p, "range=", 6) == 0) {
      setRange(&easygraph->start, &easygraph->end, p);
    } else if (strncmp(p, "unit=", 5) == 0) {
      setUnit(&easygraph->unit, p);
    } else if (strncmp(p, "nums=", 5) == 0) {
      setGraphValues(&easygraph->values, &easygraph->valuenum, p);
    } else if (strncmp(p, "url=", 4) == 0) {
      setStrValue(easygraph->url, URL_MAX_LEN, p);
    } else if (strncmp(p, "color=", 5) == 0) {
      //setColorValue(&easygraph->color, p);
      ;
    } else {
      //addOptAttr(&easygraph->optattrs, &easygraph->optnum,
      //           &easygraph->optareanum, p);
      ;
    }
    p = strtok(NULL, " \t\n");
  }
  return easygraph;
}

/*****************************************************************************/
/* EasyColorTrackcolorܤᤷƻι¤Τ˳Ǽ                 */
/*  [] : ݤ¤ΤΥɥ쥹, : NULL                      */
/*  []   line : ԤؤΥݥ                                           */
/*****************************************************************************/
EasyColor *parse_color_line(char *line)
{
  EasyColor *easycolor;
  char *p;

  easycolor = (EasyColor *)malloc(sizeof(EasyColor));
  if (!easycolor) {
    fprintf(stderr, "parse_color_line: memory allocation error.\n");
    return NULL;
  }
  onmemEColorNum++;
  memset(easycolor, 0, sizeof(EasyColor));

  p = strtok(line, " \t\n");
  while (p) {
    if (*p == '#') {
      break;
    } else if (strncmp(p, "target=", 7) == 0) {
      setStrValue(easycolor->target, NAME_MAX_LEN, p);
    } else if (strncmp(p, "range=", 6) == 0) {
      setRange(&easycolor->start, &easycolor->end, p);
    } else if (strncmp(p, "unit=", 5) == 0) {
      setUnit(&easycolor->unit, p);
    } else if (strncmp(p, "colors=", 7) == 0) {
      setColorValues(&easycolor->colors, &easycolor->colornum,
                     (int)easycolor->start, (int)easycolor->end,
                     (int)easycolor->unit, p);
    } else if (strncmp(p, "url=", 4) == 0) {
      setStrValue(easycolor->url, URL_MAX_LEN, p);
    } else if (strncmp(p, "color", 5) == 0) {
      ;
    } else {
      addOptAttr(&easycolor->optattrs, &easycolor->optnum,
                 &easycolor->optareanum, p);
    }
    p = strtok(NULL, " \t\n");
  }
  return easycolor;
}

/*****************************************************************************/
/* Ϳ줿ʸ󤬡ưɽƤ뤫å롣            */
/*  [] : 1   : 0                                               */
/*  :    [][][.][e[][]] ηʤ           */
/*  ) : 1, 0.1, -1, .2, 1e-1ʤ  : 0x01, a01, abc, 1e0.1ʤ      */
/*****************************************************************************/
int isfloat(char *str)
{
  int  ret = 1;
  char *p;
  char *ep = NULL;  /* 'e'ΰ֤򼨤ݥ        */
  char *fp = NULL;  /* Ǹΰ֤򼨤ݥ */
  char *pp = NULL;  /* ΰ֤򼨤ݥ     */
  char *dp = NULL;  /* Ǹοΰ֤ɽݥ */

  p = str;
  while (p && *p != '\0') {
    switch (*p) {
    case '+':
    case '-':
      if (fp && !ep) return 0;              /* ¿2ܤ椬褿 */
      if (p != str && p != ep + 1) return 0;    /* Ƭ'e'ľʳ褿 */
      fp = p;
      break;
    case '.':
      if (pp) return 0;  /* 2ܤξ */
      if (ep) return 0;  /* ˾褿 */
      pp = p;
      break;
    case 'e':
    case 'E':
      if (ep) return 0;  /* 2ܤ'e'ޤ'E' */
      ep = p;
      break;
    default:
      if (!isdigit(*p)) return 0; /* ʳ */
      dp = p;
    }
    p++;
  }
  if (!dp) return 0;    /* 1Ĥ̵ */
  return ret;
}

