#ifndef _EASYGRAPH_H_
#define _EASYGRAPH_H_

#include "etcache.h"

typedef struct t_easygraph {
  char      target[NAME_MAX_LEN + 1];
  off_t     start;
  off_t     end;
  off_t     unit;
  int       valuenum;
  EG_VALUE  *values;
  char      url[URL_MAX_LEN + 1];
  char      filename[PATH_MAX_LEN + 1];
  COLOR     color;
  int       optnum;
  int       optareanum;
  OPTATTR   *optattrs;
} EasyGraph;

typedef struct t_easygraphtrack {
  ET_TYPE   ettype;
  char      name[NAME_MAX_LEN + 1];
  char      comment[COMMENT_MAX_LEN + 1];
  char      desc_url[URL_MAX_LEN + 1];
  COLOR     color;
  char      species[NAME_MAX_LEN + 1];
  char      revision[NAME_MAX_LEN + 1];
  char      species_url[URL_MAX_LEN + 1];
  EG_VALUE  max;
  EG_VALUE  min;
  BLEND     blend;
  int       graphnum;
  int       graphareanum;
  EasyGraph **graphs;
  char      date[DATE_LEN + 1];
  char      optattr[ATTR_VALUE_MAX_LEN + 1];
} EasyGraphTrack;

void dumpEasyGraph(FILE *, EasyGraph *);
void dumpEasyGraphTrack(FILE *, EasyGraphTrack *);

void printEasyGraph(FILE *, EasyGraph *);
void printEasyGraphTrackHeader(FILE *, EasyGraphTrack *);
void printEasyGraphTrack(FILE *, EasyGraphTrack *);

void clearEasyGraph(EasyGraph *);
void clearEasyGraphTrack(EasyGraphTrack *);
void destroyEasyGraph(EasyGraph **);
void destroyEasyGraphTrack(EasyGraphTrack **);

EG_VALUE *getValues(char *filename, off_t, off_t);

int outputGraphCache(EasyGraphTrack *, char *, off_t, off_t, int, BLEND);
int addGraphToTrack(EasyGraphTrack *, EasyGraph *);
int writeGraphValues(EasyGraphTrack *);
int writeGraphValue(EasyGraph *, char *path);
int regularizeGraphData(EasyGraphTrack *);

#endif
