#ifndef _EASYGENE_H_
#define _EASYGENE_H_

#include "etcache.h"

typedef struct t_exon {
  off_t   start;
  off_t   end;
} EXON;

typedef struct t_easygene {
  char      target[NAME_MAX_LEN + 1];
  off_t     start;
  off_t     end;
  char      name[NAME_MAX_LEN + 1];
  char      url[URL_MAX_LEN + 1];
  char      strand;
  int       exonnum;
  EXON      *exons;
  int       optnum;
  OPTATTR   *optattrs;
} EasyGene;

typedef struct t_easygenetrack {
  ET_TYPE   ettype;
  char      name[NAME_MAX_LEN + 1];
  char      comment[COMMENT_MAX_LEN + 1];
  char      desc_url[URL_MAX_LEN + 1];
  COLOR     color;
  char      species[NAME_MAX_LEN + 1];
  char      revision[NAME_MAX_LEN + 1];
  char      species_url[URL_MAX_LEN + 1];
  int       genenum;
  EasyGene  *genes;
  char      date[DATE_LEN + 1];
  char      opt_attr[ATTR_VALUE_MAX_LEN + 1];
} EasyGeneTrack;

/* ҾޤEasyGeneTrack/EasyGraphTrackϤ롣 */
/*   1: (EasyGeneTrack)                                     */
/*         2: (EasyGraphTrack)                                    */
/*         0:                                                           */
/*   ꤵ줿ȥ꡼EasyGeneTrack/EasyGraphTrack񤭽Ф     */
// DB ѹб
int getEasyGeneOrGraphTrack(char *, /* trackname: ɽ٤EasyTrack̾ */
                            char *, /* species:   ɽ٤              */
                            char *, /* revision:  ɽ٤Υӥ  */
                            char *, /* target:    ɽ٤о            */
                            int,    /* start:     ɽϰ(0-origin)    */
                            int,    /* end:       ɽλ(0-origin)    */
                            int,    /* width:     Ϥ٤λɸ    */
                            char *, /* date:      EasyTrackκ       */
                            char *, /* stream: 襹ȥ꡼(ե)̾ */
                            int,    /* threshold: EasyGraphTrackؤ */
                            int,    /* ɲ°SelectǸ */
                            char *, /* : ɲ°Select̾   */
                            char *, /* : ɲ°Select     */
                            int,    /* :   ɲ°RealǸ  */
                            char *, /* : ɲ°Real̾        */
                            double,    /* optRealLower: ɲ°Realǲ      */
                            double     /* optRealUpper: ɲ°Realξ      */
);

#endif
