#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/times.h>
#include <time.h>
#include <string.h> 

#include "libpq-fe.h" // PostgreSQL

#include "etcache.h"
#include "easygene.h"

static void
exit_nicely(PGconn *conn)
{
  PQfinish(conn);
  exit(1);
}

/* ҾޤEasyGeneTrack/EasyGraphTrackϤ롣 */
/*   1: (EasyGeneTrack)                                     */
/*         2: (EasyGraphTrack)                                    */
/*         0:                                                           */
/*   ꤵ줿ȥ꡼EasyGeneTrack/EasyGraphTrack񤭽Ф     */
int getEasyGeneOrGraphTrack
( char *trackname,   /* ɽ٤EasyTrack̾   */
  char *species,     /* ɽ٤                    */
  char *revision,    /* ɽ٤Υӥ        */
  char *target,      /* ɽ٤о                  */
  int  start,        /* ɽϰ(0-origin)          */
  int  end,          /* ɽλ(0-origin)          */
  int  width,        /* Ϥ٤λɸ          */
  char *date,        /* ɽ٤EasyTrackκ   */
  char *stream,      /* 襹ȥ꡼(ե)̾    */
  int  gene_threshold,      /* EasyGraphTrackؤ    */
  int bUseOptSelect,     /* ɲ°SelectǸ */
  char *strOptSelect,     /* : ɲ°Select̾   */
  char *strOptSelectEle,  /* : ɲ°Select     */
  int bUseOptReal,    /* :   ɲ°RealǸ  */
  char *strOptReal,    /* : ɲ°Real̾        */
  double optRealLower,    /* : ɲ°Realǲ      */
  double optRealUpper     /* : ɲ°Realξ      */
  )
{
  PGconn      *conn;
  PGresult    *res;
  PGresult    *resTrack;
  PGresult    *resGene;
  PGresult    *resTemp;

  char        strConnectInfo[1024];
  char        sql[1024];
  int         nTuples;
  int         nFields;
  int         i, j;
  int         start_temp, end_temp;

  FILE        *fp;
  int         *pGraph;
  int         gene_start, gene_end, gene_temp, gene_start_pos, gene_end_pos;
  int         returnValue = -1;

  clock_t t1, t2;
  struct tms ts1, ts2;
  float dtr, dtu, dts;

  int hitGeneID;
  int nHitGenesNum;
  int nOptSelectNameID = -1;
  int nOptRealNameID = -1;
  double nOptTempValue = -1;
  char* strTemp;

  fprintf(stderr, "-------------- \n");
  fprintf(stderr, "DB connect time \n");
  t1=times(&ts1); /* DB³ϻμ */ 
  
  // DB ³
//  sprintf(strConnectInfo, "dbname=cachegene_%s_%s_%s user=browser", trackname, species, revision);
  sprintf(strConnectInfo, "dbname=cachegene_%s_%s_%s user=postgres", trackname, species, revision);
  conn = PQconnectdb(&strConnectInfo[0]);
  if (PQstatus(conn) != CONNECTION_OK) {
    fprintf(stderr, "Connection to database '%s' failed.\n", PQdb(conn));
    fprintf(stderr, "%s", PQerrorMessage(conn));
    exit_nicely(conn);
  }

  // ȥ󥶥󳫻
  res = PQexec(conn, "BEGIN");
  if (PQresultStatus(res) != PGRES_COMMAND_OK) {
    fprintf(stderr, "BEGIN command failed: %s", PQerrorMessage(conn));
    PQclear(res);
    exit_nicely(conn);
  }
  PQclear(res);

  t2=times(&ts2); /* λμ */
  dtr=(float)(t2-t1) / CLK_TCK; /* ֤λ */
  dtu=(float)(ts2.tms_utime-ts1.tms_utime) / CLK_TCK; /* 桼֤λ */ 
  dts=(float)(ts2.tms_stime-ts1.tms_stime) / CLK_TCK; /* ƥ֤λ */ 
  fprintf(stderr, "Real time: %.2f\n", dtr); /* ֤ɽ */ 
  fprintf(stderr, "User time: %.2f\n", dtu); 
  fprintf(stderr, "System time: %.2f\n", dts);
  fprintf(stderr, "-------------- \n");
  
  // (start > end) ξб
  if (start <= end) {
    start_temp = start;
    end_temp = end;
  } else {
    start_temp = end;
    end_temp = start;
  }

  fprintf(stderr, "-------------- \n");
  fprintf(stderr, "DB search time \n");
  t1=times(&ts1); /* ϻμ */ 

  // TrackԤΥơ֥Υ꥽  
  sprintf(sql, "SELECT * FROM Track;");
  resTrack = PQexec(conn, sql);
  if (PQntuples(resTrack) != 1) {
    // error
    fprintf(stderr, "Could not find Track from Cache DB.\n");
    exit_nicely(conn);
  }

  // ϰΰҤ򸡺Exonϴطʤ
  // ®Τᡢɲ°θϤǤϹԤʤTargetRangeΤߡ
  sprintf(sql, "SELECT * FROM Data WHERE target=\'%s\'AND ((range_start <= %d AND %d <= range_end) OR (range_end <= %d AND %d <= range_start));", 
          target, end_temp, start_temp, end_temp, start_temp);
  resGene = PQexec(conn, sql);

  t2=times(&ts2); /* λμ */
  dtr=(float)(t2-t1) / CLK_TCK; /* ֤λ */
  dtu=(float)(ts2.tms_utime-ts1.tms_utime) / CLK_TCK; /* 桼֤λ */ 
  dts=(float)(ts2.tms_stime-ts1.tms_stime) / CLK_TCK; /* ƥ֤λ */ 
  fprintf(stderr, "Real time: %.2f\n", dtr); /* ֤ɽ */ 
  fprintf(stderr, "User time: %.2f\n", dtu); 
  fprintf(stderr, "System time: %.2f\n", dts);
  fprintf(stderr, "-------------- \n");

  nTuples = PQntuples(resGene);
  nFields = PQnfields(resGene);

  if (stream == NULL || 
      strcmp(stream, "") == 0 ||
      strcmp(stream, "stdout") == 0) {
    // ɸ
    fp = stdout;
  } else {
    fp = fopen(stream, "w");
    if (!fp) {
      fprintf(stderr, "Could not open Output stream file: %s\n", stream);
      return 0;
    }
  }

  // ɲ°
  if (bUseOptSelect == 1) {
    sprintf(sql, "SELECT * FROM OptattrSelectName WHERE select_name_str='%s'", strOptSelect);
    resTemp = PQexec(conn, sql);
    if (PQntuples(resTemp) >= 1) {
      nOptSelectNameID = atoi(PQgetvalue(resTemp, 0, PQfnumber(resTemp, "select_name_id")));
    }
    PQclear(resTemp);
  }
  if (bUseOptReal == 1) {
    sprintf(sql, "SELECT * FROM OptattrRealName WHERE real_name_str='%s'", strOptReal);
    resTemp = PQexec(conn, sql);
    if (PQntuples(resTemp) >= 1) {
      nOptRealNameID = atoi(PQgetvalue(resTemp, 0, PQfnumber(resTemp, "real_name_id")));
    }
    PQclear(resTemp);
  }

  // ɲ°ǥե륿󥰤ΰҿ׻롣
  // ®Τʣ
  nHitGenesNum = 0;
  if (bUseOptSelect != 1 && bUseOptReal != 1) {
    nHitGenesNum = nTuples;
  }
  else {
    for (i = 0; i < nTuples; i++) {
      // ID
      hitGeneID = atoi(PQgetvalue(resGene, i, PQfnumber(resGene, "data_id")));
      
      // OptSelectǥե륿
      if (bUseOptSelect == 1) {
        sprintf(sql, "SELECT * FROM OptattrDataSelect WHERE data_id=%d AND select_name_id=%d", hitGeneID, nOptSelectNameID);
        resTemp = PQexec(conn, sql);
        if (PQntuples(resTemp) < 1) {
          PQclear(resTemp);
          continue;
        }
        strTemp = PQgetvalue(resTemp, 0, PQfnumber(resTemp, "select_name"));
        PQclear(resTemp);
        if (strcmp(strOptSelectEle, strTemp) != 0) {
          continue;
        }
      }
      
      // OptRealǥե륿
      if (bUseOptReal == 1) {
        sprintf(sql, "SELECT * FROM OptattrDataReal WHERE data_id=%d AND real_name_id=%d", hitGeneID, nOptRealNameID);
        resTemp = PQexec(conn, sql);
        if (PQntuples(resTemp) < 1) {
          PQclear(resTemp);
          continue;
        }
        nOptTempValue = atof(PQgetvalue(resTemp, 0, PQfnumber(resTemp, "real_value")));
        PQclear(resTemp);
        if (nOptTempValue < optRealLower || optRealUpper < nOptTempValue) {
          continue;
        }
      }
      nHitGenesNum++;
    }
  }


  if (nHitGenesNum <= gene_threshold) {
    // EasyGeneTrack Ϥ롣
    // ̤Ǥ⡢إåԤϤ롣

    t1=times(&ts1); /* ϻμ */ 

    fprintf(fp, "geneTrack name=%s comment=\"%s\" description_url=%s color=%s,%s,%s species=\"%s\" revision=\"%s\" species_url=%s date=%s optattr=\"%s\" #%s\n",
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "track_name")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "comment")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "description_url")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "color_red")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "color_green")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "color_blue")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "species")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "revision")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "species_url")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "date")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "optattr_str")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "memo"))
      );

    PQclear(resTrack);

    // Hit
    // սǼ
    for (i = nTuples - 1; i >= 0; i--) {
      // ID
      hitGeneID = atoi(PQgetvalue(resGene, i, PQfnumber(resGene, "data_id")));
      
      // OptSelectǥե륿
      if (bUseOptSelect == 1) {
        sprintf(sql, "SELECT * FROM OptattrDataSelect WHERE data_id=%d AND select_name_id=%d", hitGeneID, nOptSelectNameID);
        resTemp = PQexec(conn, sql);
        if (PQntuples(resTemp) < 1) {
          PQclear(resTemp);
          continue;
        }
        strTemp = PQgetvalue(resTemp, 0, PQfnumber(resTemp, "select_name"));
        PQclear(resTemp);
        if (strcmp(strOptSelectEle, strTemp) != 0) {
          continue;
        }
      }
      
      // OptRealǥե륿
      if (bUseOptReal == 1) {
        sprintf(sql, "SELECT * FROM OptattrDataReal WHERE data_id=%d AND real_name_id=%d", hitGeneID, nOptRealNameID);
        resTemp = PQexec(conn, sql);
        if (PQntuples(resTemp) < 1) {
          PQclear(resTemp);
          continue;
        }
        nOptTempValue = atof(PQgetvalue(resTemp, 0, PQfnumber(resTemp, "real_value")));
        PQclear(resTemp);
        if (nOptTempValue < optRealLower || optRealUpper < nOptTempValue) {
          continue;
        }
      }
      
      // ®Τˡall_str Ѥ롣κݤϡall_str⹹뤳ȡ
      fprintf(fp, "%s\n", PQgetvalue(resGene, i, PQfnumber(resGene, "all_str")));
    }
    
    fprintf(stderr, "-------------- \n");
    fprintf(stderr, "num of hit genes : %d \n", nHitGenesNum);

    t2=times(&ts2); /* λμ */
    dtr=(float)(t2-t1) / CLK_TCK; /* ֤λ */
    dtu=(float)(ts2.tms_utime-ts1.tms_utime) / CLK_TCK; /* 桼֤λ */ 
    dts=(float)(ts2.tms_stime-ts1.tms_stime) / CLK_TCK; /* ƥ֤λ */ 
    fprintf(stderr, "-------------- \n");
    fprintf(stderr, "EasyGeneTrackFile output time \n");
    fprintf(stderr, "Real time: %.2f\n", dtr); /* ֤ɽ */ 
    fprintf(stderr, "User time: %.2f\n", dtu); 
    fprintf(stderr, "System time: %.2f\n", dts);
    fprintf(stderr, "-------------- \n");

    returnValue = 1;
  }
  // EasyGraphTrack--------------------------------------------------------------------------------
  else {
    // EasyGraphTrack Ϥ롣

    t1=times(&ts1); /* ϻμ */ 

    // 1
    // EasyGeneTrack Ƥ򤽤Τޤ޻ȤäƤ
    // max, min, blend Ͼά
    fprintf(fp, "graphTrack name=%s comment=\"%s\" description_url=%s color=%s,%s,%s species=\"%s\" revision=\"%s\" species_url=%s date=%s #%s\n",
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "track_name")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "comment")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "description_url")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "color_red")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "color_green")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "color_blue")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "species")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "revision")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "species_url")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "date")),
            //PQgetvalue(resTrack, 0, PQfnumber(resTrack, "optattr_str")),
            PQgetvalue(resTrack, 0, PQfnumber(resTrack, "memo"))
      );

    PQclear(resTrack);

    // int[width] ˡưҤϰϤбʬ򥤥󥯥
    pGraph = malloc(sizeof(int)*width);
    if (pGraph == NULL) {
      // malloc failed
      fclose(fp);
      PQclear(resGene); 
      res = PQexec(conn, "END");
      PQclear(res);
      PQfinish(conn);

      return 0;
    }
    onmemIntArrays++;

    // 
    for (i = 0; i <= width - 1; i++)
      pGraph[i] = 0;

    // Hit
    for (i = 0; i < nTuples; i++) {
      // ID
      hitGeneID = atoi(PQgetvalue(resGene, i, PQfnumber(resGene, "data_id")));
      
      // OptSelectǥե륿
      if (bUseOptSelect == 1) {
        sprintf(sql, "SELECT * FROM OptattrDataSelect WHERE data_id=%d AND select_name_id=%d", hitGeneID, nOptSelectNameID);
        resTemp = PQexec(conn, sql);
        if (PQntuples(resTemp) < 1) {
          PQclear(resTemp);
          continue;
        }
        strTemp = PQgetvalue(resTemp, 0, PQfnumber(resTemp, "select_name"));
        PQclear(resTemp);
        if (strcmp(strOptSelectEle, strTemp) != 0) {
          continue;
        }
      }
      
      // OptRealǥե륿
      if (bUseOptReal == 1) {
        sprintf(sql, "SELECT * FROM OptattrDataReal WHERE data_id=%d AND real_name_id=%d", hitGeneID, nOptRealNameID);
        resTemp = PQexec(conn, sql);
        if (PQntuples(resTemp) < 1) {
          PQclear(resTemp);
          continue;
        }
        nOptTempValue = atof(PQgetvalue(resTemp, 0, PQfnumber(resTemp, "real_value")));
        PQclear(resTemp);
        if (nOptTempValue < optRealLower || optRealUpper < nOptTempValue) {
          continue;
        }
      }
      
      // ΰơΰ֤Ѵ롣
      gene_start = atoi(PQgetvalue(resGene, i, PQfnumber(resGene, "range_start")));
      gene_end = atoi(PQgetvalue(resGene, i, PQfnumber(resGene, "range_end")));
      if (gene_start > gene_end) {
        gene_temp = gene_start;
        gene_start = gene_end;
        gene_end = gene_temp;
      }

      gene_start_pos = (width - 1) * (gene_start - start_temp)
        / (end_temp - start_temp);
      gene_end_pos = (width - 1) * (gene_end - start_temp)
        / (end_temp - start_temp);

      if (gene_start_pos < 0) {
        // Ϥ
        gene_start_pos = 0;
      } else if (gene_start_pos >= width) {
        // error
        continue;
      }

      if (gene_end_pos < 0) {
        // error
        continue;
      } else if (gene_end_pos >= width) {
        // Ϥ
        gene_end_pos = width - 1;
      }

      for (j = gene_start_pos; j <= gene_end_pos; j++ ) {
        pGraph[j]++;
      }
    }

    // ԤΤߡtarget ϡܤΤΤѡ
    fprintf(fp, "graph target=%s range=%d,%d unit=%d nums=",
            PQgetvalue(resGene, 0, PQfnumber(resGene, "target")),
            start, end, abs(end - start) / width);
    for (j = 0; j < width - 1; j++) {
      fprintf(fp, "%d,", pGraph[j]);
    }
    fprintf(fp, "%d\n", pGraph[width - 1]);

    free(pGraph);
    onmemIntArrays--;

    fprintf(stderr, "-------------- \n");
    fprintf(stderr, "num of hit genes : %d \n", nHitGenesNum);
    
    t2=times(&ts2); /* λμ */
    dtr=(float)(t2-t1) / CLK_TCK; /* ֤λ */
    dtu=(float)(ts2.tms_utime-ts1.tms_utime) / CLK_TCK; /* 桼֤λ */ 
    dts=(float)(ts2.tms_stime-ts1.tms_stime) / CLK_TCK; /* ƥ֤λ */ 
    fprintf(stderr, "-------------- \n");
    fprintf(stderr, "EasyGraphTrackFile output time \n");
    fprintf(stderr, "Real time: %.2f\n", dtr); /* ֤ɽ */ 
    fprintf(stderr, "User time: %.2f\n", dtu); 
    fprintf(stderr, "System time: %.2f\n", dts);
    fprintf(stderr, "-------------- \n");

    returnValue = 2;
  }

  fclose(fp);
  PQclear(resGene); 

  /* end the transaction */
  res = PQexec(conn, "END");
  PQclear(res);

  /* close the connection to the database and cleanup */
  PQfinish(conn);

  return returnValue;
}

