#ifndef _EASYCOLOR_H_
#define _EASYCOLOR_H_

#include "etcache.h"

typedef struct t_easycolor {
  char     target[NAME_MAX_LEN + 1];
  off_t    start;
  off_t    end;
  off_t    unit;
  int      colornum;
  COLOR    *colors;
  char     url[URL_MAX_LEN + 1];
  int      optnum;
  int      optareanum;
  OPTATTR  *optattrs;
} EasyColor;

typedef struct t_easycolortrack {
  ET_TYPE   ettype;
  char      name[NAME_MAX_LEN + 1];
  char      comment[COMMENT_MAX_LEN + 1];
  char      desc_url[URL_MAX_LEN + 1];
  COLOR     backcolor;
  char      species[NAME_MAX_LEN + 1];
  char      revision[NAME_MAX_LEN + 1];
  char      species_url[URL_MAX_LEN + 1];
  BLEND     blend;
  int       colornum;
  int       colorareanum;
  EasyColor *easycolors;
  char      date[DATE_LEN + 1];
  char      optattr[ATTR_VALUE_MAX_LEN + 1];
} EasyColorTrack;

void dumpEasyColor(FILE *, EasyColor *);
void dumpEasyColorTrack(FILE *, EasyColorTrack *);
//void printColorStatus(EasyColorTrack *, ssize_t, off_t, off_t, off_t, ssize_t, BLEND);

int ec_setTarget(EasyColor *, char *);

void printEasyColor(FILE *, EasyColor *);
void printEasyColorTrack(FILE *, EasyColorTrack *);
void printEasyColorTrackHeader(FILE *, EasyColorTrack *);

void clearEasyColor(EasyColor *);
void clearEasyColorTrack(EasyColorTrack *);
void destroyEasyColor(EasyColor **);
void destroyEasyColorTrack(EasyColorTrack **);

COLOR *getColors(char *filename, off_t, off_t);
void destroyColors(COLOR *buf);

int outputColorCache(EasyColorTrack *, char *, off_t, off_t, int, BLEND);
int addColorToTrack(EasyColorTrack *, EasyColor *);
int regularizeColor(EasyColorTrack *);

#endif
