#ifndef _EASY_TRACK_CACHE_H_
#define _EASY_TRACK_CACHE_H_

#include "etcache.h"

/* EasyTrackCacheƥѲǽˤ롣                                 */
/*   0:  1:                                                   */
/*   ǡ١³롣³Ƥϲ⤷ʤ       */
int initEasyTrackCache();

/* EasyTrackCacheƥλѤλ롣                                 */
/*   ǡ١Ȥ³ڤ롣                                     */
void termEasyTrackCache();

/* EasyGeneTrackϤ٤ΰҿꤹ롣                      */
/* getGeneDataƤӽФˡͤĶưҤҥåȤ      */
/* EasygGraphTrackϤ롣                                              */
/*   0: ,  0ʳ: (ºݤꤷ֤)                    */
int setMaxNumberOfGene(int);  /* ꤹҿ */

/* EasyGeneTrackϤ٤ҿθߤͤ롣                  */
int getMaxNumberOfGene();

/* EasyGraphTrackϤȤΥǡ̾ˡ(blend)ꤹ롣          */
/*   0: , 1:                                                  */
/*   ǥեȤblendͤѹ                                  */
int setGraphBlendPolicy(char *); /* ǡ̾ˡ{average, mode, min, max} */

/* EasyGraphTrackθߤΥǡ̾ˡ(blend)롣                      */
/*   0:NONE, 1:average, 2:mode, 3:min, 4:max                          */
int getGraphBlendPolicy();

/* EasyColorTrackϤȤΥǡ̾ˡ(blend)ꤹ롣          */
/*   0: , 1:                                                  */
/*   ǥեȤblendͤѹ                                  */
int setColorBlendPolicy(char *); /* ǡ̾ˡ{average, mode}           */

/* EasyColorTrackθߤΥǡ̾ˡ(blend)롣                      */
/*   0:NONE, 1:average, 2:mode                                        */
int getColorBlendPolicy();

/* ҾޤEasyGeneTrack/EasyGraphTrackϤ롣 */
/*   1: (EasyGeneTrack)                                     */
/*         2: (EasyGraphTrack)                                    */
/*         0:                                                           */
/*   ꤵ줿ȥ꡼EasyGeneTrack/EasyGraphTrack񤭽Ф     */
int getGeneData(char *,    /* trackname: ɽ٤EasyTrack̾   */
                char *,    /* species:   ɽ٤                    */
                char *,    /* revision:  ɽ٤Υӥ        */
                char *,    /* target:    ɽ٤о                  */
                int,       /* start:     ɽϰ(0-origin)          */
                int,       /* end:       ɽλ(0-origin)          */
                int,       /* width:     Ϥ٤λɸ          */
                char *,    /* date:      ɽ٤EasyTrackκ   */
                char *,    /* stream:    襹ȥ꡼(ե)̾    */
                int,       /* threshold: EasyGraphTrackڤؤҿ */
		int,       /* bUseOptSelect: ɲ°SelectǸ */
		char *,    /* strOptSelect: ɲ°Select̾      */
		char *,    /* strOptSelectEle: ɲ°Select     */
		int,       /* bUseOptReal:   ɲ°RealǸ   */
		char *,    /* strOptReal: ɲ°Real̾          */
		double,    /* optRealLower: ɲ°Realǲ      */
		double     /* optRealUpper: ɲ°Realξ      */
);

/* ϰϤΥǡޤEasyGraphTrackϤ롣                         */
/*   1: , 0:                                                  */
/*   ꤵ줿ȥ꡼EasyGraphTrack񤭽Ф                   */
int getGraphData(char *,    /* trackname: ɽ٤EasyTrack̾   */
                 char *,    /* species:   ɽ٤                    */
                 char *,    /* revision:  ɽ٤Υӥ        */
                 char *,    /* target:    ɽ٤о                  */
                 int,       /* start:     ɽϰ(0-origin)          */
                 int,       /* end:       ɽλ(0-origin)          */
                 int,       /* width:     Ϥ٤λɸ          */
                 char *,    /* date:      ɽ٤EasyTrackκ   */
                 char *,    /* blendname: ֥ˡλ              */
                 char *);   /* stream:    襹ȥ꡼(ե)̾    */

/* ϰϤΥǡޤEasyColorTrackϤ롣                         */
/*   1: , 0:                                                  */
/*   ꤵ줿ȥ꡼EasyColorTrack񤭽Ф                   */
int getColorData(char *,    /* trackname: ɽ٤EasyTrack̾   */
                 char *,    /* species:   ɽ٤                    */
                 char *,    /* revision:  ɽ٤Υӥ        */
                 char *,    /* target:    ɽ٤о                  */
                 int,       /* start:     ɽϰ(0-origin)          */
                 int,       /* end:       ɽλ(0-origin)          */
                 int,       /* width:     Ϥ٤λɸ          */
                 char *,    /* date:      ɽ٤EasyTrackκ   */
                 char *,    /* blendname: ֥ˡλ              */
                 char *);   /* stream:    襹ȥ꡼(ե)̾    */

/* DB˳ǼƤҥǡCacheե           */
/*   1: , 0:                                                 */
/*   "graphvalue.dat"ե򹹿                              */
int createGraphCacheFile(char *,  /* dbname: ǡǼ줿DB̾ */
                         char *,  /* species: ʪ */
                         char *,  /* revision */
                         char *,  /* target */
                         char *); /* ϥե̾ */

/* EasyTrackեꤷơƤǡ١Ͽ */
/*   1:, 0:                                        */
int addEasyTrack(char *); /* ɲäEasyTrackեΥѥ̾ */

#endif
