#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <string.h>
#include "etcache.h"
#include "blend.h"
#include "accesscache.h"
#include "easygene.h"
#include "easygraph.h"
#include "easycolor.h"
#include "easyTrackCache.h"
#include "et_parser.h"

/* EasyTrackCacheƥѲǽˤ롣                                 */
/*   0:  1:                                                   */
/*   ǡ١³롣³Ƥϲ⤷ʤ       */
int initEasyTrackCache()
{
  /* ǡ󲽤ɬפʴؿstatic linkǤǤϲ⤷ʤ */
  return 1;
}

/* EasyTrackCacheƥλѤλ롣                                 */
/*   ǡ١Ȥ³ڤ롣                                     */
void termEasyTrackCache()
{
  /* ǡ󲽤ɬפʴؿstatic linkǤǤϲ⤷ʤ */
}

/* EasyGeneTrackϤ٤ΰҿꤹ롣                      */
/* getGeneDataƤӽФˡͤĶưҤҥåȤ      */
/* EasygGraphTrackϤ롣                                              */
/*   0: ,  0ʳ: (ºݤꤷ֤)                    */
int setMaxNumberOfGene(int num)  /* ꤹҿ */
{
  if (num < 0 || num > MAX_ENTRY_NUM)
    return 0;
  max_gene_number = num;
  return max_gene_number;
}

/* EasyGeneTrackϤ٤ҿθߤͤ롣                  */
int getMaxNumberOfGene()
{
  return max_gene_number;
}

/* EasyGraphTrackϤȤΥǡ̾ˡ(blend)ꤹ롣          */
/*   0: , 1:                                                  */
/*   ǥեȤblendͤѹ                                  */
int setGraphBlendPolicy(char *policy)  /* {"average", "mode", "min", "max"} */
{
  BLEND blend_enum;
  blend_enum = resolveBlend(policy);
  if (blend_enum != NOBLEND) {
    currentGraphBlend = blend_enum;
    return 1;
  } else
    return 0;
}

/* EasyGraphTrackθߤΥǡ̾ˡ(blend)롣                      */
/*   0:NOBLEND, 1:average, 2:mode, 3:min, 4:max                       */
int getGraphBlendPolicy()
{
  return currentGraphBlend;
}

/* EasyColorTrackϤȤΥǡ̾ˡ(blend)ꤹ롣          */
/*   0: , 1:                                                  */
/*   ǥեȤblendͤѹ                                  */
int setColorBlendPolicy(char *policy)      /* {"average", "mode"}           */
{
  BLEND blend_enum;
  blend_enum = resolveBlend(policy);
  if (blend_enum == average || blend_enum == mode) {
    currentColorBlend = blend_enum;
    return 1;
  } else
    return 0;
}

/* EasyColorTrackθߤΥǡ̾ˡ(blend)롣                      */
/*   0:NOBLEND, 1:average, 2:mode                                     */
int getColorBlendPolicy()
{
  return currentColorBlend;
}

/* ҾޤEasyGeneTrack/EasyGraphTrackϤ롣 */
/*   1: (EasyGeneTrack)                                     */
/*         2: (EasyGraphTrack)                                    */
/*         0:                                                           */
/*   ꤵ줿ȥ꡼EasyGeneTrack/EasyGraphTrack񤭽Ф     */
int getGeneData(char *trackname,  /* ɽ٤EasyTrack̾   */
                char *species,    /* ɽ٤                    */
                char *revision,   /* ɽ٤Υӥ        */
                char *target,     /* ɽ٤о                  */
                int  start,       /* ɽϰ(0-origin)          */
                int  end,         /* ɽλ(0-origin)          */
                int  width,       /* Ϥ٤λɸ          */
                char *date,       /* ɽ٤EasyTrackκ   */
                char *stream,     /* 襹ȥ꡼(ե)̾    */
                int  threshold,   /* EasyGraphTrackǽϤ͡ʰҿ*/
                int  bUseOptSelect,     /* ɲ°SelectǸ */
                char *strOptSelect,     /* : ɲ°Select̾   */
                char *strOptSelectEle,  /* : ɲ°Select     */
                int  bUseOptReal,    /* :   ɲ°RealǸ  */
                char *strOptReal,    /* : ɲ°Real̾        */
                double optRealLower,    /* : ɲ°Realǲ      */
                double optRealUpper     /* : ɲ°Realξ      */
		)
{
  int result;
  result = getEasyGeneOrGraphTrack
    (trackname, species, revision, target,
     start, end, width, date, stream, threshold,
     bUseOptSelect, strOptSelect, strOptSelectEle,
     bUseOptReal, strOptReal, optRealLower, optRealUpper);
  return result;
}

/* ϰϤΥǡޤEasyGraphTrackϤ롣                         */
/*   1: , 0:                                                  */
/*   ꤵ줿ȥ꡼EasyGraphTrack񤭽Ф                   */
int getGraphData(char *trackname,  /* ɽ٤EasyTrack̾   */
                 char *species,    /* ɽ٤                    */
                 char *revision,   /* ɽ٤Υӥ        */
                 char *target,     /* ɽ٤о                  */
                 int  start,       /* ɽϰ(0-origin)          */
                 int  end,         /* ɽλ(0-origin)          */
                 int  width,       /* Ϥ٤λɸ          */
                 char *date,       /* ɽ٤EasyTrackκ   */
                 char *blendname,  /* ֥ˡ                    */
                 char *stream)     /* 襹ȥ꡼(ե)̾    */
{
  EasyGraphTrack *egt;
  int result;
  BLEND gblend;

  connectCacheDB();
  egt = findEasyGraphTrack(trackname, species, revision, target, date);
  if (!egt) {
    egt = makeEasyGraphTrack(trackname, species, revision, date);
  }
  if (!egt) {
    fprintf(stderr, "*** failed to find EasyGraphTrack\n");
    return 0;
  }
  gblend = resolveBlend(blendname);
  if (gblend == NOBLEND)
    gblend = currentGraphBlend;
  result = outputGraphCache(egt, stream, start, end, width, gblend);
  destroyEasyGraphTrack(&egt);
  disconnectCacheDB();
  return result;
}

/* ϰϤΥǡޤEasyColorTrackϤ롣                         */
/*   1: , 0:                                                  */
/*   ꤵ줿ȥ꡼EasyColorTrack񤭽Ф                   */
int getColorData(char *trackname,  /* ɽ٤EasyTrack̾   */
                 char *species,    /* ɽ٤                    */
                 char *revision,   /* ɽ٤Υӥ        */
                 char *target,     /* ɽ٤о                  */
                 int  start,       /* ɽϰ(0-origin)          */
                 int  end,         /* ɽλ(0-origin)          */
                 int  width,       /* Ϥ٤λɸ          */
                 char *date,       /* ɽ٤EasyTrackκ   */
                 char *blendname,  /* ֥ˡ                    */
                 char *stream)     /* 襹ȥ꡼(ե)̾    */
{
  EasyColorTrack *ect;
  int result;
  BLEND cblend;

  connectCacheDB();
  ect = findEasyColorTrack(trackname, species, revision, target, date);
  if (!ect) {
    fprintf(stderr, "*** failed to find EasyColorTrack\n");
    return 0;
  }
  cblend = resolveBlend(blendname);
  if (cblend == NOBLEND)
    cblend = currentColorBlend;
  result = outputColorCache(ect, stream, start, end, width, cblend);
  destroyEasyColorTrack(&ect);
  disconnectCacheDB();
  return result;
}

/* DB˳ǼƤҥǡCacheե           */
/*   1: , 0:                                                 */
int createGraphCacheFile(char *name, char *species, char *revision,
                         char *target, char *path)
{
  if (!path) {
    path = assembleCacheFileName(name, species, revision, target,
                                 path, PATH_MAX_LEN + 1);
  }
  return createGraphData(name, species, revision, target, path);
}

/**************************************************************************/
/* EasyTrackեꤷơƤǡ١Ͽ          */
/* EasyGraphTrackξϥåե                     */
/*     1:   0:                                              */
/**************************************************************************/
int addEasyTrack(char *path)
{
  FILE *fp;
  char *buf;
  ET_TYPE ettype;
  EasyGeneTrack  *geneTrack = NULL;
  EasyGraphTrack *graphTrack = NULL;
  EasyColorTrack *colorTrack = NULL;
  EasyGraph  *graph = NULL;
  EasyColor  *color = NULL;
  char cachepath[PATH_MAX_LEN + 1];
  int genenum = 0;
  int graphnum = 0;
  int colornum = 0;
  int lineno = 0;
//  int bad_genenum = 0;
  int bad_graphnum = 0;
  int bad_colornum = 0;
  int result = 0;
  int stopflag = 0;

  /* EasyTrackե򳫤 */
  fp = fopen(path, "r");
  if (!fp) {
    fprintf(stderr, "addEasyTrack: cannot open file: %s\n", path);
    return 0;
  }

  /* åϿDB(cachefiles)³ */
  result = connectCacheDB();
  if (!result) {
    fprintf(stderr, "addEasyTrack: db connection is failed.\n");
    return result;
  }

  /* EasyTrackեγƹԤѡ */
  while (!stopflag && vfgets(&buf, fp)) {
    lineno++;
    ettype = identify_line(buf);
    switch (ettype) {
    case et_geneTrack:
      geneTrack = parse_geneTrack_line(buf);
      break;
    case et_graphTrack:
      graphTrack = parse_graphTrack_line(buf);
      createDirectories(graphTrack);
      break;
    case et_colorTrack:
      colorTrack = parse_colorTrack_line(buf);
      result = addEasyColorTrackToDB(colorTrack);
      if (!result)
        fprintf(stderr, "adding EasyColroTrack to DB is failed.\n");
      break;
    case et_gene:
      genenum++;
      fprintf(stderr, "-- %d gene lines are registered.\n", genenum);
      break;
    case et_graph:
      if (!graphTrack) {
        fprintf(stderr, "addEasyTrack: graph line precedes graphTrack line.\n");
        stopflag = 1;
        break;
      }
      graph = parse_graph_line(buf);
      if (!graph) {
        fprintf(stderr, "addEasyTrack: failed to parse graph line.\n");
        break;  /* ѤʹԤ̵뤷ƼιԤؿʤ */
      }
      result = addEasyGraphToDB(graphTrack, graph);
      if (result) {
        assembleCacheFileName(graphTrack->name, graphTrack->species,
                              graphTrack->revision, graph->target,
                              cachepath, PATH_MAX_LEN + 1);
//fprintf(stderr, "PATH:%s\n", cachepath);
        writeGraphValue(graph, cachepath);
        graphnum++;
        if (graphnum % 1000 == 0)
          fprintf(stderr, "-- %d graph lines are registered.\n", graphnum);
      } else {
        bad_graphnum++;
        fprintf(stderr, "!! %d graph lines are invalid.\n", bad_graphnum);
      }
      destroyEasyGraph(&graph);
      break;
    case et_color:
      if (!colorTrack) {
        fprintf(stderr, "addEasyTrack: color line precedes colorTrack line.\n");
        stopflag = 1;
        break;
      }
      color = parse_color_line(buf);
      if (!color) {
        fprintf(stderr, "addEasyTrack: failed to parse color line.\n");
        break;  /* ѤʹԤ̵뤷ƼιԤؿʤ */
      }
//dumpEasyColor(stderr, color);
      result = addEasyColorToDB(colorTrack, color);
      if (result) {
        colornum++;
        if (colornum % 1000 == 0)
          fprintf(stderr, "-- %d color lines are registered.\n", colornum);
      } else {
        bad_colornum++;
        fprintf(stderr, "!! %d color lines are invalid.\n", bad_colornum);
      }
      destroyEasyColor(&color);
      break;
    default:
      /* ٹФƼιԤؿʤ */
      fprintf(stderr, "addEasyTrack: line %d is invalid. (ignored)\n", lineno);
    }
    if (buf) {
      free(buf); onmemStrings--; /* String */
      buf = NULL;
    }
  }
  if (geneTrack) {
    ;
  }
  if (graphTrack) {
    destroyEasyGraphTrack(&graphTrack);
    fprintf(stderr, "%d graphs are registered.\n", graphnum);
  }
  if (colorTrack) {
    destroyEasyColorTrack(&colorTrack);
    fprintf(stderr, "%d colors are registered.\n", colornum);
  }
  if (shared_area) {
    free(shared_area); onmemSharedArea--; /* SharedArea */
    shared_area_size = 0;
  }
  disconnectCacheDB();
  return 1;
}

