#ifndef _ACCESS_CACHE_H_
#define _ACCESS_CACHE_H_

#include "etcache.h"
#include "easygraph.h"
#include "easycolor.h"

int connectCacheDB();      /* åDB³ */
int disconnectCacheDB();   /* åDBȤ³λ */

/* CacheѥեγǼΥѥ̾ */
char *assembleCacheFileName(char *,   /* name */
                            char *,   /* species */
                            char *,   /* revision */
                            char *,   /* target */
                            char *,   /* path: ΰΥɥ쥹NULLǤ */
                            int);     /* ѰդΰΥ */

/* ˥ޥåEasyGraphTrack 򸡺 */
EasyGraphTrack *findEasyGraphTrack(char *,   /* trackname */
                                   char *,   /* species   */
                                   char *,   /* revision  */
                                   char *,   /* target    */
                                   char *);  /* date      */

/* ξ򸵤EasyGraphTrack */
EasyGraphTrack *makeEasyGraphTrack(char *,   /* trackname */
                                   char *,   /* species   */
                                   char *,   /* revision  */
                                   char *);  /* date      */

/* ˥ޥåEasyColorTrack 򸡺 */
EasyColorTrack *findEasyColorTrack(char *,   /* trackname */
                                   char *,   /* species   */
                                   char *,   /* revision  */
                                   char *,   /* target    */
                                   char *);  /* date      */

int createGraphData(char *,   /* name       */
                    char *,   /* species    */
                    char *,   /* revision   */
                    char *,   /* target     */
                    char *);  /* outputfile */

int createColorData(char *,   /* name       */
                    char *,   /* species    */
                    char *,   /* revision   */
                    char *,   /* target     */
                    char *);  /* outputfile */

char *findCacheFileName(char *,       /* name */
                        char *,       /* species */
                        char *,       /* revision */
                        char *,       /* target */
                        int *);       /* ݤΰΥ֤ */

int addEasyGraphToDB(EasyGraphTrack *, EasyGraph *);
int addEasyColorTrackToDB(EasyColorTrack *);
int addEasyColorToDB(EasyColorTrack *, EasyColor *);

int createDirectories(EasyGraphTrack *);
int adjustWidth(int, int *, int *);

#endif
