<?php
ob_start();

require_once 'browser_common.php';
require_once 'browser_manage_common.php';

// load session
$dispparam     = $_SESSION['browser']['dispparam'];
$s = $dispparam['species'];
$r = $dispparam['revision'];
$tracks        = $_SESSION['browser']['tracks'][$s][$r];

if( array_key_exists('removedtracks',$_SESSION['browser']) && array_key_exists($s,$_SESSION['browser']['removedtracks']) && array_key_exists($r,$_SESSION['browser']['removedtracks'][$s]) ) {
	$removedtracks = $_SESSION['browser']['removedtracks'][$s][$r];
}
else {
	$_SESSION['browser']['removedtracks'][$s][$r] = $removedtracks = array();
}

// ----------------------------------------------------------------------
// 2005.5.16 modify by t.shishiki 

if ( isset($_SESSION['login']) ) {
	recompose_tracks($s,$r);
}
$tracks  = $_SESSION['browser']['tracks'][$s][$r];
$removedtracks = $_SESSION['browser']['removedtracks'][$s][$r];
// ----------------------------------------------------------------------

$reload_parent = 0;

//*****************************************
// continue process[add track/upload]
//*****************************************
if ( isset($_GET['trackurl'])) {
	$tracks = exec_regist_track_from_url($_GET['trackurl'],$tracks,$s,$r );
	 $reload_parent = 1;
}
else if( isset($_GET['uploadfile']) ) {
	$tracks = exec_regist_track_from_uploadfile($_GET['uploadfile'],$tracks,$s,$r );
	 $reload_parent = 1;
}

// process operation
$err = array();
$flag_easytrack = FALSE;
foreach( $_POST as $key => $val ) {

	if( preg_match( '/^(\d+)-up$/', $key, $match ) ) {
		$tracknum = $match[1];
		if( ! array_key_exists($tracknum,$tracks) )   { continue; }
		if( ! array_key_exists($tracknum-1,$tracks) ) { continue; }
		$tmp = $tracks[$tracknum-1];
		$tracks[$tracknum-1] = $tracks[$tracknum];
		$tracks[$tracknum] = $tmp;
		$reload_parent = 1;
		$_SESSION['browser']['tracks'][$s][$r] = $tracks;
		save_tracks_order($tracks,$s,$r,$_SESSION['login']['user_id']);
	}
	elseif( preg_match( '/^(\d+)-down$/', $key, $match ) ) {
		$tracknum = $match[1];
		if( ! array_key_exists($tracknum,$tracks) )   { continue; }
		if( ! array_key_exists($tracknum+1,$tracks) ) { continue; }
		$tmp = $tracks[$tracknum+1];
		$tracks[$tracknum+1] = $tracks[$tracknum];
		$tracks[$tracknum] = $tmp;
		$reload_parent = 1;
		$_SESSION['browser']['tracks'][$s][$r] = $tracks;
		save_tracks_order($tracks,$s,$r,$_SESSION['login']['user_id']);
	}
	elseif( preg_match( '/^(\d+)-remove$/', $key, $match ) ) {
		$tracknum = $match[1];
		if( ! array_key_exists($tracknum,$tracks) )   { continue; }
		$removedtracks[] = $tracks[$tracknum];
		array_splice( $tracks, $tracknum, 1 );
		$reload_parent = 1;
		$_SESSION['browser']['tracks'][$s][$r]        = $tracks;
		$_SESSION['browser']['removedtracks'][$s][$r] = $removedtracks;
		save_tracks_remove($removedtracks,$s,$r,$_SESSION['login']['user_id']);
	}
	elseif( preg_match( '/^(\d+)-unremove$/', $key, $match ) ) {
		$tracknum = $match[1];
		if( ! array_key_exists($tracknum,$removedtracks) )   { continue; }
		$tracks[] = $removedtracks[$tracknum];
		array_splice( $removedtracks, $tracknum, 1 );
		$reload_parent = 1;
		$_SESSION['browser']['tracks'][$s][$r]        = $tracks;
		$_SESSION['browser']['removedtracks'][$s][$r] = $removedtracks;
		save_tracks_remove($removedtracks,$s,$r,$_SESSION['login']['user_id']);
	}
	elseif( preg_match( '/^(\d+)-drop$/', $key, $match ) ) {
		$tracknum = $match[1];
		$tracks = drop_track($tracks,$tracknum,$s,$r,$_SESSION['login']['user_id']);
		$reload_parent = 1;
	}
	
	//***************************
	// Add Track
	//***************************
	elseif( $key == 'newtrack' && strlen($val) > 0 ) {
		$track_url = $val;
		if ( empty($_SESSION['login']) ) {
			$htmlSID = htmlspecialchars(SID);
			header("Location: browser_manage_user_auth.php?$htmlSID&auth_mode=add_track&val1=$track_url");
		}
		else {
		     $tracks = exec_regist_track_from_url( $track_url,$tracks,$s,$r );
			 $reload_parent = 1;
		}
	}
}
//*****************************
//	Upload
//*****************************
if (isset($_FILES['upload_easytrackfile_path'])) {

	$htmlSID = htmlspecialchars(SID);
	$uploadfile = "";
	$uploadfile = $utgb_uploaded_easytrack_dir."/".$_FILES['upload_easytrackfile_path']['name'];
	if (move_uploaded_file($_FILES['upload_easytrackfile_path']['tmp_name'], $uploadfile)) {
		$cmd = "chmod 644 $uploadfile";
		shell_exec(escapeshellcmd($cmd));
		if ( empty($_SESSION['login']) ) {
			header("Location: browser_manage_user_auth.php?$htmlSID&auth_mode=upload_easytrack&val1=$uploadfile");
		}
		else {
		     $tracks = exec_regist_track_from_uploadfile( $uploadfile,$tracks,$s,$r );
			 $reload_parent = 1;
		}
	}
	else {
		$msg  = "Fail to upload selected file.";
		show_error_message($msg);
	}
}


?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
<META http-equiv="Content-Type" content="text/html; charset=US-ASCII">
<META http-equiv="Content-Script-Type" content="text/javascript">
<META http-equiv="Content-Style-Type" content="text/css">
<TITLE>Track List</TITLE>
<SCRIPT language="JavaScript" src="browser_common.js"></SCRIPT>
<?php

 if( $reload_parent ) {
      print "<SCRIPT type=\"text/javascript\"> reloadParentWindow(); </SCRIPT>";
  }
?>
<LINK rel="stylesheet" href="style/style.css" type="text/css">
</HEAD>
<BODY>

<?php
  if( is_array($err) && count($err) > 0 ) {
    print "<HR>";
    print "<P align=\"center\">";
    foreach( $err as $e ) {
      print "<FONT color=\"#ff0000\"><B>$e</B></FONT><BR>";
    }
    print "</P>";
  }
?>
<H3>displaying tracks</H3>
<CENTER><TABLE border="0"><TBODY>
<FORM method="POST" action="<?php print $_SERVER['PHP_SELF'].'?'.htmlspecialchars(SID); ?>" name="tracks">
<TR><TH>name</TH><TH>comment</TH><TH>operation</TH></TR>
<?php
  foreach( $tracks as $tracknum => $track ) {
    $name            = $track['name'];
    $description_url = $track['description_url'];
    $comment         = $track['comment'];

		if (isset($track['track_species']) && isset($track['track_revision'])) {
			$track_species  = $track['track_species'];
			$track_revision = $track['track_revision'];
		} else {
		$track_species  = $s;
			$track_revision = $r;
		}
    print "<TR>";
    print ( strlen($description_url) > 0 ) ? "<TD><A target=\"_blank\" href=\"$description_url\">$name</A></TD>" : "<TD>$name</TD>";
    print ( strlen($comment) > 0 ) ? "<TD>$comment</TD>" : "<TD>&nbsp;</TD>";
    print "<TD><INPUT type=\"submit\" name=\"$tracknum-up\" value=\"up\">
               <INPUT type=\"submit\" name=\"$tracknum-down\" value=\"down\">
               <INPUT type=\"submit\" name=\"$tracknum-remove\" value=\"remove\">";
  	print "&nbsp;";
	$f_disp = TRUE;
	if ( is_null($track['optattr']) || isset($disable_modify[$name]) ) {
		$f_disp = FALSE;
	}
	if ( $f_disp == TRUE) {
				print "<INPUT type=\"button\" name=\"$tracknum-history\" value=\"history\" onClick=\"JavaScript: openTrackHistoryWindow('".SID."','".$track['tid']."');\">
							<INPUT type=\"button\" name=\"$tracknum-modify\" value=\"modify\" onClick=\"JavaScript: openUserAuthWindow('".SID."','$tracknum','','edit_track');\">";
	}
	else {
				print "<INPUT type=\"button\" name=\"$tracknum-history\" value=\"history\" onClick=\"JavaScript: openTrackHistoryWindow('".SID."','".$track['tid']."');\">";
	}
		print "&nbsp";
		// 2005.5.20 t.shishiki add ----------------------------------------------
		if ( isset($_SESSION['login']) && $track['exhibit'] == "private" ) {
			print "<INPUT type=\"submit\" name=\"$tracknum-drop\" value=\"drop\">";
			print "&nbsp";
		}
		//------------------------------------------------------------------------
		
    print "</TD>";
    print "</TR>";
  }

?>
</TBODY></TABLE></CENTER>
</FORM>
<?php if( is_array($removedtracks) && count($removedtracks) > 0 ) { ?>
<FORM method="POST" action="<?php print $_SERVER['PHP_SELF'].'?'.htmlspecialchars(SID); ?>" name="removedtracks">
<H3>removed tracks</H3>
<CENTER><TABLE border="0"><TBODY>
<TR><TH>name</TH><TH>comment</TH><TH>operation</TH></TR>
<?php
  foreach( $removedtracks as $tracknum => $track ) {
    $name            = $track['name'];
    $description_url = $track['description_url'];
    $comment         = $track['comment'];
    print "<TR>";
    print ( strlen($description_url) > 0 ) ? "<TD><A target=\"_blank\" href=\"$description_url\">$name</A></TD>" : "<TD>$name</TD>";
    print ( strlen($comment) > 0 ) ? "<TD>$comment</TD>" : "<TD>&nbsp;</TD>";
    print "<TD><INPUT type=\"submit\" name=\"$tracknum-unremove\" value=\"unremove\"></TD>";
    print "</TR>";
  }
?>
</TBODY></TABLE></CENTER>
</FORM>
<?php } ?>
<H3>add new track</H3>

<FORM method="POST" action="<?php print $_SERVER['PHP_SELF'].'?'.htmlspecialchars(SID); ?>" name="addtrack">
<CENTER><TABLE border="0"><TBODY>
<TR><TH>Track URL</TH><TD><INPUT size="80" type="text" name="newtrack"> <INPUT type="submit" name="newtrackbtn" value="add"></TD></TR>
</TBODY></TABLE></CENTER>
</FORM>
<H3>upload new track</H3>

<FORM method="POST" action="<?php print $_SERVER['PHP_SELF'].'?'.htmlspecialchars(SID); ?>" name="upload_easytrackfile" ENCTYPE="multipart/form-data">
<CENTER><TABLE border="0"><TBODY>
<TR><TH>EasyTrack File</TH><TD><INPUT size="70" type="file" name="upload_easytrackfile_path"> <INPUT type="submit" name="upload_easytrackfile_btn" value="upload"></TD></TR>
</TBODY></TABLE></CENTER>
</FORM>
</BODY>
</HTML>
<?php
	ob_end_flush();
?>
