<?php
  require_once 'browser_common.php';

  // load session
  $dispparam   = $_SESSION['browser']['dispparam'];
    $s = $dispparam['species'];
    $r = $dispparam['revision'];
  $tracks      = $_SESSION['browser']['tracks'];
  $width       = $dispparam['width'];

//  header( 'Content-Type: image/png' );

  $tospe = 'medaka';
  $torev = '200409';
  $interspeciesmargin = 50;
  $intraspeciesmargin = 10;
  $ignodetracknames = array( 'Overview Track', 'Zooming Track' );

  $thistracks = create_track_images( $dispparam, $tracks[$s][$r], $ignodetracknames );
  $maxtitlewidth = $thistracks['maxtitlewidth'];
  $maxindexwidth = $thistracks['maxindexwidth'];
  $totalheight   = $thistracks['totalheight'] + $interspeciesmargin;

  $syntenictracks = array();
  $syntenies = get_synteny( $s, $r, $tospe, $torev, $dispparam['target'], $dispparam['start'], $dispparam['end'] );
  foreach( $syntenies as $synteny ) {
    $dp = $dispparam;
    $dp['species']  = $tospe;
    $dp['revision'] = $torev;
    $dp['target']   = $synteny['to_target'];
    $dp['start']    = $synteny['to_start'];
    $dp['end']      = $synteny['to_end'];
    $dp['width']    = $width * abs( $synteny['to_end'] - $synteny['to_start'] ) / abs( $dispparam['end'] - $dispparam['start'] );
    $syntenictrack = create_track_images( $dp, $tracks[$tospe][$torev], $ignodetracknames );
    $maxtitlewidth = max( $maxtitlewidth, $syntenictrack['maxtitlewidth'] );
    $maxindexwidth = max( $maxindexwidth, $syntenictrack['maxindexwidth'] );
    $syntenictracks[] = $syntenictrack;
  }
  $totalheight += $syntenictracks[0]['totalheight'];

  $outimg = imagecreatetruecolor( $maxtitlewidth+$maxindexwidth+$width+1000, $totalheight );
  $bkColor = imagecolorallocate( $outimg, 0xFF, 0xFF, 0xFF );
  $penColor = imagecolorallocatealpha( $outimg, 0xFF, 0x00, 0x00, 0x20 );
  imagefilledrectangle( $outimg, 0, 0, $maxtitlewidth+$maxindexwidth+$width+1000-1, $totalheight-1, $bkColor );

  $thisheight = 0;
  foreach( $thistracks['graphicimages'] as $tracknum => $graphicimage ) {
    if( isset($thistracks['indeximages'][$tracknum]) ) {
      $indeximage = $thistracks['indeximages'][$tracknum];
      imagecopy( $outimg, $indeximage['image'], $maxtitlewidth, $thisheight, 0, 0, $indeximage['size'][0], $indeximage['size'][1] );
    }
    $thistrackheight = $graphicimage['size'][1];
    imagecopy( $outimg, $graphicimage['image'], $maxtitlewidth+$maxindexwidth, $thisheight, 0, 0, $graphicimage['size'][0], $graphicimage['size'][1] );
    $thisheight += $thistrackheight;
  }
  $thisheight += $interspeciesmargin;

  $thiswidth = $maxtitlewidth + $maxindexwidth;
  foreach( $syntenies as $i => $synteny ) {
    $thisregionheight = $thisheight;
    $thisregionwidth  = $width * abs( $synteny['to_end'] - $synteny['to_start'] ) / abs( $dispparam['end'] - $dispparam['start'] );
    $thisregionleftonfrom = $maxtitlewidth + $maxindexwidth + $width * $synteny['from_start'] / abs( $dispparam['end'] - $dispparam['start'] );
	  foreach( $syntenictracks[$i]['graphicimages'] as $tracknum => $graphicimage ) {
	    if( isset($syntenictracks[$i]['indeximages'][$tracknum]) ) {
	      $indeximage = $syntenictracks[$i]['indeximages'][$tracknum];
	      imagecopy( $outimg, $indeximage['image'], $maxtitlewidth, $thisregionheight, 0, 0, $indeximage['size'][0], $indeximage['size'][1] );
	    }
	    $thistrackheight = $graphicimage['size'][1];
	    imagecopy( $outimg, $graphicimage['image'], $thiswidth, $thisregionheight, 0, 0, $graphicimage['size'][0], $graphicimage['size'][1] );
	    $thisregionheight += $thistrackheight;
	  }
	  imageline( $outimg, $thisregionleftonfrom, $thisheight-$interspeciesmargin, $thiswidth, $thisheight, $penColor );
	  imageline( $outimg, $thisregionleftonfrom+$thisregionwidth, $thisheight-$interspeciesmargin, $thiswidth+$thisregionwidth, $thisheight, $penColor );
	  imageline( $outimg, $thisregionleftonfrom, 0, $thisregionleftonfrom, $thisheight-$interspeciesmargin, $penColor );
	  imageline( $outimg, $thisregionleftonfrom+$thisregionwidth, 0, $thisregionleftonfrom+$thisregionwidth, $thisheight-$interspeciesmargin, $penColor );
	  imageline( $outimg, $thiswidth, $thisheight, $thiswidth, $totalheight, $penColor );
	  imageline( $outimg, $thiswidth+$thisregionwidth, $thisheight, $thiswidth+$thisregionwidth, $totalheight, $penColor );

    $thiswidth += $thisregionwidth + $intraspeciesmargin;
  }

  header( 'Content-Type: image/png' );
  imagepng( $outimg );
?>
