<?php
  require_once 'browser_common.php';

  // load session
  $dispparam = $_SESSION['browser']['dispparam'];
    $s = $dispparam['species'];
    $r = $dispparam['revision'];
  $tracks    = $_SESSION['browser']['tracks'][$s][$r];

  $tracknum  = $_GET['tracknum'];
  $track     = $tracks[$tracknum];
  $trackname = $track['name'];
  $subop     = $_GET['subop'];
  $pos       = substr( $_GET['pos'], 1 );

  assert( is_numeric($tracknum) );
  assert( isset($track) );
  assert( preg_match( '/^\d+,\d+$/', $pos ) );

  // load suboperation
  $query4thistrack_str = query2string( gen_track_query( $track, $dispparam ) );
  $xmlstr = http_get( $subop.'?'.$query4thistrack_str."&pos=$pos" );
  assert( isset($xmlstr) );
  $event = parse_suboperation_xml( $xmlstr );
  assert( isset($event) );
  assert( $event['type'] == 'suboperation_layer' );

  // exec suboperation
  foreach( $event['operations'] as $oper ) {
    if( $oper['type'] == 'frame_operation' ) {
      header( 'Location: browser_frameoper_proxy.php?' . htmlspecialchars(SID) . '&' . framecommand_2_querystr($oper['commands']) );
    }
    elseif( $oper['type'] == 'link_operation' ) {
      $url = $oper['url'];
      header( 'Location: ' . $url );
      return;
    }
  }

?>
